/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;

public class PsiGraphInferenceHelper
implements PsiInferenceHelper {
    private final PsiManager myManager;

    public PsiGraphInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        InferenceSession inferenceSession = new InferenceSession(new PsiTypeParameter[]{typeParameter}, partialSubstitutor, this.myManager, parent2);
        inferenceSession.initExpressionConstraints(parameters2, arguments2, parent2, null);
        return inferenceSession.infer(parameters2, arguments2, parent2).substitute(typeParameter);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (typeParameters.length == 0) {
            PsiSubstitutor psiSubstitutor = partialSubstitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters, partialSubstitutor, this.myManager, parent2);
        inferenceSession.initExpressionConstraints(parameters2, arguments2, parent2, null);
        PsiSubstitutor psiSubstitutor = inferenceSession.infer(parameters2, arguments2, parent2);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftTypes", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightTypes", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (typeParameters.length == 0) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        InferenceSession session = new InferenceSession(typeParameters, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        for (PsiType leftType : leftTypes) {
            if (session.isProperType(session.substituteWithInferenceVariables(leftType))) continue;
            PsiSubstitutor psiSubstitutor = session.infer();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        for (PsiType rightType : rightTypes) {
            if (session.isProperType(session.substituteWithInferenceVariables(rightType))) continue;
            PsiSubstitutor psiSubstitutor = session.infer();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiType[] rightTypes;
        PsiType[] leftTypes;
        if (PsiType.VOID.equals(arg) || PsiType.VOID.equals(param)) {
            return PsiType.NULL;
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameter(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return PsiType.NULL;
        }
        if (arg == null) {
            return PsiType.NULL;
        }
        if (isContraVariantPosition) {
            leftTypes = new PsiType[]{param};
            rightTypes = new PsiType[]{arg};
        } else {
            leftTypes = new PsiType[]{arg};
            rightTypes = new PsiType[]{param};
        }
        InferenceSession inferenceSession = new InferenceSession(new PsiTypeParameter[]{typeParam}, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(param)) && inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(arg))) {
            boolean proceed = false;
            for (PsiClassType classType : typeParam.getExtendsListTypes()) {
                if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(classType))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                return PsiType.NULL;
            }
        }
        PsiSubstitutor substitutor2 = inferenceSession.infer();
        return substitutor2.substitute(typeParam);
    }
}

