/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.MarkerCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final Object lock = new Object();
    private static final ReferenceQueue<SmartPointerEx> ourQueue = new ReferenceQueue();
    private static final LowMemoryWatcher ourWatcher = LowMemoryWatcher.register(new Runnable(){

        @Override
        public void run() {
            SmartPointerManagerImpl.processQueue();
        }
    });
    private final Project myProject;
    private final Key<FilePointersList> POINTERS_KEY;
    private final PsiDocumentManagerBase myPsiDocManager;
    private static final Key<Reference<SmartPointerEx>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
        this.myPsiDocManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        this.POINTERS_KEY = Key.create("SMART_POINTERS for " + project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        PointerReference reference;
        while ((reference = (PointerReference)ourQueue.poll()) != null) {
            Object object = lock;
            synchronized (object) {
                FilePointersList pointers = (FilePointersList)reference.file.getUserData(reference.key);
                if (pointers != null) {
                    pointers.remove(reference);
                    if (pointers.isEmpty()) {
                        reference.file.putUserData(reference.key, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastenBelts(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "fastenBelts"));
        }
        SmartPointerManagerImpl.processQueue();
        Object object = lock;
        synchronized (object) {
            FilePointersList pointers = this.getPointers(file);
            if (pointers != null && !pointers.isEmpty()) {
                for (PointerReference ref : pointers.references) {
                    SmartPointerEx pointer = SoftReference.dereference(ref);
                    if (pointer == null) continue;
                    pointer.fastenBelt();
                }
            }
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPsiElementPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            PsiUtilCore.ensureValid(element);
            LOG.error("Invalid element:" + element);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPointerEx<E> pointer = SmartPointerManagerImpl.getCachedPointer(element);
        if (pointer == null) {
            pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile);
            if (containingFile != null) {
                this.initPointer((SmartPsiElementPointerImpl)pointer, containingFile.getViewProvider().getVirtualFile());
            }
            element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPointerEx<E>>(pointer));
        } else {
            Object object = lock;
            synchronized (object) {
                if (pointer instanceof SmartPsiElementPointerImpl) {
                    ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(1);
                }
            }
        }
        SmartPointerEx<E> smartPointerEx = pointer;
        if (smartPointerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiElementPointer"));
        }
        return smartPointerEx;
    }

    private static <E extends PsiElement> SmartPointerEx<E> getCachedPointer(@NotNull E element) {
        Object cachedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getCachedPointer"));
        }
        Reference<SmartPointerEx> data = element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPointerEx cachedPointer = SoftReference.dereference(data);
        if (cachedPointer != null && ((cachedElement = cachedPointer.getElement()) == null || cachedElement != element)) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        SmartPsiFileRange smartPsiFileRange = this.createSmartPsiFileRangePointer(file, range, false);
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRange;
    }

    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range, boolean forInjected) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        if (!file.isValid()) {
            LOG.error("Invalid element:" + file);
        }
        SmartPointerManagerImpl.processQueue();
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file, ProperTextRange.create(range), forInjected);
        this.initPointer(pointer, file.getViewProvider().getVirtualFile());
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "createSmartPsiFileRangePointer"));
        }
        return smartPsiFileRangePointerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends PsiElement> void initPointer(@NotNull SmartPsiElementPointerImpl<E> pointer, @NotNull VirtualFile containingFile) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "initPointer"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "initPointer"));
        }
        Object object = lock;
        synchronized (object) {
            pointer.incrementAndGetReferenceCount(1);
            this.getNotNullPointerList(containingFile).add(new PointerReference(pointer, containingFile, SmartPointerManagerImpl.ourQueue, this.POINTERS_KEY));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private FilePointersList getNotNullPointerList(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getNotNullPointerList"));
        }
        Object object = lock;
        // MONITORENTER : object
        FilePointersList pointers = this.getPointers(containingFile);
        if (pointers == null) {
            pointers = new FilePointersList(containingFile);
            containingFile.putUserData(this.POINTERS_KEY, pointers);
        }
        FilePointersList filePointersList = pointers;
        // MONITOREXIT : object
        if (filePointersList != null) return filePointersList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getNotNullPointerList"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePointer(@NotNull SmartPsiElementPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "removePointer"));
        }
        if (!(pointer instanceof SmartPsiElementPointerImpl)) {
            return false;
        }
        PsiFile containingFile = pointer.getContainingFile();
        Object object = lock;
        synchronized (object) {
            int refCount = ((SmartPsiElementPointerImpl)pointer).incrementAndGetReferenceCount(-1);
            if (refCount == 0) {
                PsiElement element = ((SmartPointerEx)pointer).getCachedElement();
                if (element != null) {
                    element.putUserData(CACHED_SMART_POINTER_KEY, null);
                }
                SmartPointerElementInfo info = ((SmartPsiElementPointerImpl)pointer).getElementInfo();
                info.cleanup();
                if (containingFile == null) {
                    return false;
                }
                VirtualFile vFile = containingFile.getViewProvider().getVirtualFile();
                FilePointersList pointers = this.getPointers(vFile);
                if (pointers == null) {
                    return false;
                }
                boolean result2 = pointers.remove(pointer);
                if (pointers.isEmpty()) {
                    vFile.putUserData(this.POINTERS_KEY, null);
                }
                return result2;
            }
        }
        return false;
    }

    @Nullable
    private FilePointersList getPointers(@NotNull VirtualFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointers"));
        }
        return containingFile.getUserData(this.POINTERS_KEY);
    }

    @NotNull
    MarkerCache getMarkerCache(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        MarkerCache markerCache = this.getNotNullPointerList(file).markerCache;
        if (markerCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getMarkerCache"));
        }
        return markerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "getPointersNumber"));
        }
        Object object = lock;
        synchronized (object) {
            VirtualFile file = containingFile.getViewProvider().getVirtualFile();
            FilePointersList pointers = this.getPointers(file);
            return pointers == null ? 0 : pointers.size;
        }
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "pointToTheSameElement"));
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }

    public void updatePointers(Document document, FrozenDocument frozen, List<DocumentEvent> events) {
        FilePointersList list2;
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FilePointersList filePointersList = list2 = file == null ? null : this.getPointers(file);
        if (list2 == null) {
            return;
        }
        list2.markerCache.updateMarkers(frozen, events);
    }

    public void updatePointerTargetsAfterReparse(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTargetsAfterReparse"));
        }
        FilePointersList list2 = this.getPointers(file);
        if (list2 == null) {
            return;
        }
        for (SmartPsiElementPointerImpl pointer : list2.getAlivePointers()) {
            if (pointer instanceof SmartPsiFileRangePointerImpl || !(pointer.getElementInfo() instanceof SelfElementInfo)) continue;
            SmartPointerManagerImpl.updatePointerTarget(pointer, pointer.getPsiRange());
        }
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl", "updatePointerTarget"));
        }
        E cachedElement = pointer.getCachedElement();
        if (cachedElement == null || cachedElement.isValid() && pointerRange != null && pointerRange.equals(cachedElement.getTextRange())) {
            return;
        }
        E newTarget = pointer.doRestoreElement();
        if (newTarget != null) {
            pointer.cacheElement(newTarget);
        }
    }

    Project getProject() {
        return this.myProject;
    }

    PsiDocumentManagerBase getPsiDocumentManager() {
        return this.myPsiDocManager;
    }

    static class FilePointersList {
        private int nextAvailableIndex;
        private int size;
        private PointerReference[] references = new PointerReference[10];
        private final MarkerCache markerCache;

        FilePointersList(VirtualFile file) {
            this.markerCache = new MarkerCache(this, file);
        }

        private void add(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "add"));
            }
            if (this.nextAvailableIndex >= this.references.length || this.nextAvailableIndex > this.size * 2) {
                int newCapacity = this.nextAvailableIndex >= this.references.length ? this.references.length * 3 / 2 + 1 : this.size * 3 / 2 + 1;
                PointerReference[] newReferences = new PointerReference[newCapacity];
                int o = 0;
                for (PointerReference oldRef : this.references) {
                    if (SoftReference.dereference(oldRef) == null) continue;
                    newReferences[o++] = oldRef;
                }
                this.references = newReferences;
                this.size = this.nextAvailableIndex = o;
            }
            this.references[this.nextAvailableIndex++] = reference;
            ++this.size;
        }

        private void remove(@NotNull PointerReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            int index2 = ArrayUtil.indexOf(this.references, reference);
            if (index2 != -1) {
                this.references[index2] = null;
                --this.size;
            }
        }

        private boolean remove(@NotNull SmartPsiElementPointer smartPointer) {
            if (smartPointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartPointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "remove"));
            }
            boolean result2 = false;
            for (int i = 0; i < this.references.length; ++i) {
                PointerReference reference = this.references[i];
                if (reference == null || reference.get() != smartPointer) continue;
                this.references[i] = null;
                --this.size;
                result2 = true;
                break;
            }
            return result2;
        }

        private boolean isEmpty() {
            return this.size == 0;
        }

        @NotNull
        List<SmartPsiElementPointerImpl> getAlivePointers() {
            List<SmartPsiElementPointerImpl> list2 = ContainerUtil.mapNotNull(this.references, new Function<PointerReference, SmartPsiElementPointerImpl>(){

                @Override
                public SmartPsiElementPointerImpl fun(PointerReference reference) {
                    return (SmartPsiElementPointerImpl)SoftReference.dereference(reference);
                }
            });
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$FilePointersList", "getAlivePointers"));
            }
            return list2;
        }
    }

    private static class PointerReference
    extends WeakReference<SmartPointerEx> {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Key<FilePointersList> key;

        private PointerReference(@NotNull SmartPointerEx<?> pointer, @NotNull VirtualFile containingFile, @NotNull ReferenceQueue<SmartPointerEx> queue, @NotNull Key<FilePointersList> key) {
            if (pointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl$PointerReference", "<init>"));
            }
            super(pointer, queue);
            this.file = containingFile;
            this.key = key;
        }
    }
}

