/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.Navigatable;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.meta.MetaRegistry;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class ClsAnnotationValueImpl
extends ClsElementImpl
implements Navigatable,
PsiAnnotation {
    private final ClsElementImpl myParent;
    private final ClsJavaCodeReferenceElementImpl myReferenceElement;
    private final ClsAnnotationParameterListImpl myParameterList;

    public ClsAnnotationValueImpl(@NotNull ClsElementImpl parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "<init>"));
        }
        this.myParent = parent2;
        this.myReferenceElement = this.createReference();
        this.myParameterList = this.createParameterList();
    }

    protected abstract ClsAnnotationParameterListImpl createParameterList();

    protected abstract ClsJavaCodeReferenceElementImpl createReference();

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "appendMirrorText"));
        }
        buffer.append("@").append(this.myReferenceElement.getCanonicalText());
        this.myParameterList.appendMirrorText(indentLevel, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsAnnotationValueImpl.setMirror(this.getNameReferenceElement(), mirror.getNameReferenceElement());
        ClsAnnotationValueImpl.setMirror(this.getParameterList(), mirror.getParameterList());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myReferenceElement, this.myParameterList};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnnotation(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        ClsAnnotationParameterListImpl clsAnnotationParameterListImpl = this.myParameterList;
        if (clsAnnotationParameterListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "getParameterList"));
        }
        return clsAnnotationParameterListImpl;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.myReferenceElement != null ? this.myReferenceElement.getCanonicalText() : null;
    }

    @Override
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return this.myReferenceElement;
    }

    @Override
    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    @Override
    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, T value) {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    @Override
    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase(this);
    }
}

