/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.FileModificationService;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondTypeImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;

public class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance("#" + PsiDiamondTypeUtil.class.getName());

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression, PsiType expectedType) {
        PsiNewExpression copy = (PsiNewExpression)expression.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy, copy, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7) && (classReference = expression.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression, context);
            if (inferenceResult.getErrorMessage() == null) {
                List<PsiType> types = inferenceResult.getInferredTypes();
                PsiType[] typeArguments2 = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments2 = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments2 == null) {
                    typeArguments2 = parameterList.getTypeArguments();
                }
                if (types.size() == typeArguments2.length) {
                    int typeArgumentsLength = typeArguments2.length;
                    for (int i = 0; i < typeArgumentsLength; ++i) {
                        PsiWildcardType wildcardType;
                        PsiType bound;
                        PsiType typeArgument = typeArguments2[i];
                        if (types.get(i) instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)types.get(i)).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(types.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                return psiElement;
            }
            PsiNewExpression expression = (PsiNewExpression)JavaPsiFacade.getElementFactory(psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            LOG.assertTrue(classReference != null);
            PsiReferenceParameterList parameterList = classReference.getParameterList();
            LOG.assertTrue(parameterList != null);
            return psiElement.replace(parameterList);
        }
        return psiElement;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof PsiJavaCodeReferenceElement)) {
            return parent2;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent2;
        StringBuilder text = new StringBuilder();
        text.append(javaCodeReferenceElement.getQualifiedName());
        text.append('<');
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result2 = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, newExpression);
        text.append(StringUtil.join(result2.getInferredTypes(), new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getCanonicalText();
            }
        }, ","));
        text.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text.toString(), element);
        return CodeStyleManager.getInstance(javaCodeReferenceElement.getProject()).reformat(javaCodeReferenceElement.replace(newReference));
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (expr instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expr).getClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes(parameterList).getParent();
        }
        return expr;
    }

    public static String getCollapsedType(PsiType type2, PsiElement context) {
        int idx;
        String typeText = type2.getCanonicalText();
        if (PsiUtil.isLanguageLevel7OrHigher(context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }
}

