/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.InheritanceImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ScopedClassHierarchy;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class JavaClassSupersImpl
extends JavaClassSupers {
    @Override
    @Nullable
    public PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope2, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperClassSubstitutor"));
        }
        if (InheritanceImplUtil.hasObjectQualifiedName(superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        return derivedClass instanceof PsiTypeParameter ? JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)derivedClass, scope2, superClass, ContainerUtil.<PsiTypeParameter>newTroveSet(), derivedSubstitutor) : JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, derivedClass, scope2, derivedSubstitutor);
    }

    @Nullable
    private static PsiSubstitutor getSuperSubstitutorWithCaching(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope resolveScope, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "getSuperSubstitutorWithCaching"));
        }
        PsiSubstitutor substitutor2 = ScopedClassHierarchy.getSuperClassSubstitutor(derivedClass, resolveScope, superClass);
        if (substitutor2 == null) {
            return null;
        }
        if (PsiUtil.isRawSubstitutor(derivedClass, derivedSubstitutor)) {
            return JavaClassSupersImpl.createRawSubstitutor(superClass);
        }
        return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor2, superClass);
    }

    @NotNull
    static PsiSubstitutor createRawSubstitutor(@NotNull PsiClass superClass) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "createRawSubstitutor"));
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(superClass.getProject()).createRawSubstitutor(superClass);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    private static PsiSubstitutor composeSubstitutors(PsiSubstitutor outer, PsiSubstitutor inner, PsiClass onClass) {
        PsiSubstitutor answer = PsiSubstitutor.EMPTY;
        Map<PsiTypeParameter, PsiType> outerMap = outer.getSubstitutionMap();
        Map<PsiTypeParameter, PsiType> innerMap = inner.getSubstitutionMap();
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(onClass)) {
            if (!outerMap.containsKey(parameter) && !innerMap.containsKey(parameter)) continue;
            answer = answer.put(parameter, outer.substitute(inner.substitute(parameter)));
        }
        PsiSubstitutor psiSubstitutor = answer;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaClassSupersImpl", "composeSubstitutors"));
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiSubstitutor processTypeParameter(PsiTypeParameter parameter, GlobalSearchScope scope2, PsiClass superClass, Set<PsiTypeParameter> visited2, PsiSubstitutor derivedSubstitutor) {
        if (parameter.getManager().areElementsEquivalent(parameter, superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        if (!visited2.add(parameter)) {
            return null;
        }
        for (PsiClassType type2 : parameter.getExtendsListTypes()) {
            PsiSubstitutor answer;
            PsiClassType.ClassResolveResult result2 = type2.resolveGenerics();
            PsiClass psiClass = result2.getElement();
            if (psiClass == null) continue;
            if (psiClass instanceof PsiTypeParameter) {
                answer = JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)psiClass, scope2, superClass, visited2, derivedSubstitutor);
                if (answer == null) continue;
                return answer;
            }
            answer = JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, psiClass, scope2, result2.getSubstitutor());
            if (answer == null) continue;
            return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, answer, superClass);
        }
        return null;
    }
}

