/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.ContributedReferenceHost;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceService;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;

public class PsiReferenceServiceImpl
extends PsiReferenceService {
    @Override
    @NotNull
    public List<PsiReference> getReferences(@NotNull PsiElement element, @NotNull PsiReferenceService.Hints hints) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
        }
        if (element instanceof ContributedReferenceHost) {
            List<PsiReference> list2 = Arrays.asList(ReferenceProvidersRegistry.getReferencesFromProviders(element, hints));
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
            }
            return list2;
        }
        List<PsiReference> list3 = Arrays.asList(element.getReferences());
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceServiceImpl", "getReferences"));
        }
        return list3;
    }
}

