/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;

public class PsiInvalidElementAccessException
extends RuntimeException {
    private static final Key<Object> INVALIDATION_TRACE = Key.create("INVALIDATION_TRACE");
    private static final Key<Boolean> REPORTING_EXCEPTION = Key.create("REPORTING_EXCEPTION");
    private final SoftReference<PsiElement> myElementReference;
    private final Attachment[] myDiagnostic;
    private final String myMessage;

    public PsiInvalidElementAccessException(@Nullable PsiElement element) {
        this(element, null, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message) {
        this(element, message, null);
    }

    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable Throwable cause) {
        this(element, null, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiInvalidElementAccessException(@Nullable PsiElement element, @Nullable String message, @Nullable Throwable cause) {
        super(null, cause);
        this.myElementReference = new SoftReference<PsiElement>(element);
        if (element == null) {
            this.myMessage = message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else if (element == PsiUtilCore.NULL_PSI_ELEMENT) {
            this.myMessage = "NULL_PSI_ELEMENT ;" + message;
            this.myDiagnostic = Attachment.EMPTY_ARRAY;
        } else {
            boolean recursiveInvocation = Boolean.TRUE.equals(element.getUserData(REPORTING_EXCEPTION));
            element.putUserData(REPORTING_EXCEPTION, Boolean.TRUE);
            try {
                Object trace = recursiveInvocation ? null : PsiInvalidElementAccessException.findInvalidationTrace(element.getNode());
                this.myMessage = PsiInvalidElementAccessException.getMessageWithReason(element, message, recursiveInvocation, trace);
                if (trace == null) {
                    this.myDiagnostic = Attachment.EMPTY_ARRAY;
                } else {
                    String diagnostic = trace instanceof Throwable ? ExceptionUtil.getThrowableText((Throwable)trace) : trace.toString();
                    this.myDiagnostic = new Attachment[]{new Attachment("diagnostic.txt", diagnostic)};
                }
            }
            finally {
                element.putUserData(REPORTING_EXCEPTION, null);
            }
        }
    }

    private static String getMessageWithReason(@NotNull PsiElement element, @Nullable String message, boolean recursiveInvocation, @Nullable Object trace) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "getMessageWithReason"));
        }
        String reason = "Element: " + element.getClass();
        if (!recursiveInvocation) {
            String traceText = !PsiInvalidElementAccessException.isTrackingInvalidation() ? "disabled" : (trace != null ? "see attachment" : "no info");
            reason = reason + " because: " + PsiInvalidElementAccessException.reason(element) + "\ninvalidated at: " + traceText;
        }
        return reason + (message == null ? "" : "; " + message);
    }

    @Override
    public String getMessage() {
        return this.myMessage;
    }

    @NotNull
    public Attachment[] getAttachments() {
        if (this.myDiagnostic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "getAttachments"));
        }
        return this.myDiagnostic;
    }

    public static Object findInvalidationTrace(@Nullable ASTNode element) {
        while (element != null) {
            Object trace = element.getUserData(INVALIDATION_TRACE);
            if (trace != null) {
                return trace;
            }
            ASTNode parent2 = element.getTreeParent();
            if (parent2 == null && element instanceof FileASTNode) {
                PsiElement psi = element.getPsi();
                Object object = trace = psi == null ? null : psi.getUserData(INVALIDATION_TRACE);
                if (trace != null) {
                    return trace;
                }
            }
            element = parent2;
        }
        return null;
    }

    @NonNls
    @NotNull
    private static String reason(@NotNull PsiElement root) {
        PsiElement context;
        PsiElement element;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
        }
        if (root == PsiUtilCore.NULL_PSI_ELEMENT) {
            if ("NULL_PSI_ELEMENT" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return "NULL_PSI_ELEMENT";
        }
        PsiElement psiElement = element = root instanceof PsiFile ? root : root.getParent();
        if (element == null) {
            String m = "parent is null";
            if (root instanceof StubBasedPsiElement) {
                for (Object stub = ((StubBasedPsiElement)root).getStub(); stub != null; stub = stub.getParentStub()) {
                    m = m + "\n  each stub=" + stub;
                    if (!(stub instanceof PsiFileStub)) continue;
                    m = m + "; fileStub.psi=" + stub.getPsi() + "; reason=" + ((PsiFileStub)stub).getInvalidationReason();
                }
            }
            String string = m;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        while (element != null && !(element instanceof PsiFile)) {
            element = element.getParent();
        }
        PsiFile file = (PsiFile)element;
        if (file == null) {
            if ("containing file is null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return "containing file is null";
        }
        FileViewProvider provider = file.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            String string = vFile + " is invalid";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        if (!provider.isPhysical() && (context = file.getContext()) != null && !context.isValid()) {
            String string = "invalid context: " + PsiInvalidElementAccessException.reason(context);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        PsiManager manager = file.getManager();
        if (manager.getProject().isDisposed()) {
            if ("project is disposed" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return "project is disposed";
        }
        Language language = file.getLanguage();
        if (language != provider.getBaseLanguage()) {
            String string = "File language:" + language + " != Provider base language:" + provider.getBaseLanguage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        FileViewProvider p = manager.findViewProvider(vFile);
        if (provider != p) {
            String string = "different providers: " + provider + "(" + PsiInvalidElementAccessException.id(provider) + "); " + p + "(" + PsiInvalidElementAccessException.id(p) + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        if (!provider.isPhysical()) {
            String string = "non-physical provider: " + provider;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        if ("psi is outdated" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "reason"));
        }
        return "psi is outdated";
    }

    private static String id(FileViewProvider provider) {
        return Integer.toHexString(System.identityHashCode(provider));
    }

    public static void setInvalidationTrace(@NotNull UserDataHolder element, Object trace) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "setInvalidationTrace"));
        }
        element.putUserData(INVALIDATION_TRACE, trace);
    }

    public static Object getInvalidationTrace(@NotNull UserDataHolder element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/PsiInvalidElementAccessException", "getInvalidationTrace"));
        }
        return element.getUserData(INVALIDATION_TRACE);
    }

    public static boolean isTrackingInvalidation() {
        return Registry.is("psi.track.invalidation");
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElementReference.get();
    }
}

