/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;

public abstract class PsiDiamondType
extends PsiType {
    public static final RecursionGuard ourDiamondGuard = RecursionManager.createGuard("diamondInference");

    public PsiDiamondType(PsiAnnotation[] annotations2) {
        super(annotations2);
    }

    public abstract DiamondInferenceResult resolveInferredTypes();

    public static class DiamondInferenceResult {
        public static final DiamondInferenceResult EXPLICIT_CONSTRUCTOR_TYPE_ARGS = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$1", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use diamonds with explicit type parameters for constructor";
            }
        };
        public static final DiamondInferenceResult NULL_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$2", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments";
            }
        };
        public static final DiamondInferenceResult UNRESOLVED_CONSTRUCTOR = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$3", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments (unable to resolve constructor)";
            }
        };
        public static final DiamondInferenceResult ANONYMOUS_INNER_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$4", "getTypes"));
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use ''<>'' with anonymous inner classes";
            }
        };
        private final List<PsiType> myInferredTypes = new ArrayList<PsiType>();
        private String myErrorMessage;
        private String myNewExpressionPresentableText;

        public DiamondInferenceResult() {
        }

        public DiamondInferenceResult(String expressionPresentableText) {
            this.myNewExpressionPresentableText = expressionPresentableText;
        }

        @NotNull
        public PsiType[] getTypes() {
            PsiType[] psiTypeArray = this.myErrorMessage == null ? this.myInferredTypes.toArray(PsiType.createArray(this.myInferredTypes.size())) : PsiType.EMPTY_ARRAY;
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult", "getTypes"));
            }
            return psiTypeArray;
        }

        public List<PsiType> getInferredTypes() {
            return this.myInferredTypes;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public boolean failedToInfer() {
            return this.myErrorMessage != null;
        }

        public void addInferredType(PsiType psiType) {
            if (this.myErrorMessage != null) {
                return;
            }
            if (psiType == null) {
                this.myErrorMessage = "Cannot infer type arguments for " + this.myNewExpressionPresentableText;
            } else {
                this.myInferredTypes.add(psiType);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiamondInferenceResult that = (DiamondInferenceResult)o;
            if (this.myErrorMessage != null ? !this.myErrorMessage.equals(that.myErrorMessage) : that.myErrorMessage != null) {
                return false;
            }
            return this.myInferredTypes.equals(that.myInferredTypes);
        }

        public int hashCode() {
            int result2 = this.myInferredTypes.hashCode();
            result2 = 31 * result2 + (this.myErrorMessage != null ? this.myErrorMessage.hashCode() : 0);
            return result2;
        }
    }
}

