/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiBlockStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaParameterType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPostfixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;

public class LambdaUtil {
    public static ThreadLocal<Map<PsiElement, PsiType>> ourFunctionTypes = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance("#" + LambdaUtil.class.getName());

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiFunctionalExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType2 = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType2);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiElement element) {
        if (element instanceof PsiFunctionalExpression) {
            PsiType samType = ((PsiFunctionalExpression)element).getFunctionalInterfaceType();
            return LambdaUtil.getFunctionalInterfaceMethod(samType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClassType.ClassResolveResult result2) {
        return LambdaUtil.getFunctionalInterfaceMethod(result2.getElement());
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClass aClass2) {
        MethodSignature methodSignature = LambdaUtil.getFunction(aClass2);
        if (methodSignature != null) {
            return LambdaUtil.getMethod(aClass2, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        PsiClass derivedClass = resolveResult.getElement();
        LOG.assertTrue(derivedClass != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            PsiType substitute = superClassSubstitutor.substitute(param);
            if (substitute == null) continue;
            initialSubst = initialSubst.put(param, initialSubst.substitute(substitute));
        }
        return initialSubst;
    }

    public static boolean isFunctionalType(PsiType type2) {
        if (type2 instanceof PsiIntersectionType) {
            return LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)type2) != null;
        }
        return LambdaUtil.isFunctionalClass(PsiUtil.resolveGenericsClassInType(type2).getElement());
    }

    @Contract(value="null -> false")
    public static boolean isFunctionalClass(PsiClass aClass2) {
        if (aClass2 != null) {
            if (aClass2 instanceof PsiTypeParameter) {
                return false;
            }
            List<HierarchicalMethodSignature> signatures = LambdaUtil.findFunctionCandidates(aClass2);
            return signatures != null && signatures.size() == 1;
        }
        return false;
    }

    public static boolean isValidLambdaContext(@Nullable PsiElement context) {
        return context instanceof PsiTypeCastExpression || context instanceof PsiAssignmentExpression || context instanceof PsiVariable || context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiExpressionList || context instanceof PsiParenthesizedExpression || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && PsiTreeUtil.getParentOfType(context, PsiTypeCastExpression.class) == null;
    }

    public static boolean isLambdaFullyInferred(PsiLambdaExpression expression, PsiType functionalInterfaceType) {
        boolean hasParams;
        boolean bl = hasParams = expression.getParameterList().getParametersCount() > 0;
        if (hasParams || !PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType))) {
            return !LambdaUtil.dependsOnTypeParams(functionalInterfaceType, functionalInterfaceType, expression, new PsiTypeParameter[0]);
        }
        return true;
    }

    @Nullable
    public static MethodSignature getFunction(PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        List<HierarchicalMethodSignature> functions2 = LambdaUtil.findFunctionCandidates(psiClass);
        if (functions2 != null && functions2.size() == 1) {
            return functions2.get(0);
        }
        return null;
    }

    private static boolean overridesPublicObjectMethod(HierarchicalMethodSignature psiMethod) {
        PsiMethod method;
        PsiClass containingClass;
        List<HierarchicalMethodSignature> signatures = psiMethod.getSuperSignatures();
        if (signatures.isEmpty() && (containingClass = (method = psiMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && method.hasModifierProperty("public")) {
            return true;
        }
        for (HierarchicalMethodSignature superMethod : signatures) {
            if (!LambdaUtil.overridesPublicObjectMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @Nullable
    private static List<HierarchicalMethodSignature> hasSubsignature(List<HierarchicalMethodSignature> signatures) {
        for (HierarchicalMethodSignature signature2 : signatures) {
            boolean subsignature = true;
            for (HierarchicalMethodSignature methodSignature : signatures) {
                if (signature2.equals(methodSignature) || MethodSignatureUtil.isSubsignature(signature2, methodSignature) || LambdaUtil.skipMethod(signature2, methodSignature)) continue;
                subsignature = false;
                break;
            }
            if (!subsignature) continue;
            return Collections.singletonList(signature2);
        }
        return signatures;
    }

    private static boolean skipMethod(HierarchicalMethodSignature signature2, HierarchicalMethodSignature methodSignature) {
        if (methodSignature.getTypeParameters().length == 0) {
            return false;
        }
        return signature2.getMethod().getContainingClass() != methodSignature.getMethod().getContainingClass();
    }

    @Nullable
    public static List<HierarchicalMethodSignature> findFunctionCandidates(PsiClass psiClass) {
        if (psiClass != null && psiClass.isInterface() && !psiClass.isAnnotationType()) {
            ArrayList<HierarchicalMethodSignature> methods2 = new ArrayList<HierarchicalMethodSignature>();
            Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
            for (HierarchicalMethodSignature signature2 : visibleSignatures) {
                PsiMethod psiMethod = signature2.getMethod();
                if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static") || LambdaUtil.overridesPublicObjectMethod(signature2)) continue;
                methods2.add(signature2);
            }
            return LambdaUtil.hasSubsignature(methods2);
        }
        return null;
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        if (methodSignature instanceof MethodSignatureBackedByPsiMethod) {
            return ((MethodSignatureBackedByPsiMethod)methodSignature).getMethod();
        }
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            if (!PsiTreeUtil.isAncestor(expression, element, false)) continue;
            return i;
        }
        return -1;
    }

    public static boolean dependsOnTypeParams(PsiType type2, PsiType functionalInterfaceType, PsiElement lambdaExpression, PsiTypeParameter ... param2Check) {
        return LambdaUtil.depends(type2, new TypeParamsChecker(lambdaExpression, PsiUtil.resolveClassInType(functionalInterfaceType)), param2Check);
    }

    public static boolean depends(PsiType type2, TypeParamsChecker visitor2, PsiTypeParameter ... param2Check) {
        if (!visitor2.startedInference()) {
            return false;
        }
        Boolean accept = type2.accept(visitor2);
        if (param2Check.length > 0) {
            return visitor2.used(param2Check);
        }
        return accept != null && accept != false;
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression, boolean tryToSubstitute) {
        PsiType type2;
        PsiElement parent2 = expression.getParent();
        PsiElement element = expression;
        while (!(!(parent2 instanceof PsiParenthesizedExpression) && !(parent2 instanceof PsiConditionalExpression) || parent2 instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent2).getThenExpression() != element && ((PsiConditionalExpression)parent2).getElseExpression() != element)) {
            element = parent2;
            parent2 = parent2.getParent();
        }
        Map<PsiElement, PsiType> map2 = ourFunctionTypes.get();
        if (map2 != null && (type2 = map2.get(expression)) != null) {
            return type2;
        }
        if (parent2 instanceof PsiArrayInitializerExpression) {
            PsiType psiType = ((PsiArrayInitializerExpression)parent2).getType();
            if (psiType instanceof PsiArrayType) {
                return ((PsiArrayType)psiType).getComponentType();
            }
        } else {
            if (parent2 instanceof PsiTypeCastExpression) {
                PsiType conjunct;
                PsiType castType;
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)parent2).getCastType();
                PsiType psiType = castType = castTypeElement != null ? castTypeElement.getType() : null;
                if (castType instanceof PsiIntersectionType && (conjunct = LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)castType)) != null) {
                    return conjunct;
                }
                return castType;
            }
            if (parent2 instanceof PsiVariable) {
                return ((PsiVariable)parent2).getType();
            }
            if (parent2 instanceof PsiAssignmentExpression && expression instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent2).getLExpression();
                return lExpression.getType();
            }
            if (parent2 instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent2;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression);
                if (lambdaIdx > -1) {
                    PsiElement gParent = expressionList.getParent();
                    if (gParent instanceof PsiAnonymousClass) {
                        gParent = gParent.getParent();
                    }
                    if (gParent instanceof PsiCall) {
                        PsiParameter[] parameters2;
                        int finalLambdaIdx;
                        JavaResolveResult resolveResult;
                        PsiElement resolve2;
                        PsiCall contextCall = (PsiCall)gParent;
                        MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(contextCall.getArgumentList());
                        if (properties2 != null && properties2.isApplicabilityCheck()) {
                            PsiParameter[] parameters3 = properties2.getMethod().getParameterList().getParameters();
                            int finalLambdaIdx2 = LambdaUtil.adjustLambdaIdx(lambdaIdx, properties2.getMethod(), parameters3);
                            if (finalLambdaIdx2 < parameters3.length) {
                                return properties2.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters3[finalLambdaIdx2]));
                            }
                        }
                        if ((resolve2 = (resolveResult = properties2 != null ? properties2.getInfo() : contextCall.resolveMethodGenerics()).getElement()) instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve2, parameters2 = ((PsiMethod)resolve2).getParameterList().getParameters())) < parameters2.length) {
                            if (!tryToSubstitute) {
                                return LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]);
                            }
                            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, !MethodCandidateInfo.isOverloadCheck(), new Computable<PsiType>(){

                                @Override
                                public PsiType compute() {
                                    return resolveResult.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]));
                                }
                            });
                        }
                        return null;
                    }
                }
            } else if (parent2 instanceof PsiReturnStatement) {
                Object gParent = PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, PsiMethod.class);
                if (gParent instanceof PsiLambdaExpression) {
                    return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)gParent);
                }
                if (gParent instanceof PsiMethod) {
                    return ((PsiMethod)gParent).getReturnType();
                }
            } else if (parent2 instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)parent2);
            }
        }
        return null;
    }

    @Nullable
    private static PsiType extractFunctionalConjunct(PsiIntersectionType type2) {
        PsiType conjunct = null;
        for (PsiType conjunctType : type2.getConjuncts()) {
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(conjunctType);
            if (interfaceMethod == null) continue;
            if (conjunct != null && !conjunct.equals(conjunctType)) {
                return null;
            }
            conjunct = conjunctType;
        }
        return conjunct;
    }

    private static PsiType getFunctionalInterfaceTypeByContainingLambda(@NotNull PsiLambdaExpression parentLambda) {
        if (parentLambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLambda", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "getFunctionalInterfaceTypeByContainingLambda"));
        }
        PsiType parentInterfaceType = parentLambda.getFunctionalInterfaceType();
        return parentInterfaceType != null ? LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType) : null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve2, PsiParameter[] parameters2) {
        int finalLambdaIdx = resolve2.isVarArgs() && lambdaIdx >= parameters2.length ? parameters2.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type2 = parameter.getType();
        if (type2 instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type2).getComponentType();
        }
        return type2;
    }

    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    public static boolean isLambdaReturnExpression(PsiElement element) {
        PsiElement parent2 = element.getParent();
        return parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, true, PsiMethod.class) != null;
    }

    public static PsiReturnStatement[] getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        return body instanceof PsiCodeBlock ? PsiUtil.findReturnStatements((PsiCodeBlock)body) : PsiReturnStatement.EMPTY_ARRAY;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body);
        }
        ArrayList<PsiExpression> result2 = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result2.add(returnValue);
        }
        return result2;
    }

    public static boolean isValidQualifier4InterfaceStaticMethodCall(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression, @Nullable PsiElement scope2, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        return LambdaUtil.getInvalidQualifier4StaticInterfaceMethodMessage(method, methodReferenceExpression, scope2, languageLevel) == null;
    }

    @Nullable
    public static String getInvalidQualifier4StaticInterfaceMethodMessage(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression, @Nullable PsiElement scope2, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "getInvalidQualifier4StaticInterfaceMethodMessage"));
        }
        PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
            if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                return "Static interface method invocations are not supported at this language level";
            }
            if (qualifierExpression == null && (scope2 instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor(containingClass, methodReferenceExpression, true))) {
                return null;
            }
            if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve2 == containingClass) {
                    return null;
                }
                if (resolve2 instanceof PsiTypeParameter) {
                    HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                    for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                        PsiClass aClass2 = type2.resolve();
                        if (aClass2 == null) continue;
                        classes2.add(aClass2);
                    }
                    if (classes2.size() == 1 && classes2.contains(containingClass)) {
                        return null;
                    }
                }
            }
            return "Static method may be invoked on containing interface class only";
        }
        return null;
    }

    public static boolean isExpressionStatementExpression(PsiElement body) {
        return body instanceof PsiAssignmentExpression || body instanceof PsiPrefixExpression && (((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiPrefixExpression)body).getOperationTokenType() == JavaTokenType.MINUSMINUS) || body instanceof PsiPostfixExpression || body instanceof PsiCallExpression || body instanceof PsiReferenceExpression && !body.isPhysical();
    }

    public static PsiExpression extractSingleExpressionFromBody(PsiElement body) {
        PsiExpression expression = null;
        if (body instanceof PsiExpression) {
            expression = (PsiExpression)body;
        } else if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length == 1) {
                if (statements[0] instanceof PsiReturnStatement) {
                    expression = ((PsiReturnStatement)statements[0]).getReturnValue();
                } else if (statements[0] instanceof PsiExpressionStatement) {
                    expression = ((PsiExpressionStatement)statements[0]).getExpression();
                } else if (statements[0] instanceof PsiBlockStatement) {
                    return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)statements[0]).getCodeBlock());
                }
            }
        } else {
            if (body instanceof PsiBlockStatement) {
                return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)body).getCodeBlock());
            }
            if (body instanceof PsiExpressionStatement) {
                expression = ((PsiExpressionStatement)body).getExpression();
            }
        }
        return expression;
    }

    public static boolean isPotentiallyCompatibleWithTypeParameter(PsiFunctionalExpression expression, PsiExpressionList argsList, PsiMethod method) {
        PsiParameter[] parameters2;
        PsiParameter lambdaParameter;
        PsiClass paramClass;
        PsiCallExpression callExpression;
        if (!(Registry.is("JDK8042508.bug.fixed", false) || (callExpression = PsiTreeUtil.getParentOfType((PsiElement)argsList, PsiCallExpression.class)) != null && callExpression.getTypeArguments().length <= 0)) {
            return false;
        }
        int lambdaIdx = LambdaUtil.getLambdaIdx(argsList, expression);
        return lambdaIdx >= 0 && (paramClass = PsiUtil.resolveClassInType((lambdaParameter = (parameters2 = method.getParameterList().getParameters())[Math.min(lambdaIdx, parameters2.length - 1)]).getType())) instanceof PsiTypeParameter && ((PsiTypeParameter)paramClass).getOwner() == method;
    }

    @NotNull
    public static Map<PsiElement, PsiType> getFunctionalTypeMap() {
        Map<PsiElement, PsiType> map2 = ourFunctionTypes.get();
        if (map2 == null) {
            map2 = new HashMap<PsiElement, PsiType>();
            ourFunctionTypes.set(map2);
        }
        Map<PsiElement, PsiType> map3 = map2;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil", "getFunctionalTypeMap"));
        }
        return map3;
    }

    public static String checkReturnTypeCompatible(PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceReturnType) {
        if (PsiType.VOID.equals(functionalInterfaceReturnType)) {
            PsiElement body = lambdaExpression.getBody();
            if (body instanceof PsiCodeBlock) {
                if (!LambdaUtil.getReturnExpressions(lambdaExpression).isEmpty()) {
                    return "Unexpected return value";
                }
            } else if (body instanceof PsiExpression) {
                PsiType type2 = ((PsiExpression)body).getType();
                try {
                    if (!PsiUtil.isStatement(JavaPsiFacade.getElementFactory(body.getProject()).createStatementFromText(body.getText(), body))) {
                        return "Bad return type in lambda expression: " + (type2 == PsiType.NULL || type2 == null ? "<null>" : type2.getPresentableText()) + " cannot be converted to void";
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {}
            }
        } else if (functionalInterfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (final PsiExpression expression : returnExpressions) {
                PsiType expressionType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, true, new Computable<PsiType>(){

                    @Override
                    public PsiType compute() {
                        return expression.getType();
                    }
                });
                if (expressionType == null || functionalInterfaceReturnType.isAssignableFrom(expressionType)) continue;
                return "Bad return type in lambda expression: " + expressionType.getPresentableText() + " cannot be converted to " + functionalInterfaceReturnType.getPresentableText();
            }
            if (LambdaUtil.getReturnStatements(lambdaExpression).length > returnExpressions.size() || returnExpressions.isEmpty() && !lambdaExpression.isVoidCompatible()) {
                return "Missing return value";
            }
        }
        return null;
    }

    public static class TypeParamsChecker
    extends PsiTypeVisitor<Boolean> {
        private PsiMethod myMethod;
        private final PsiClass myClass;
        public final Set<PsiTypeParameter> myUsedTypeParams = new HashSet<PsiTypeParameter>();

        public TypeParamsChecker(PsiElement expression, PsiClass aClass2) {
            PsiElement gParent;
            PsiElement parent2;
            this.myClass = aClass2;
            PsiElement psiElement = parent2 = expression != null ? expression.getParent() : null;
            while (parent2 instanceof PsiParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof PsiExpressionList && (gParent = parent2.getParent()) instanceof PsiCall) {
                MethodCandidateInfo.CurrentCandidateProperties pair = MethodCandidateInfo.getCurrentMethod(parent2);
                PsiMethod psiMethod = this.myMethod = pair != null ? pair.getMethod() : null;
                if (this.myMethod == null) {
                    this.myMethod = ((PsiCall)gParent).resolveMethod();
                }
                if (this.myMethod != null && PsiTreeUtil.isAncestor(this.myMethod, expression, false)) {
                    this.myMethod = null;
                }
            }
        }

        public boolean startedInference() {
            return this.myMethod != null;
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiTypeParameter typeParameter;
            boolean used = false;
            for (PsiType paramType : classType.getParameters()) {
                Boolean paramAccepted = paramType.accept(this);
                used |= paramAccepted != null && paramAccepted != false;
            }
            PsiClass resolve2 = classType.resolve();
            if (resolve2 instanceof PsiTypeParameter && this.check(typeParameter = (PsiTypeParameter)resolve2)) {
                this.myUsedTypeParams.add(typeParameter);
                return true;
            }
            return used;
        }

        @Override
        @Nullable
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                return bound.accept(this);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return this.visitWildcardType(capturedWildcardType.getWildcard());
        }

        @Override
        @Nullable
        public Boolean visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitType(PsiType type2) {
            return false;
        }

        private boolean check(PsiTypeParameter check) {
            PsiTypeParameterListOwner owner = check.getOwner();
            if (owner == this.myMethod) {
                return true;
            }
            return owner == this.myClass;
        }

        public boolean used(PsiTypeParameter ... parameters2) {
            for (PsiTypeParameter parameter : parameters2) {
                if (!this.myUsedTypeParams.contains(parameter)) continue;
                return true;
            }
            return false;
        }
    }
}

