/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress.util;

import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.util.ProgressIndicatorStacked;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.ui.mac.foundation.MacUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicatorStacked {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate;
    private volatile Object myMacActivity;
    private volatile boolean myShouldStartActivity = true;
    private volatile int myNonCancelableCount;
    protected ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private static final Set<Class> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning(), "Attempt to start ProgressIndicator which is already running");
        if (this.myFinished) {
            if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(this.getClass())) {
                LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + this + "," + this.getClass());
            }
            this.myCanceled = false;
            this.myFinished = false;
        }
        this.myText = "";
        this.myFraction = 0.0;
        this.myText2 = "";
        this.startSystemActivity();
        this.myRunning = true;
    }

    protected boolean isReuseable() {
        return false;
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(this.myRunning, "stop() should be called only if start() called before");
        this.myRunning = false;
        this.myFinished = true;
        this.stopSystemActivity();
    }

    protected void startSystemActivity() {
        this.myMacActivity = this.myShouldStartActivity ? MacUtil.wakeUpNeo(this.toString()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSystemActivity() {
        if (this.myMacActivity != null) {
            Object object = this.myMacActivity;
            synchronized (object) {
                MacUtil.matrixHasYou(this.myMacActivity);
                this.myMacActivity = null;
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled(this);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.myCanceled;
    }

    @Override
    public void checkCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            throw new ProcessCanceledException();
        }
    }

    protected boolean isCancelable() {
        return this.myNonCancelableCount == 0;
    }

    @Override
    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @Override
    @NotNull
    public final ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/util/AbstractProgressIndicatorBase", "getModalityState"));
        }
        return modalityState;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }
}

