/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.progress.Task;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager progressManager = ProgressManagerHolder.ourInstance;
        if (progressManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/ProgressManager", "getInstance"));
        }
        return progressManager;
    }

    public abstract void runProcess(@NotNull Runnable var1, ProgressIndicator var2) throws ProcessCanceledException;

    @Override
    public ProgressIndicator getProgressIndicator() {
        return null;
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public abstract void run(@NotNull Task var1);

    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/ProgressManager", "indicatorCanceled"));
        }
    }

    public static void canceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/ProgressManager", "canceled"));
        }
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager.getInstance().doCheckCanceled();
    }

    public abstract void executeProcessUnderProgress(@NotNull Runnable var1, @Nullable(value="null means reuse current progress") ProgressIndicator var2) throws ProcessCanceledException;

    private static class ProgressManagerHolder {
        private static final ProgressManager ourInstance = ServiceManager.getService(ProgressManager.class);
    }
}

