/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiParser;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaDocLexer;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaLexer;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class JavaParserDefinition
implements ParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        LanguageLevel level = project != null ? LanguageLevelProjectExtension.getInstance(project).getLanguageLevel() : LanguageLevel.HIGHEST;
        Lexer lexer = JavaParserDefinition.createLexer(level);
        if (lexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "createLexer"));
        }
        return lexer;
    }

    @NotNull
    public static Lexer createLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "createLexer"));
        }
        JavaLexer javaLexer = new JavaLexer(level);
        if (javaLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "createLexer"));
        }
        return javaLexer;
    }

    @NotNull
    public static Lexer createDocLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "createDocLexer"));
        }
        JavaDocLexer javaDocLexer = new JavaDocLexer(level);
        if (javaDocLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "createDocLexer"));
        }
        return javaDocLexer;
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JavaStubElementTypes.JAVA_FILE;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = ElementType.JAVA_WHITESPACE_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = ElementType.JAVA_COMMENT_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create(JavaElementType.LITERAL_EXPRESSION);
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 instanceof JavaStubElementType) {
            Object PsiT = ((JavaStubElementType)type2).createPsi(node);
            if (PsiT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/java/JavaParserDefinition", "createElement"));
            }
            return PsiT;
        }
        throw new IllegalStateException("Incorrect node for JavaParserDefinition: " + node + " (" + type2 + ")");
    }

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiJavaFileImpl(viewProvider);
    }

    @Override
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text;
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN || left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        PsiFile containingFile = left.getTreeParent().getPsi().getContainingFile();
        LanguageLevel level = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getLanguageLevel() : LanguageLevel.HIGHEST;
        Lexer lexer = JavaParserDefinition.createLexer(level);
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer(left, right, lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (text = left.getText()).length() > 0 && Character.isWhitespace(text.charAt(text.length() - 1))) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA ? (text = right.getText()).length() > 0 && Character.isWhitespace(text.charAt(0)) : right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        return spaceRequirements;
    }
}

