/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.DefaultASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiCoreCommentImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;

public class CoreASTFactory
extends ASTFactory
implements DefaultASTFactory {
    @Override
    @NotNull
    public LazyParseableElement createLazy(ILazyParseableElementType type2, CharSequence text) {
        if (type2 instanceof IFileElementType) {
            FileElement fileElement = new FileElement(type2, text);
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createLazy"));
            }
            return fileElement;
        }
        LazyParseableElement lazyParseableElement = new LazyParseableElement(type2, text);
        if (lazyParseableElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createLazy"));
        }
        return lazyParseableElement;
    }

    @Override
    @NotNull
    public CompositeElement createComposite(IElementType type2) {
        if (type2 instanceof IFileElementType) {
            FileElement fileElement = new FileElement(type2, null);
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createComposite"));
            }
            return fileElement;
        }
        CompositeElement compositeElement = new CompositeElement(type2);
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createComposite"));
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public LeafElement createLeaf(@NotNull IElementType type2, @NotNull CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createLeaf"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createLeaf"));
        }
        Language lang = type2.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null && parserDefinition.getCommentTokens().contains(type2)) {
            LeafElement leafElement = this.createComment(type2, text);
            if (leafElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createLeaf"));
            }
            return leafElement;
        }
        LeafPsiElement leafPsiElement = new LeafPsiElement(type2, text);
        if (leafPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createLeaf"));
        }
        return leafPsiElement;
    }

    @Override
    @NotNull
    public LeafElement createComment(@NotNull IElementType type2, @NotNull CharSequence text) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createComment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createComment"));
        }
        PsiCoreCommentImpl psiCoreCommentImpl = new PsiCoreCommentImpl(type2, text);
        if (psiCoreCommentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CoreASTFactory", "createComment"));
        }
        return psiCoreCommentImpl;
    }
}

