/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.FileModificationService;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "org/jetbrains/kotlin/com/intellij/codeInsight/CodeInsightUtilCore", "parseStringCharacters"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "org/jetbrains/kotlin/com/intellij/codeInsight/CodeInsightUtilCore", "parseStringCharacters"));
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index2 = 0;
        int outOffset = outChars.length();
        while (index2 < chars.length()) {
            char c = chars.charAt(index2++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index2 - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index2;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index2 == chars.length()) {
                return false;
            }
            c = chars.charAt(index2++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\"': {
                    outChars.append('\"');
                    break;
                }
                case '\'': {
                    outChars.append('\'');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index2 < chars.length()) {
                        if ('0' <= (c = chars.charAt(index2++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index2 < chars.length()) {
                                if ('0' <= (c = chars.charAt(index2++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index2;
                                }
                            }
                        } else {
                            --index2;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    while (index2 != chars.length() && chars.charAt(index2) == 'u') {
                        ++index2;
                    }
                    if (index2 + 4 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index2, index2 + 4), 16);
                            if (code == 10 || code == 13) {
                                return false;
                            }
                            c = chars.charAt(index2);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index2 += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index2;
        }
        return true;
    }
}

