/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.com.google.dart.compiler.util.AstUtil;

public final class JsArrayAccess
extends JsExpressionImpl {
    private JsExpression arrayExpression;
    private JsExpression indexExpression;

    public JsArrayAccess() {
    }

    public JsArrayAccess(JsExpression arrayExpression, JsExpression indexExpression) {
        this.arrayExpression = arrayExpression;
        this.indexExpression = indexExpression;
    }

    public JsExpression getArrayExpression() {
        return this.arrayExpression;
    }

    public JsExpression getIndexExpression() {
        return this.indexExpression;
    }

    public void setArrayExpression(JsExpression arrayExpression) {
        this.arrayExpression = arrayExpression;
    }

    public void setIndexExpression(JsExpression indexExpression) {
        this.indexExpression = indexExpression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitArrayAccess(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.arrayExpression);
        visitor2.accept(this.indexExpression);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.arrayExpression = v.accept(this.arrayExpression);
            this.indexExpression = v.accept(this.indexExpression);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsArrayAccess deepCopy() {
        JsExpression arrayCopy = AstUtil.deepCopy(this.arrayExpression);
        JsExpression indexCopy = AstUtil.deepCopy(this.indexExpression);
        JsArrayAccess jsArrayAccess = new JsArrayAccess(arrayCopy, indexCopy).withMetadataFrom(this);
        if (jsArrayAccess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsArrayAccess", "deepCopy"));
        }
        return jsArrayAccess;
    }
}

