/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a,\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u001a\u001e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012\u001a&\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c\u001a'\u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00010 H\u0086\b\u001a'\u0010#\u001a\u00020\u0001*\u00020\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010 H\u0086\b\u001a!\u0010\u000b\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010%*\u00020&*\b\u0012\u0004\u0012\u0002H%0\u0014\u00a2\u0006\u0002\u0010'\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00032\u0006\u0010)\u001a\u00020\u0012\u00a8\u0006*"}, d2={"generateLoadInstructions", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "location", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "generateStoreInstructions", "getPopInstruction", "Lorg/jetbrains/org/objectweb/asm/tree/InsnNode;", "top", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "removeAlwaysFalseIfeq", "node", "replaceAlwaysTrueIfeqWithGoto", "replaceMarkerWithPops", "expectedStackSize", "", "frame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "restoreStack", "restoreStackWithReturnValue", "nodeToReplace", "returnValue", "returnValueLocalVarIndex", "saveStack", "restoreImmediately", "", "forEachInlineMarker", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "block", "Lkotlin/Function2;", "", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "forEachPseudoInsn", "Lorg/jetbrains/kotlin/codegen/pseudoInsns/PseudoInsn;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "updateMaxLocals", "newMaxLocals", "kotlin-compiler"})
public final class StackTransformationUtilsKt {
    public static final void forEachPseudoInsn(@NotNull InsnList $receiver, @NotNull Function2<? super PseudoInsn, ? super AbstractInsnNode, Unit> block) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Sequence $receiver$iv = new InsnSequence($receiver);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Unit unit;
            Object element$iv = iterator2.next();
            AbstractInsnNode insn = (AbstractInsnNode)element$iv;
            if (PseudoInsnsKt.parsePseudoInsnOrNull(insn) != null) {
                PseudoInsn pseudoInsn;
                PseudoInsn it = pseudoInsn;
                block.invoke(it, insn);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
    }

    public static final void forEachInlineMarker(@NotNull InsnList $receiver, @NotNull Function2<? super String, ? super MethodInsnNode, Unit> block) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(block, "block");
        Sequence $receiver$iv = new InsnSequence($receiver);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            AbstractInsnNode insn = (AbstractInsnNode)element$iv;
            if (!InlineCodegenUtil.isInlineMarker(insn)) continue;
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
            }
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            String string = methodInsnNode.name;
            Intrinsics.checkExpressionValueIsNotNull(string, "methodInsnNode.name");
            block.invoke(string, methodInsnNode);
        }
    }

    @Nullable
    public static final <V extends Value> V top(@NotNull Frame<V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        int stackSize = $receiver.getStackSize();
        if (stackSize == 0) {
            return (V)((Value)null);
        }
        return $receiver.getStack(stackSize - 1);
    }

    public static final void updateMaxLocals(@NotNull MethodNode $receiver, int newMaxLocals) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.maxLocals = Math.max($receiver.maxLocals, newMaxLocals);
    }

    public static final void saveStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, boolean restoreImmediately) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        StackTransformationUtilsKt.generateStoreInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        if (restoreImmediately) {
            StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        }
        $receiver.remove(nodeToReplace);
    }

    public static final void restoreStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, location2, savedStackDescriptor);
        $receiver.remove(location2);
    }

    public static final void restoreStackWithReturnValue(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, @NotNull BasicValue returnValue, int returnValueLocalVarIndex) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        Intrinsics.checkParameterIsNotNull(returnValue, "returnValue");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(54), returnValueLocalVarIndex));
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(21), returnValueLocalVarIndex));
        $receiver.remove(nodeToReplace);
    }

    public static final void generateLoadInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstLocalVarIndex();
        for (BasicValue value : savedStackDescriptor.getSavedValues()) {
            methodNode.instructions.insertBefore(location2, new VarInsnNode(value.getType().getOpcode(21), localVarIndex));
            localVarIndex += value.getSize();
        }
    }

    public static final void generateStoreInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstUnusedLocalVarIndex();
        for (BasicValue value : CollectionsKt.asReversed(savedStackDescriptor.getSavedValues())) {
            methodNode.instructions.insertBefore(location2, new VarInsnNode(value.getType().getOpcode(54), localVarIndex -= value.getSize()));
        }
    }

    @NotNull
    public static final InsnNode getPopInstruction(@NotNull BasicValue top) {
        int n;
        Intrinsics.checkParameterIsNotNull(top, "top");
        switch (top.getSize()) {
            case 1: {
                n = 87;
                break;
            }
            case 2: {
                n = 88;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)"Unexpected value type size"));
            }
        }
        return new InsnNode(n);
    }

    public static final void removeAlwaysFalseIfeq(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        $receiver.remove(node.getNext());
        $receiver.remove(node);
    }

    public static final void replaceAlwaysTrueIfeqWithGoto(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        AbstractInsnNode abstractInsnNode = node.getNext();
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        JumpInsnNode next = (JumpInsnNode)abstractInsnNode;
        $receiver.insertBefore(node, new JumpInsnNode(167, next.label));
        $receiver.remove(node);
        $receiver.remove(next);
    }

    public static final void replaceMarkerWithPops(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node, int expectedStackSize, @NotNull Frame<BasicValue> frame) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(frame, "frame");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        while (frame.getStackSize() > expectedStackSize) {
            BasicValue top;
            BasicValue basicValue = top = frame.pop();
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "top");
            $receiver.insertBefore(node, StackTransformationUtilsKt.getPopInstruction(basicValue));
        }
        $receiver.remove(node);
    }
}

