/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.Interval;
import org.jetbrains.kotlin.codegen.inline.SplitPair;
import org.jetbrains.kotlin.codegen.inline.SplittableInterval;
import org.jetbrains.kotlin.com.google.common.collect.LinkedListMultimap;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J:\u0010\u0019\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001eJ\u001d\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010#\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$J)\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001e\u00a2\u0006\u0002\u0010-J)\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001e\u00a2\u0006\u0002\u0010-J\u000e\u0010/\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+J\"\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000(0\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRQ\u0010\r\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000 \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012RQ\u0010\u0013\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000 \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "T", "Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;", "", "()V", "allIntervals", "Ljava/util/ArrayList;", "getAllIntervals", "()Ljava/util/ArrayList;", "currentIntervals", "", "getCurrentIntervals", "()Ljava/util/Set;", "intervalEnds", "Lorg/jetbrains/kotlin/com/google/common/collect/LinkedListMultimap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "kotlin.jvm.PlatformType", "getIntervalEnds", "()Lcom/google/common/collect/LinkedListMultimap;", "intervalStarts", "getIntervalStarts", "addNewInterval", "", "newInfo", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "getInterval", "", "", "curIns", "isOpen", "", "processCurrent", "directOrder", "remapEndLabel", "oldEnd", "remapped", "(Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;)V", "remapStartLabel", "oldStart", "split", "Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "interval", "by", "Lorg/jetbrains/kotlin/codegen/inline/Interval;", "keepStart", "(Lorg/jetbrains/kotlin/codegen/inline/SplittableInterval;Lorg/jetbrains/kotlin/codegen/inline/Interval;Z)Lorg/jetbrains/kotlin/codegen/inline/SplitPair;", "splitAndRemoveInterval", "splitAndRemoveIntervalsFromCurrents", "splitCurrentIntervals", "kotlin-compiler"})
public final class IntervalMetaInfo<T extends SplittableInterval<T>> {
    private final LinkedListMultimap<LabelNode, T> intervalStarts = LinkedListMultimap.create();
    private final LinkedListMultimap<LabelNode, T> intervalEnds = LinkedListMultimap.create();
    @NotNull
    private final ArrayList<T> allIntervals = CollectionsKt.arrayListOf(new SplittableInterval[0]);
    @NotNull
    private final Set<T> currentIntervals = SetsKt.linkedSetOf(new SplittableInterval[0]);

    public final LinkedListMultimap<LabelNode, T> getIntervalStarts() {
        return this.intervalStarts;
    }

    public final LinkedListMultimap<LabelNode, T> getIntervalEnds() {
        return this.intervalEnds;
    }

    @NotNull
    public final ArrayList<T> getAllIntervals() {
        return this.allIntervals;
    }

    @NotNull
    public final Set<T> getCurrentIntervals() {
        return this.currentIntervals;
    }

    public final void addNewInterval(@NotNull T newInfo) {
        Intrinsics.checkParameterIsNotNull(newInfo, "newInfo");
        this.intervalStarts.put(newInfo.getStartLabel(), newInfo);
        this.intervalEnds.put(newInfo.getEndLabel(), newInfo);
        this.allIntervals.add(newInfo);
    }

    private final void remapStartLabel(LabelNode oldStart, T remapped) {
        this.intervalStarts.remove(oldStart, remapped);
        this.intervalStarts.put(remapped.getStartLabel(), remapped);
    }

    private final void remapEndLabel(LabelNode oldEnd, T remapped) {
        this.intervalEnds.remove(oldEnd, remapped);
        this.intervalEnds.put(remapped.getEndLabel(), remapped);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SplitPair<T>> splitCurrentIntervals(@NotNull Interval by, boolean keepStart) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(by, "by");
        Iterable $receiver$iv = this.currentIntervals;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            SplittableInterval splittableInterval = (SplittableInterval)item$iv$iv;
            void var9_9 = destination$iv$iv;
            SplitPair<void> splitPair = this.split(it, by, keepStart);
            var9_9.add(splitPair);
        }
        return (List)destination$iv$iv;
    }

    public final void splitAndRemoveIntervalsFromCurrents(@NotNull Interval by) {
        Intrinsics.checkParameterIsNotNull(by, "by");
        ArrayList copies = new ArrayList(this.currentIntervals);
        Iterable $receiver$iv = copies;
        for (Object element$iv : $receiver$iv) {
            SplittableInterval it;
            SplittableInterval splittableInterval = it = (SplittableInterval)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(splittableInterval, "it");
            this.splitAndRemoveInterval(splittableInterval, by, true);
        }
    }

    public final void processCurrent(@NotNull LabelNode curIns, boolean directOrder) {
        SplittableInterval it;
        Intrinsics.checkParameterIsNotNull(curIns, "curIns");
        Iterable $receiver$iv = this.getInterval(curIns, directOrder);
        for (Object element$iv : $receiver$iv) {
            Unit unit;
            SplittableInterval splittableInterval = it = (SplittableInterval)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(splittableInterval, "it");
            boolean added = this.currentIntervals.add(splittableInterval);
            if (_Assertions.ENABLED) {
                if (!added) {
                    String string = "Wrong interval structure: " + curIns + ", " + it;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
        $receiver$iv = this.getInterval(curIns, !directOrder);
        for (Object element$iv : $receiver$iv) {
            Unit unit;
            it = (SplittableInterval)element$iv;
            boolean removed = this.currentIntervals.remove(it);
            if (_Assertions.ENABLED) {
                if (!removed) {
                    String string = "Wrong interval structure: " + curIns + ", " + it;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final SplitPair<T> split(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Intrinsics.checkParameterIsNotNull(interval, "interval");
        Intrinsics.checkParameterIsNotNull(by, "by");
        SplitPair split = interval.split(by, keepStart);
        if (!keepStart) {
            this.remapStartLabel(((SplittableInterval)split.getNewPart()).getStartLabel(), (SplittableInterval)split.getPatchedPart());
        } else {
            this.remapEndLabel(((SplittableInterval)split.getNewPart()).getEndLabel(), (SplittableInterval)split.getPatchedPart());
        }
        this.addNewInterval((SplittableInterval)split.getNewPart());
        return split;
    }

    @NotNull
    public final SplitPair<T> splitAndRemoveInterval(@NotNull T interval, @NotNull Interval by, boolean keepStart) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(interval, "interval");
        Intrinsics.checkParameterIsNotNull(by, "by");
        SplitPair<T> splitPair = this.split(interval, by, keepStart);
        boolean removed = this.currentIntervals.remove(splitPair.getPatchedPart());
        if (_Assertions.ENABLED) {
            if (!removed) {
                String string = "Wrong interval structure: " + splitPair;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return splitPair;
    }

    public final List<T> getInterval(@NotNull LabelNode curIns, boolean isOpen) {
        Intrinsics.checkParameterIsNotNull(curIns, "curIns");
        return isOpen ? this.intervalStarts.get((Object)curIns) : this.intervalEnds.get((Object)curIns);
    }
}

