/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplConsoleWriter;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplErrorLogger;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplSystemInWrapper;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplSystemOutWrapperForIde;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplWriter;
import org.jetbrains.kotlin.cli.jvm.repl.messages.UnescapeUtilsKt;
import org.jetbrains.kotlin.cli.jvm.repl.reader.ConsoleReplCommandReader;
import org.jetbrains.kotlin.cli.jvm.repl.reader.IdeReplCommandReader;
import org.jetbrains.kotlin.cli.jvm.repl.reader.ReplCommandReader;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class ReplFromTerminal {
    private ReplInterpreter replInterpreter;
    private Throwable replInitializationFailed;
    private final Object waitRepl;
    private final boolean ideMode;
    private ReplSystemInWrapper replReader;
    private final ReplWriter replWriter;
    private final ReplErrorLogger replErrorLogger;
    private ReplCommandReader commandReader;

    public ReplFromTerminal(final @NotNull Disposable disposable, final @NotNull CompilerConfiguration compilerConfiguration) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "<init>"));
        }
        if (compilerConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerConfiguration", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "<init>"));
        }
        this.waitRepl = new Object();
        String replIdeMode = System.getProperty("kotlin.repl.ideMode");
        boolean bl = this.ideMode = replIdeMode != null && replIdeMode.equals("true");
        if (this.ideMode) {
            ReplSystemOutWrapperForIde soutWrapper = new ReplSystemOutWrapperForIde(System.out);
            this.replWriter = soutWrapper;
            System.setOut(soutWrapper);
        } else {
            this.replWriter = new ReplConsoleWriter();
        }
        if (this.ideMode) {
            this.replReader = new ReplSystemInWrapper(System.in, this.replWriter);
            System.setIn(this.replReader);
        }
        this.replErrorLogger = new ReplErrorLogger(this.ideMode, this.replWriter);
        new Thread("initialize-repl"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ReplFromTerminal.this.replInterpreter = new ReplInterpreter(disposable, compilerConfiguration, ReplFromTerminal.this.ideMode, ReplFromTerminal.this.replReader);
                }
                catch (Throwable e) {
                    ReplFromTerminal.this.replInitializationFailed = e;
                }
                Object object = ReplFromTerminal.this.waitRepl;
                synchronized (object) {
                    ReplFromTerminal.this.waitRepl.notifyAll();
                }
            }
        }.start();
        try {
            this.commandReader = this.createCommandReader();
        }
        catch (Exception e) {
            this.replErrorLogger.logException(e);
        }
    }

    @NotNull
    private ReplCommandReader createCommandReader() {
        ReplCommandReader replCommandReader = this.ideMode ? new IdeReplCommandReader() : new ConsoleReplCommandReader();
        if (replCommandReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "createCommandReader"));
        }
        return replCommandReader;
    }

    private ReplInterpreter getReplInterpreter() {
        if (this.replInterpreter != null) {
            return this.replInterpreter;
        }
        Object object = this.waitRepl;
        synchronized (object) {
            while (this.replInterpreter == null && this.replInitializationFailed == null) {
                try {
                    this.waitRepl.wait();
                }
                catch (Throwable e) {
                    throw ExceptionUtilsKt.rethrow(e);
                }
            }
            if (this.replInterpreter != null) {
                return this.replInterpreter;
            }
            throw ExceptionUtilsKt.rethrow(this.replInitializationFailed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        try {
            this.replWriter.printlnWelcomeMessage("Welcome to Kotlin version 1.0.2-1 (JRE " + System.getProperty("java.runtime.version") + ")");
            this.replWriter.printlnWelcomeMessage("Type :help for help, :quit for quit");
            WhatNextAfterOneLine next = WhatNextAfterOneLine.READ_LINE;
            while ((next = this.one(next)) != WhatNextAfterOneLine.QUIT) {
            }
        }
        catch (Exception e) {
            this.replErrorLogger.logException(e);
        }
        finally {
            try {
                this.commandReader.flushHistory();
            }
            catch (Exception e) {
                this.replErrorLogger.logException(e);
            }
        }
    }

    @NotNull
    private WhatNextAfterOneLine one(@NotNull WhatNextAfterOneLine next) {
        block12: {
            String line;
            block11: {
                block10: {
                    WhatNextAfterOneLine whatNextAfterOneLine;
                    if (next == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
                    }
                    try {
                        line = this.commandReader.readLine(next);
                        if (line != null) break block10;
                        whatNextAfterOneLine = WhatNextAfterOneLine.QUIT;
                    }
                    catch (Exception e) {
                        throw ExceptionUtilsKt.rethrow(e);
                    }
                    if (whatNextAfterOneLine == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
                    }
                    return whatNextAfterOneLine;
                }
                line = UnescapeUtilsKt.unescapeLineBreaks(line);
                if (!line.startsWith(":") || line.length() != 1 && line.charAt(1) == ':') break block11;
                boolean notQuit = this.oneCommand(line.substring(1));
                WhatNextAfterOneLine whatNextAfterOneLine = notQuit ? WhatNextAfterOneLine.READ_LINE : WhatNextAfterOneLine.QUIT;
                if (whatNextAfterOneLine == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
                }
                return whatNextAfterOneLine;
            }
            ReplInterpreter.LineResultType lineResultType = this.eval(line);
            if (lineResultType != ReplInterpreter.LineResultType.INCOMPLETE) break block12;
            WhatNextAfterOneLine whatNextAfterOneLine = WhatNextAfterOneLine.INCOMPLETE;
            if (whatNextAfterOneLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
            }
            return whatNextAfterOneLine;
        }
        WhatNextAfterOneLine whatNextAfterOneLine = WhatNextAfterOneLine.READ_LINE;
        if (whatNextAfterOneLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "one"));
        }
        return whatNextAfterOneLine;
    }

    @NotNull
    private ReplInterpreter.LineResultType eval(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "eval"));
        }
        ReplInterpreter.LineResult lineResult = this.getReplInterpreter().eval(line);
        if (lineResult.getType() == ReplInterpreter.LineResultType.SUCCESS) {
            this.replWriter.notifyCommandSuccess();
            if (!lineResult.isUnit()) {
                this.replWriter.outputCommandResult(lineResult.getValue());
            }
        } else if (lineResult.getType() == ReplInterpreter.LineResultType.INCOMPLETE) {
            this.replWriter.notifyIncomplete();
        } else if (lineResult.getType() == ReplInterpreter.LineResultType.COMPILE_ERROR) {
            this.replWriter.outputCompileError(lineResult.getErrorText());
        } else if (lineResult.getType() == ReplInterpreter.LineResultType.RUNTIME_ERROR) {
            this.replWriter.outputRuntimeError(lineResult.getErrorText());
        } else {
            throw new IllegalStateException("unknown line result type: " + lineResult);
        }
        ReplInterpreter.LineResultType lineResultType = lineResult.getType();
        if (lineResultType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "eval"));
        }
        return lineResultType;
    }

    private boolean oneCommand(@NotNull String command) throws Exception {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "oneCommand"));
        }
        List<String> split = ReplFromTerminal.splitCommand(command);
        if (split.size() >= 1 && command.equals("help")) {
            this.replWriter.printlnHelpMessage("Available commands:\n:help                   show this help\n:quit                   exit the interpreter\n:dump bytecode          dump classes to terminal\n:load <file>            load script from specified file");
            return true;
        }
        if (split.size() >= 2 && split.get(0).equals("dump") && split.get(1).equals("bytecode")) {
            this.getReplInterpreter().dumpClasses(new PrintWriter(System.out));
            return true;
        }
        if (split.size() >= 1 && split.get(0).equals("quit")) {
            return false;
        }
        if (split.size() >= 2 && split.get(0).equals("load")) {
            String fileName = split.get(1);
            String scriptText = FileUtil.loadFile(new File(fileName));
            this.eval(scriptText);
            return true;
        }
        this.replWriter.printlnHelpMessage("Unknown command\nType :help for help");
        return true;
    }

    private static List<String> splitCommand(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "splitCommand"));
        }
        return Arrays.asList(command.split(" "));
    }

    public static void run(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "run"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal", "run"));
        }
        new ReplFromTerminal(disposable, configuration).doRun();
    }

    public static enum WhatNextAfterOneLine {
        READ_LINE,
        INCOMPLETE,
        QUIT;

    }
}

