/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlexibleTypeCapabilitiesDeserializer {
    @Nullable
    public FlexibleTypeCapabilities capabilitiesById(@NotNull String var1);

    public static final class ThrowException
    implements FlexibleTypeCapabilitiesDeserializer {
        public static final ThrowException INSTANCE;

        @Override
        @Nullable
        public FlexibleTypeCapabilities capabilitiesById(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            throw (Throwable)new IllegalArgumentException("Capabilities not found by ThrowException manager: " + id);
        }

        private ThrowException() {
            INSTANCE = this;
        }

        static {
            new ThrowException();
        }
    }

    public static final class Dynamic
    implements FlexibleTypeCapabilitiesDeserializer {
        public static final Dynamic INSTANCE;

        @Override
        @Nullable
        public FlexibleTypeCapabilities capabilitiesById(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull(id, "id");
            return Intrinsics.areEqual(id, DynamicTypeCapabilities.INSTANCE.getId()) ? (FlexibleTypeCapabilities)DynamicTypeCapabilities.INSTANCE : (FlexibleTypeCapabilities)null;
        }

        private Dynamic() {
            INSTANCE = this;
        }

        static {
            new Dynamic();
        }
    }
}

