/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuiltinMethodsWithDifferentJvmName {
    @NotNull
    private static final FqName REMOVE_AT_FQ_NAME;
    @NotNull
    private static final Map<FqName, Name> FQ_NAMES_TO_JVM_MAP;
    @NotNull
    private static final List<Name> ORIGINAL_SHORT_NAMES;
    @NotNull
    private static final Map<Name, List<Name>> JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP;
    public static final BuiltinMethodsWithDifferentJvmName INSTANCE;

    @NotNull
    public final FqName getREMOVE_AT_FQ_NAME() {
        return REMOVE_AT_FQ_NAME;
    }

    @NotNull
    public final Map<FqName, Name> getFQ_NAMES_TO_JVM_MAP() {
        return FQ_NAMES_TO_JVM_MAP;
    }

    @NotNull
    public final List<Name> getORIGINAL_SHORT_NAMES() {
        return ORIGINAL_SHORT_NAMES;
    }

    @NotNull
    public final Map<Name, List<Name>> getJVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP() {
        return JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP;
    }

    public final boolean getSameAsRenamedInJvmBuiltin(@NotNull Name $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ORIGINAL_SHORT_NAMES.contains($receiver);
    }

    @Nullable
    public final Name getJvmName(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(callableMemberDescriptor);
        if (fqName2 == null) {
            return null;
        }
        return FQ_NAMES_TO_JVM_MAP.get(fqName2);
    }

    public final boolean isBuiltinFunctionWithDifferentNameInJvm(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        if (!SpecialBuiltinMembers.isFromBuiltins(callableMemberDescriptor)) {
            return false;
        }
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(callableMemberDescriptor);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return DescriptorUtilsKt.firstOverridden$default(callableMemberDescriptor, false, new Function1<CallableMemberDescriptor, Boolean>(fqName3){
            final /* synthetic */ FqName $fqName;

            public final boolean invoke(@NotNull CallableMemberDescriptor it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return BuiltinMethodsWithDifferentJvmName.INSTANCE.getFQ_NAMES_TO_JVM_MAP().containsKey(this.$fqName);
            }
            {
                this.$fqName = fqName2;
                super(1);
            }
        }, 1, null) != null;
    }

    @NotNull
    public final List<Name> getBuiltinFunctionNamesByJvmName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        List<Name> list2 = JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP.get(name);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean isRemoveAtByIndex(@NotNull CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Intrinsics.areEqual($receiver.getName().asString(), "removeAt") && Intrinsics.areEqual(DescriptorUtilsKt.fqNameOrNull($receiver), REMOVE_AT_FQ_NAME);
    }

    /*
     * WARNING - void declaration
     */
    private BuiltinMethodsWithDifferentJvmName() {
        void var3_3;
        void $receiver$iv$iv;
        INSTANCE = this;
        REMOVE_AT_FQ_NAME = SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.mutableList, "removeAt");
        FQ_NAMES_TO_JVM_MAP = MapsKt.mapOf(TuplesKt.to(SpecialBuiltinMembers.access$childSafe(KotlinBuiltIns.FQ_NAMES.number, "toByte"), Name.identifier("byteValue")), TuplesKt.to(SpecialBuiltinMembers.access$childSafe(KotlinBuiltIns.FQ_NAMES.number, "toShort"), Name.identifier("shortValue")), TuplesKt.to(SpecialBuiltinMembers.access$childSafe(KotlinBuiltIns.FQ_NAMES.number, "toInt"), Name.identifier("intValue")), TuplesKt.to(SpecialBuiltinMembers.access$childSafe(KotlinBuiltIns.FQ_NAMES.number, "toLong"), Name.identifier("longValue")), TuplesKt.to(SpecialBuiltinMembers.access$childSafe(KotlinBuiltIns.FQ_NAMES.number, "toFloat"), Name.identifier("floatValue")), TuplesKt.to(SpecialBuiltinMembers.access$childSafe(KotlinBuiltIns.FQ_NAMES.number, "toDouble"), Name.identifier("doubleValue")), TuplesKt.to(REMOVE_AT_FQ_NAME, Name.identifier("remove")), TuplesKt.to(SpecialBuiltinMembers.access$childSafe(KotlinBuiltIns.FQ_NAMES.charSequence, "get"), Name.identifier("charAt")));
        Iterable $receiver$iv = FQ_NAMES_TO_JVM_MAP.keySet();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            Name name = it.shortName();
            collection.add(name);
        }
        ORIGINAL_SHORT_NAMES = (List)var3_3;
        JVM_SHORT_NAME_TO_BUILTIN_SHORT_NAMES_MAP = SpecialBuiltinMembers.access$getInversedShortNamesMap(FQ_NAMES_TO_JVM_MAP);
    }

    static {
        new BuiltinMethodsWithDifferentJvmName();
    }
}

