/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.builtins.BuiltInsProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuiltInsClassDataFinder
implements ClassDataFinder {
    private final Map<ClassId, ProtoBuf.Class> classIdToProto;
    private final BuiltInsProtoBuf.BuiltIns proto;
    private final NameResolver nameResolver;

    @NotNull
    public final Collection<ClassId> getAllClassIds$kotlin_core() {
        return this.classIdToProto.keySet();
    }

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        ProtoBuf.Class clazz = this.classIdToProto.get(classId);
        if (clazz == null) {
            return null;
        }
        ProtoBuf.Class classProto = clazz;
        return new ClassDataWithSource(new ClassData(this.nameResolver, classProto), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public BuiltInsClassDataFinder(@NotNull BuiltInsProtoBuf.BuiltIns proto, @NotNull NameResolver nameResolver) {
        void var11_11;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        this.proto = proto;
        this.nameResolver = nameResolver;
        Iterable iterable = this.proto.getClassList();
        BuiltInsClassDataFinder builtInsClassDataFinder = this;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        void var6_6 = $receiver$iv;
        Map map2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void klass;
            ProtoBuf.Class clazz = (ProtoBuf.Class)element$iv$iv;
            var11_11 = destination$iv$iv;
            ClassId classId = this.nameResolver.getClassId(klass.getFqName());
            var11_11.put(classId, element$iv$iv);
        }
        var11_11 = destination$iv$iv;
        builtInsClassDataFinder.classIdToProto = var11_11;
    }
}

