/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.util;

import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;

public final class AstUtil {
    public static JsBinaryOperation newSequence(JsExpression ... exprs) {
        if (exprs.length < 2) {
            throw new RuntimeException("newSequence expects at least two arguments");
        }
        JsExpression result2 = exprs[exprs.length - 1];
        for (int i = exprs.length - 2; i >= 0; --i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, exprs[i], result2);
        }
        return (JsBinaryOperation)result2;
    }

    @Nullable
    public static <T extends JsNode> T deepCopy(@Nullable T node) {
        if (node == null) {
            return null;
        }
        return (T)node.deepCopy();
    }

    @NotNull
    public static <T extends JsNode> List<T> deepCopy(@Nullable List<T> nodes) {
        if (nodes == null) {
            SmartList smartList = new SmartList();
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/util/AstUtil", "deepCopy"));
            }
            return smartList;
        }
        ArrayList<JsNode> nodesCopy = new ArrayList<JsNode>(nodes.size());
        for (JsNode node : nodes) {
            nodesCopy.add(AstUtil.deepCopy(node));
        }
        ArrayList<JsNode> arrayList = nodesCopy;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/util/AstUtil", "deepCopy"));
        }
        return arrayList;
    }
}

