/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsCatchScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.util.AstUtil;

public class JsCatch
extends SourceInfoAwareJsNode {
    protected final JsCatchScope scope;
    private JsBlock body;
    private JsExpression condition;
    private JsParameter param;

    public JsCatch(JsScope parent2, @NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsCatch", "<init>"));
        }
        assert (parent2 != null);
        this.scope = new JsCatchScope(parent2, ident);
        this.param = new JsParameter(this.scope.findName(ident));
    }

    public JsCatch(JsScope parent2, @NotNull String ident, @NotNull JsStatement catchBody) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsCatch", "<init>"));
        }
        if (catchBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchBody", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsCatch", "<init>"));
        }
        this(parent2, ident);
        this.body = catchBody instanceof JsBlock ? (JsBlock)catchBody : new JsBlock(catchBody);
    }

    public JsBlock getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public JsParameter getParameter() {
        return this.param;
    }

    public JsScope getScope() {
        return this.scope;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    public void setCondition(JsExpression condition) {
        this.condition = condition;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitCatch(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.param);
        if (this.condition != null) {
            visitor2.accept(this.condition);
        }
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.param = v.accept(this.param);
            if (this.condition != null) {
                this.condition = v.accept(this.condition);
            }
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsCatch deepCopy() {
        JsCatchScope scopeCopy = this.scope.copy();
        JsBlock bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsParameter paramCopy = AstUtil.deepCopy(this.param);
        JsCatch jsCatch = new JsCatch(scopeCopy, bodyCopy, conditionCopy, paramCopy).withMetadataFrom(this);
        if (jsCatch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsCatch", "deepCopy"));
        }
        return jsCatch;
    }

    private JsCatch(JsCatchScope scope2, JsBlock body, JsExpression condition, JsParameter param) {
        this.scope = scope2;
        this.body = body;
        this.condition = condition;
        this.param = param;
    }
}

