/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.StringTemplateTranslator;
import org.jetbrains.kotlin.js.translate.expression.TryTranslator;
import org.jetbrains.kotlin.js.translate.expression.WhenTranslator;
import org.jetbrains.kotlin.js.translate.expression.loopTranslator.LoopTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.UnaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsContinue;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsEmpty;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsThrow;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsTry;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class ExpressionVisitor
extends TranslatorVisitor<JsNode> {
    @Override
    protected JsNode emptyResult(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "emptyResult"));
        }
        return context.getEmptyExpression();
    }

    @Override
    @NotNull
    public JsNode visitConstantExpression(@NotNull KtConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        JsNode jsNode = ExpressionVisitor.translateConstantExpression(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitConstantExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode translateConstantExpression(@NotNull KtConstantExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, context.bindingContext());
        assert (compileTimeValue != null) : ErrorReportingUtils.message(expression, "Expression is not compile time value: " + expression.getText() + " ");
        KotlinType expectedType = context.bindingContext().getType(expression);
        ConstantValue<?> constant = compileTimeValue.toConstantValue(expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE);
        if (constant instanceof NullValue) {
            JsNullLiteral jsNullLiteral = JsLiteral.NULL;
            if (jsNullLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNullLiteral;
        }
        Object value = constant.getValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(((Number)value).intValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Long) {
            JsExpression jsExpression = JsAstUtils.newLong((Long)value, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsExpression;
        }
        if (value instanceof Number) {
            JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(((Number)value).doubleValue());
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsNumberLiteral;
        }
        if (value instanceof Boolean) {
            JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.getBoolean((Boolean)value);
            if (jsBooleanLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsBooleanLiteral;
        }
        if (value instanceof String) {
            JsStringLiteral jsStringLiteral = context.program().getStringLiteral((String)value);
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        if (value instanceof Character) {
            JsStringLiteral jsStringLiteral = context.program().getStringLiteral(value.toString());
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "translateConstantExpression"));
            }
            return jsStringLiteral;
        }
        throw new AssertionError((Object)ErrorReportingUtils.message(expression, "Unsupported constant expression: " + expression.getText() + " "));
    }

    @Override
    @NotNull
    public JsNode visitBlockExpression(@NotNull KtBlockExpression jetBlock, @NotNull TranslationContext context) {
        if (jetBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetBlock", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        List<KtExpression> statements = jetBlock.getStatements();
        JsBlock jsBlock = new JsBlock();
        for (KtExpression statement : statements) {
            JsNode jsNode = Translation.translateExpression(statement, context, jsBlock);
            JsStatement jsStatement = JsAstUtils.convertToStatement(jsNode);
            if (JsAstUtils.isEmptyStatement(jsStatement)) continue;
            jsBlock.getStatements().add(jsStatement);
        }
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBlockExpression"));
        }
        return jsBlock2;
    }

    @Override
    public JsNode visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull TranslationContext context) {
        if (multiDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDestructuringDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDestructuringDeclaration"));
        }
        KtExpression jetInitializer = multiDeclaration.getInitializer();
        assert (jetInitializer != null) : "Initializer for multi declaration must be not null";
        JsExpression initializer2 = Translation.translateAsExpression(jetInitializer, context);
        return DestructuringDeclarationTranslator.translate(multiDeclaration, context.scope().declareTemporary(), initializer2, context);
    }

    @Override
    @NotNull
    public JsNode visitReturnExpression(@NotNull KtReturnExpression jetReturnExpression, @NotNull TranslationContext context) {
        if (jetReturnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetReturnExpression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        KtExpression returned = jetReturnExpression.getReturnedExpression();
        KtDeclarationWithBody parent2 = PsiTreeUtil.getParentOfType((PsiElement)jetReturnExpression, KtDeclarationWithBody.class);
        if (parent2 instanceof KtSecondaryConstructor) {
            JsNode jsNode = new JsReturn(new JsNameRef("$this")).source(jetReturnExpression);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsNode;
        }
        if (returned == null) {
            JsNode jsNode = new JsReturn(null).source(jetReturnExpression);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsNode;
        }
        JsExpression jsReturnExpression = Translation.translateAsExpression(returned, context);
        if (JsAstUtils.isEmptyExpression(jsReturnExpression)) {
            JsExpression jsExpression = context.getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
            }
            return jsExpression;
        }
        JsNode jsNode = new JsReturn(jsReturnExpression).source(jetReturnExpression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitReturnExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        KtExpression expressionInside = expression.getExpression();
        if (expressionInside != null) {
            JsNode jsNode = Translation.translateExpression(expressionInside, context);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
            }
            return jsNode;
        }
        JsEmpty jsEmpty = JsEmpty.INSTANCE;
        if (jsEmpty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitParenthesizedExpression"));
        }
        return jsEmpty;
    }

    @Override
    @NotNull
    public JsNode visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        JsExpression jsExpression = BinaryOperationTranslator.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitProperty(@NotNull KtProperty expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        VariableDescriptor descriptor2 = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, expression);
        JsExpression initializer2 = TranslationUtils.translateInitializerForProperty(expression, context);
        if (initializer2 != null && JsAstUtils.isEmptyExpression(initializer2)) {
            JsExpression jsExpression = context.getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
            }
            return jsExpression;
        }
        JsName name = context.getNameForDescriptor(descriptor2);
        if (BindingContextUtils.isVarCapturedInClosure(context.bindingContext(), descriptor2)) {
            JsNameRef alias = Namer.getCapturedVarAccessor(name.makeRef());
            initializer2 = JsAstUtils.wrapValue(alias, initializer2 == null ? JsLiteral.NULL : initializer2);
        }
        JsNode jsNode = JsAstUtils.newVar(name, initializer2).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitProperty"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        JsExpression jsExpression = CallableReferenceTranslator.INSTANCE.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallableReferenceExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitCallExpression(@NotNull KtCallExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        JsNode jsNode = CallExpressionTranslator.translate(expression, null, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitCallExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitIfExpression(@NotNull KtIfExpression expression, @NotNull TranslationContext context) {
        JsStatement elseStatement;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        assert (expression.getCondition() != null) : "condition should not ne null: " + expression.getText();
        JsExpression testExpression = Translation.translateAsExpression(expression.getCondition(), context);
        if (JsAstUtils.isEmptyExpression(testExpression)) {
            JsExpression jsExpression = testExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
            }
            return jsExpression;
        }
        boolean isKotlinExpression = BindingContextUtilsKt.isUsedAsExpression(expression, context.bindingContext());
        KtExpression thenExpression = expression.getThen();
        KtExpression elseExpression = expression.getElse();
        JsStatement thenStatement = thenExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(thenExpression, context) : null;
        JsStatement jsStatement = elseStatement = elseExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(elseExpression, context) : null;
        if (isKotlinExpression) {
            boolean canBeJsExpression;
            JsExpression jsThenExpression = JsAstUtils.extractExpressionFromStatement(thenStatement);
            JsExpression jsElseExpression = JsAstUtils.extractExpressionFromStatement(elseStatement);
            boolean bl = canBeJsExpression = jsThenExpression != null && jsElseExpression != null;
            if (canBeJsExpression) {
                JsExpression jsExpression = new JsConditional(testExpression, jsThenExpression, jsElseExpression).source(expression);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
                }
                return jsExpression;
            }
        }
        JsIf ifStatement = new JsIf(testExpression, thenStatement, elseStatement);
        JsNode jsNode = ifStatement.source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIfExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        JsExpression jsExpression = ReferenceTranslator.translateSimpleNameWithQualifier(expression, null, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSimpleNameExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitWhileExpression(@NotNull KtWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        JsNode jsNode = LoopTranslator.createWhile(false, expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhileExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitDoWhileExpression(@NotNull KtDoWhileExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        JsNode jsNode = LoopTranslator.createWhile(true, expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDoWhileExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        JsStringLiteral stringLiteral = ExpressionVisitor.resolveAsStringConstant(expression, context);
        if (stringLiteral != null) {
            JsStringLiteral jsStringLiteral = stringLiteral;
            if (jsStringLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
            }
            return jsStringLiteral;
        }
        JsNode jsNode = ExpressionVisitor.resolveAsTemplate(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitStringTemplateExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode resolveAsTemplate(@NotNull KtStringTemplateExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        JsExpression jsExpression = StringTemplateTranslator.translate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsTemplate"));
        }
        return jsExpression;
    }

    @Nullable
    private static JsStringLiteral resolveAsStringConstant(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "resolveAsStringConstant"));
        }
        Object value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression);
        if (value == null) {
            return null;
        }
        assert (value instanceof String) : "Compile time constant template should be a String constant.";
        String constantString = (String)value;
        return context.program().getStringLiteral(constantString);
    }

    @Override
    @NotNull
    public JsNode visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitDotQualifiedExpression"));
        }
        return jsNode;
    }

    @Override
    public JsNode visitLabeledExpression(@NotNull KtLabeledExpression expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitLabeledExpression"));
        }
        KtExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        if (BindingContextUtilsKt.isUsedAsExpression(expression, context.bindingContext())) {
            return Translation.translateAsExpression(baseExpression, context).source(expression);
        }
        JsScope scope2 = context.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsFunctionScope functionScope = (JsFunctionScope)scope2;
        String labelIdent = ExpressionVisitor.getReferencedName(expression.getTargetLabel());
        JsName labelName = functionScope.enterLabel(labelIdent);
        JsStatement baseStatement = Translation.translateAsStatement(baseExpression, context);
        functionScope.exitLabel();
        return new JsLabel(labelName, baseStatement).source(expression);
    }

    @Override
    @NotNull
    public JsNode visitPrefixExpression(@NotNull KtPrefixExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPrefixExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitPostfixExpression(@NotNull KtPostfixExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        JsExpression jsExpression = UnaryOperationTranslator.translate(expression, context).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitPostfixExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitIsExpression(@NotNull KtIsExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        JsExpression jsExpression = Translation.patternTranslator(context).translateIsExpression(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitIsExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        JsNode jsNode = QualifiedExpressionTranslator.translateQualifiedExpression(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSafeQualifiedExpression"));
        }
        return jsNode;
    }

    @Override
    @Nullable
    public JsNode visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitWhenExpression"));
        }
        return WhenTranslator.translate(expression, context);
    }

    @Override
    @NotNull
    public JsNode visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(expression.getLeft(), context);
        if (expression.getOperationReference().getReferencedNameElementType() != KtTokens.AS_KEYWORD) {
            JsExpression jsExpression2 = jsExpression.source(expression);
            if (jsExpression2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression2;
        }
        KtTypeReference right = expression.getRight();
        assert (right != null);
        KotlinType rightType = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.TYPE, right);
        KotlinType leftType = BindingContextUtils.getTypeNotNull(context.bindingContext(), expression.getLeft());
        if (TypeUtils.isNullableType(rightType) || !TypeUtils.isNullableType(leftType)) {
            JsExpression jsExpression3 = jsExpression.source(expression);
            if (jsExpression3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            return jsExpression3;
        }
        JsExpression jsExpression4 = TranslationUtils.sure(jsExpression, context).source(expression);
        if (jsExpression4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBinaryWithTypeRHSExpression"));
        }
        return jsExpression4;
    }

    private static String getReferencedName(KtSimpleNameExpression expression) {
        return expression.getReferencedName().replaceAll("^@", "").replaceAll("(?:^`(.*)`$)", "$1");
    }

    private static JsNameRef getTargetLabel(KtExpressionWithLabel expression, TranslationContext context) {
        KtSimpleNameExpression labelElement = expression.getTargetLabel();
        if (labelElement == null) {
            return null;
        }
        String labelIdent = ExpressionVisitor.getReferencedName(labelElement);
        JsScope scope2 = context.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsName labelName = ((JsFunctionScope)scope2).findLabel(labelIdent);
        assert (labelName != null);
        return labelName.makeRef();
    }

    @Override
    @NotNull
    public JsNode visitBreakExpression(@NotNull KtBreakExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        JsNode jsNode = new JsBreak(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitBreakExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitContinueExpression(@NotNull KtContinueExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        JsNode jsNode = new JsContinue(ExpressionVisitor.getTargetLabel(expression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitContinueExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitLambdaExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitLambdaExpression"));
        }
        JsExpression jsExpression = new LiteralFunctionTranslator(context).translate(expression.getFunctionLiteral());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitLambdaExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitNamedFunction(@NotNull KtNamedFunction expression, @NotNull TranslationContext context) {
        boolean isExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        JsExpression alias = new LiteralFunctionTranslator(context).translate(expression);
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        JsName name = context.getNameForDescriptor(descriptor2);
        if (InlineUtil.isInline(descriptor2)) {
            MetadataProperties.setStaticRef(name, alias);
        }
        JsExpression result2 = (isExpression = BindingContextUtilsKt.isUsedAsExpression(expression, context.bindingContext())) ? alias : JsAstUtils.newVar(name, alias);
        JsNode jsNode = result2.source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitNamedFunction"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitThisExpression(@NotNull KtThisExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        DeclarationDescriptor thisExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression.getInstanceReference());
        assert (thisExpression != null) : "This expression must reference a descriptor: " + expression.getText();
        JsExpression jsExpression = context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(thisExpression)).source(expression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThisExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        JsExpression jsExpression = AccessTranslationUtils.translateAsGet(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitArrayAccessExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitSuperExpression(@NotNull KtSuperExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        DeclarationDescriptor superClassDescriptor = context.bindingContext().get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        assert (superClassDescriptor != null) : ErrorReportingUtils.message(expression);
        JsExpression jsExpression = ReferenceTranslator.translateAsFQReference(superClassDescriptor, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitSuperExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitForExpression(@NotNull KtForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        JsNode jsNode = LoopTranslator.translateForExpression(expression, context).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitForExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitTryExpression(@NotNull KtTryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        JsTry jsTry = new TryTranslator(expression, context).translate();
        if (jsTry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitTryExpression"));
        }
        return jsTry;
    }

    @Override
    @NotNull
    public JsNode visitThrowExpression(@NotNull KtThrowExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        KtExpression thrownExpression = expression.getThrownExpression();
        assert (thrownExpression != null) : "Thrown expression must not be null";
        JsNode jsNode = new JsThrow(Translation.translateAsExpression(thrownExpression, context)).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitThrowExpression"));
        }
        return jsNode;
    }

    @Override
    @NotNull
    public JsNode visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        JsExpression jsExpression = ClassTranslator.generateObjectLiteral(expression.getObjectDeclaration(), context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectLiteralExpression"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsNode visitObjectDeclaration(@NotNull KtObjectDeclaration expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(context.bindingContext(), expression);
        JsName name = context.getNameForDescriptor(descriptor2);
        JsInvocation value = ClassTranslator.generateClassCreation(expression, context);
        JsNode jsNode = JsAstUtils.newVar(name, value).source(expression);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/ExpressionVisitor", "visitObjectDeclaration"));
        }
        return jsNode;
    }
}

