/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiScopesUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.util.PsiScopesUtil");

    private PsiScopesUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entrance", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        return PsiScopesUtil.treeWalkUp(processor, entrance, maxScope, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state2) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entrance", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (!entrance.isValid()) {
            LOG.error(new PsiInvalidElementAccessException(entrance));
        }
        PsiElement prevParent = entrance;
        PsiElement scope2 = entrance;
        while (scope2 != null) {
            PsiModifierList modifierList;
            ProgressIndicatorProvider.checkCanceled();
            if (scope2 instanceof PsiClass) {
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, scope2);
            }
            if (!scope2.processDeclarations(processor, state2, prevParent, entrance)) {
                return false;
            }
            if (scope2 instanceof PsiModifierListOwner && !(scope2 instanceof PsiParameter) && (modifierList = ((PsiModifierListOwner)scope2).getModifierList()) != null && modifierList.hasModifierProperty("static")) {
                processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
            }
            if (scope2 == maxScope) break;
            prevParent = scope2;
            scope2 = prevParent.getContext();
            processor.handleEvent(JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        }
        return true;
    }

    public static boolean walkChildrenScopes(@NotNull PsiElement thisElement, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, PsiElement place) {
        if (thisElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisElement", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == thisElement && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = thisElement.getLastChild();
        }
        while (child != null) {
            if (!child.processDeclarations(processor, state2, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public static void processTypeDeclarations(PsiType type2, PsiElement place, PsiScopeProcessor processor) {
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(place);
            PsiClass arrayClass = JavaPsiFacade.getInstance(place.getProject()).getElementFactory().getArrayClass(languageLevel);
            PsiTypeParameter[] arrayTypeParameters = arrayClass.getTypeParameters();
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (arrayTypeParameters.length > 0) {
                substitutor2 = substitutor2.put(arrayTypeParameters[0], ((PsiArrayType)type2).getComponentType());
            }
            arrayClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2), arrayClass, place);
        } else if (type2 instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type2).getConjuncts()) {
                PsiScopesUtil.processTypeDeclarations(psiType, place, processor);
            }
        } else if (type2 instanceof PsiDisjunctionType) {
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            PsiScopesUtil.processTypeDeclarations(lub, place, processor);
        } else {
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(type2);
            PsiClass clazz = (PsiClass)result2.getElement();
            if (clazz != null) {
                clazz.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result2.getSubstitutor()), clazz, place);
            }
        }
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        return PsiScopesUtil.resolveAndWalk(processor, ref, maxScope, false);
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope, boolean incompleteCode) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        PsiElement qualifier2 = ref.getQualifier();
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (classNameElement == null) {
            return true;
        }
        if (qualifier2 != null) {
            PsiElement target = null;
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (qualifier2 instanceof PsiExpression || qualifier2 instanceof PsiJavaCodeReferenceElement) {
                PsiType type2 = null;
                if (qualifier2 instanceof PsiExpression) {
                    type2 = ((PsiExpression)qualifier2).getType();
                    if (type2 != null) assert (type2.isValid()) : type2.getClass() + "; " + qualifier2;
                    PsiScopesUtil.processTypeDeclarations(type2, ref, processor);
                }
                if (type2 == null && qualifier2 instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier2;
                    JavaResolveResult result2 = referenceElement.advancedResolve(incompleteCode);
                    target = result2.getElement();
                    substitutor2 = result2.getSubstitutor();
                    if (target instanceof PsiVariable) {
                        type2 = substitutor2.substitute(((PsiVariable)target).getType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor2 = substitutor2.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                    } else if (target instanceof PsiMethod) {
                        type2 = substitutor2.substitute(((PsiMethod)target).getReturnType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor2 = substitutor2.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                        PsiType[] types2 = referenceElement.getTypeParameters();
                        if (target instanceof PsiClass) {
                            substitutor2 = substitutor2.putAll((PsiClass)target, types2);
                        }
                    } else if (target instanceof PsiClass) {
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                    }
                }
            }
            if (target != null) {
                return target.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2), target, ref);
            }
        } else {
            return PsiScopesUtil.treeWalkUp(processor, ref, maxScope);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setupAndRunProcessor(@NotNull MethodsProcessor processor, @NotNull PsiCallExpression call, boolean dummyImplicitConstructor) throws MethodProcessorSetupFailedException {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "setupAndRunProcessor"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/scope/util/PsiScopesUtil", "setupAndRunProcessor"));
        }
        if (call instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)call;
            PsiReferenceExpression ref = methodCall.getMethodExpression();
            processor.setArgumentList(methodCall.getArgumentList());
            processor.obtainTypeArguments(methodCall);
            if (!ref.isQualified() || ref.getReferenceNameElement() instanceof PsiKeyword) {
                PsiElement referenceNameElement = ref.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                if (referenceNameElement instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)referenceNameElement;
                    if (keyword.getTokenType() == JavaTokenType.THIS_KEYWORD) {
                        PsiClass aClass2 = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass2 == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for this expression");
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(aClass2);
                        aClass2.processDeclarations(processor, ResolveState.initial(), null, call);
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, aClass2);
                        return;
                    } else if (keyword.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                        PsiClass aClass3 = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass3 == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for super expression");
                        }
                        PsiClass superClass = aClass3.getSuperClass();
                        if (superClass == null) return;
                        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
                        PsiClass runSuper = superClass;
                        ArrayList<PsiSubstitutor> contextSubstitutors = new ArrayList<PsiSubstitutor>();
                        do {
                            if (runSuper != null) {
                                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(runSuper, aClass3, PsiSubstitutor.EMPTY);
                                contextSubstitutors.add(superSubstitutor);
                            }
                            if (aClass3.hasModifierProperty("static")) break;
                            if ((aClass3 = JavaResolveUtil.getContextClass(aClass3)) == null) continue;
                            runSuper = aClass3.getSuperClass();
                        } while (aClass3 != null);
                        for (int i = contextSubstitutors.size() - 1; i >= 0; --i) {
                            PsiSubstitutor contextSubstitutor = (PsiSubstitutor)contextSubstitutors.get(i);
                            substitutor2 = substitutor2.putAll(contextSubstitutor);
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(null);
                        PsiMethod[] constructors2 = superClass.getConstructors();
                        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
                        for (PsiMethod constructor : constructors2) {
                            if (processor.execute(constructor, state2)) continue;
                            return;
                        }
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, superClass);
                        return;
                    } else {
                        LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                    }
                    return;
                } else if (referenceNameElement instanceof PsiIdentifier) {
                    processor.setIsConstructor(false);
                    processor.setName(referenceNameElement.getText());
                    processor.setAccessClass(null);
                    PsiScopesUtil.resolveAndWalk(processor, ref, null);
                    return;
                } else {
                    LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                }
                return;
            } else {
                PsiElement referenceName = methodCall.getMethodExpression().getReferenceNameElement();
                PsiManager manager = call.getManager();
                PsiElement qualifier2 = ref.getQualifier();
                if (referenceName == null) {
                    throw new MethodProcessorSetupFailedException("Can't resolve method name for this expression");
                }
                if (referenceName instanceof PsiIdentifier && qualifier2 instanceof PsiExpression) {
                    PsiClass baseClass;
                    PsiMethod[] refMethods;
                    PsiAnonymousClass anonymousClass;
                    PsiExpression initializer2;
                    PsiElement resolve2;
                    PsiType type2 = ((PsiExpression)qualifier2).getType();
                    if (type2 != null && qualifier2 instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifier2).resolve()) instanceof PsiVariable && ((PsiVariable)resolve2).hasModifierProperty("final") && ((PsiVariable)resolve2).hasInitializer() && (initializer2 = ((PsiVariable)resolve2).getInitializer()) instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)initializer2).getAnonymousClass()) != null && type2.equals(anonymousClass.getBaseClassType()) && (refMethods = anonymousClass.findMethodsByName(methodCall.getMethodExpression().getReferenceName(), false)).length > 0 && (baseClass = PsiUtil.resolveClassInType(type2)) != null && !PsiScopesUtil.hasCovariantOverridingOrNotPublic(baseClass, refMethods)) {
                        for (PsiMethod method : refMethods) {
                            if (method.findSuperMethods(baseClass).length <= 0) continue;
                            type2 = initializer2.getType();
                            break;
                        }
                    }
                    if (type2 == null) {
                        if (!(qualifier2 instanceof PsiJavaCodeReferenceElement)) throw new MethodProcessorSetupFailedException("Cant determine qualifier type!");
                        JavaResolveResult result2 = ((PsiJavaCodeReferenceElement)qualifier2).advancedResolve(false);
                        if (!(result2.getElement() instanceof PsiClass)) return;
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                        PsiScopesUtil.processQualifierResult(result2, processor, methodCall);
                        return;
                    } else if (type2 instanceof PsiIntersectionType) {
                        PsiType[] conjuncts;
                        for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type2).getConjuncts()) {
                            if (!PsiScopesUtil.processQualifierType(conjunct, processor, manager, methodCall)) break;
                        }
                        return;
                    } else if (type2 instanceof PsiDisjunctionType) {
                        PsiScopesUtil.processQualifierType(((PsiDisjunctionType)type2).getLeastUpperBound(), processor, manager, methodCall);
                        return;
                    } else {
                        PsiScopesUtil.processQualifierType(type2, processor, manager, methodCall);
                    }
                    return;
                } else {
                    LOG.error("ref: " + ref + " (" + ref.getClass() + ")," + " ref.getReferenceNameElement()=" + ref.getReferenceNameElement() + "; methodCall.getMethodExpression().getReferenceNameElement()=" + methodCall.getMethodExpression().getReferenceNameElement() + "; qualifier=" + qualifier2);
                }
            }
            return;
        } else {
            LOG.assertTrue(call instanceof PsiNewExpression);
            PsiNewExpression newExpr = (PsiNewExpression)call;
            PsiJavaCodeReferenceElement classRef = newExpr.getClassOrAnonymousClassReference();
            if (classRef == null) {
                throw new MethodProcessorSetupFailedException("Cant get reference to class in new expression");
            }
            JavaResolveResult result3 = classRef.advancedResolve(false);
            PsiClass aClass4 = (PsiClass)result3.getElement();
            if (aClass4 == null) {
                throw new MethodProcessorSetupFailedException("Cant resolve class in new expression");
            }
            processor.setIsConstructor(true);
            processor.setAccessClass(aClass4);
            processor.setArgumentList(newExpr.getArgumentList());
            processor.obtainTypeArguments(newExpr);
            aClass4.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result3.getSubstitutor()), null, call);
            if (!dummyImplicitConstructor) return;
            PsiScopesUtil.processDummyConstructor(processor, aClass4);
        }
    }

    private static boolean hasCovariantOverridingOrNotPublic(PsiClass baseClass, PsiMethod[] refMethods) {
        for (PsiMethod method : refMethods) {
            PsiType methodReturnType = method.getReturnType();
            for (PsiMethod superMethod : method.findSuperMethods(baseClass)) {
                if (!Comparing.equal(methodReturnType, superMethod.getReturnType())) {
                    return true;
                }
                if (superMethod.hasModifierProperty("public")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean processQualifierType(@NotNull PsiType type2, MethodsProcessor processor, PsiManager manager, PsiMethodCallExpression call) throws MethodProcessorSetupFailedException {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierType"));
        }
        LOG.assertTrue(type2.isValid());
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)type2).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call);
        }
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call);
            PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
            PsiClassType.ClassResolveResult qualifierResult = factory.getArrayClassType(((PsiArrayType)type2).getComponentType(), languageLevel).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call);
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                if (PsiScopesUtil.processQualifierType(conjunct, processor, manager, call)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQualifierResult(@NotNull JavaResolveResult qualifierResult, @NotNull MethodsProcessor processor, @NotNull PsiMethodCallExpression methodCall) throws MethodProcessorSetupFailedException {
        if (qualifierResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierResult", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierResult"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierResult"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierResult"));
        }
        PsiElement resolve2 = qualifierResult.getElement();
        if (resolve2 == null) {
            throw new MethodProcessorSetupFailedException("Cant determine qualifier class!");
        }
        if (resolve2 instanceof PsiTypeParameter) {
            processor.setAccessClass((PsiClass)resolve2);
        } else if (resolve2 instanceof PsiClass) {
            PsiExpression qualifier2 = methodCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier2 instanceof PsiSuperExpression)) {
                processor.setAccessClass((PsiClass)PsiUtil.getAccessObjectClass(qualifier2).getElement());
            } else if (((PsiSuperExpression)qualifier2).getQualifier() != null && PsiUtil.isLanguageLevel8OrHigher(qualifier2) && "java.lang.Cloneable".equals(((PsiClass)resolve2).getQualifiedName()) && ((PsiClass)resolve2).isInterface()) {
                processor.setAccessClass((PsiClass)resolve2);
            }
        }
        processor.setIsConstructor(false);
        processor.setName(methodCall.getMethodExpression().getReferenceName());
        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, qualifierResult.getSubstitutor());
        return resolve2.processDeclarations(processor, state2, methodCall, methodCall);
    }

    private static void processDummyConstructor(MethodsProcessor processor, PsiClass aClass2) {
        if (aClass2 instanceof PsiAnonymousClass) {
            return;
        }
        try {
            PsiMethod[] constructors2 = aClass2.getConstructors();
            if (constructors2.length != 0) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory();
            PsiMethod dummyConstructor = factory.createConstructor();
            PsiIdentifier nameIdentifier = aClass2.getNameIdentifier();
            if (nameIdentifier != null) {
                dummyConstructor.getNameIdentifier().replace(nameIdentifier);
            }
            processor.forceAddResult(dummyConstructor);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }
}

