/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionListImpl
extends CompositePsiElement
implements PsiExpressionList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiExpressionListImpl");

    public PsiExpressionListImpl() {
        super(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    @NotNull
    public PsiExpression[] getExpressions() {
        PsiExpression[] psiExpressionArray = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl", "getExpressions"));
        }
        return psiExpressionArray;
    }

    @Override
    @NotNull
    public PsiType[] getExpressionTypes() {
        PsiExpression[] expressions = this.getExpressions();
        PsiType[] types2 = PsiType.createArray(expressions.length);
        for (int i = 0; i < types2.length; ++i) {
            types2[i] = expressions[i].getType();
        }
        if (types2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl", "getExpressionTypes"));
        }
        return types2;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                return this.getFirstChildNode() != null && this.getFirstChildNode().getElementType() == JavaTokenType.LPARENTH ? this.getFirstChildNode() : null;
            }
            case 25: 
        }
        if (this.getLastChildNode() != null && this.getLastChildNode().getElementType() == JavaTokenType.RPARENTH) {
            return this.getLastChildNode();
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (anchor2 == null) {
            LeafElement lparenth;
            if (before == null || before.booleanValue()) {
                anchor2 = this.findChildByRole(25);
                if (anchor2 == null) {
                    lparenth = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(lparenth, lparenth, null, Boolean.FALSE);
                    LeafElement rparenth = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(rparenth, rparenth, null, Boolean.TRUE);
                    anchor2 = this.findChildByRole(25);
                    LOG.assertTrue(anchor2 != null);
                }
                before = Boolean.TRUE;
            } else {
                anchor2 = this.findChildByRole(24);
                if (anchor2 == null) {
                    lparenth = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(lparenth, lparenth, null, Boolean.FALSE);
                    LeafElement rparenth = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(rparenth, rparenth, null, Boolean.TRUE);
                    anchor2 = this.findChildByRole(24);
                    LOG.assertTrue(anchor2 != null);
                }
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor2, before);
        if (ElementType.EXPRESSION_BIT_SET.contains(first.getElementType())) {
            JavaSourceUtil.addSeparatingComma(this, first, ElementType.EXPRESSION_BIT_SET);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl", "deleteChildInternal"));
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitExpressionList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiExpressionList";
    }
}

