/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformanceWatcher {
    private static final Logger LOG = Logger.getInstance("#com.intellij.diagnostic.PerformanceWatcher");
    private final Semaphore myShutdownSemaphore = new Semaphore(1);
    private ThreadMXBean myThreadMXBean;
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private File myCurHangLogDir;
    private List<StackTraceElement> myStacktraceCommonPart;
    private volatile ApdexData mySwingApdex = ApdexData.EMPTY;
    private volatile ApdexData myGeneralApdex = ApdexData.EMPTY;
    private int UNRESPONSIVE_THRESHOLD_SECONDS = 5;
    private int UNRESPONSIVE_INTERVAL_SECONDS = 5;

    public static PerformanceWatcher getInstance() {
        return ApplicationManager.getApplication().getComponent(PerformanceWatcher.class);
    }

    private boolean shouldWatch() {
        return !ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.UNRESPONSIVE_INTERVAL_SECONDS != 0 && this.UNRESPONSIVE_THRESHOLD_SECONDS != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean millis) {
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "com/intellij/diagnostic/PerformanceWatcher", "dumpThreads"));
        }
        if (!this.shouldWatch()) {
            return null;
        }
        String suffix = millis ? "-" + System.currentTimeMillis() : "";
        File file = new File(this.myCurHangLogDir, pathPrefix + "threadDump-" + this.myDateFormat.format(new Date()) + suffix + ".txt");
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        PerformanceWatcher.checkMemoryUsage(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            try {
                StackTraceElement[] edtStack = ThreadDumper.dumpThreadsToFile(this.myThreadMXBean, writer);
                if (edtStack != null) {
                    if (this.myStacktraceCommonPart == null) {
                        this.myStacktraceCommonPart = ContainerUtil.newArrayList(edtStack);
                    } else {
                        this.updateStacktraceCommonPart(edtStack);
                    }
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    private static void checkMemoryUsage(File file) {
        Runtime rt = Runtime.getRuntime();
        long allocatedMem = rt.totalMemory();
        long unusedMem = rt.freeMemory();
        if (unusedMem < allocatedMem / 5L) {
            LOG.info("High memory usage (free " + unusedMem / 1024L / 1024L + " of " + allocatedMem / 1024L / 1024L + " MB) while dumping threads to " + file);
        }
    }

    private void updateStacktraceCommonPart(StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < this.myStacktraceCommonPart.size() && i < stackTraceElements.length; ++i) {
            StackTraceElement el2;
            StackTraceElement el1 = this.myStacktraceCommonPart.get(this.myStacktraceCommonPart.size() - i - 1);
            if (el1.equals(el2 = stackTraceElements[stackTraceElements.length - i - 1])) continue;
            this.myStacktraceCommonPart = this.myStacktraceCommonPart.subList(this.myStacktraceCommonPart.size() - i, this.myStacktraceCommonPart.size());
            break;
        }
    }
}

