/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.typeUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCapabilitiesKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u001a\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u001a$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\n\u0010\u0013\u001a\u00020\r*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0002\u001a0\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00020\u00062\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0018\u001a\u001e\u0010\u0019\u001a\u00020\u0015*\u00020\u00022\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00150\u0018\u001a\n\u0010\u001b\u001a\u00020\u0015*\u00020\u0002\u001a\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d*\b\u0012\u0004\u0012\u00020\u00020\u001d\u001a\u001e\u0010\u001e\u001a\u00020\u0015*\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00022\b\u0010!\u001a\u0004\u0018\u00010\u0002\u001a\f\u0010\"\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\u0010\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u0002\u001a\n\u0010$\u001a\u00020\u0015*\u00020\u0002\u001a\f\u0010%\u001a\u00020\u0015*\u0004\u0018\u00010\u0002\u001a\n\u0010&\u001a\u00020\u0015*\u00020\u0002\u001a\n\u0010'\u001a\u00020\u0015*\u00020\u0002\u001a\n\u0010(\u001a\u00020\u0015*\u00020\u0002\u001a\n\u0010)\u001a\u00020\u0015*\u00020\u0002\u001a\n\u0010*\u001a\u00020\u0015*\u00020\u0002\u001a\n\u0010+\u001a\u00020\u0015*\u00020\u0002\u001a\u0012\u0010,\u001a\u00020\u0015*\u00020\u00022\u0006\u0010-\u001a\u00020\u0002\u001a\n\u0010.\u001a\u00020\u0015*\u00020\u0002\u001a\u000f\u0010/\u001a\u00070\u0002\u00a2\u0006\u0002\b0*\u00020\u0002\u001a\u000f\u00101\u001a\u00070\u0002\u00a2\u0006\u0002\b0*\u00020\u0002\u001a\u0017\u00102\u001a\u00070\u0002\u00a2\u0006\u0002\b0*\u00020\u00022\u0006\u00103\u001a\u00020\u0015\u001a\n\u00104\u001a\u000205*\u00020\u0002\u001a\u0012\u00106\u001a\u00020\u0002*\u00020\u00022\u0006\u00107\u001a\u000208\u001a\u001e\u00109\u001a\u00020\r*\u00020\r2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0018\u001a\u0010\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u0002\u001a\n\u0010<\u001a\u00020\u0015*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006="}, d2={"builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getBuiltIns", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "boundClosure", "", "types", "constituentTypes", "", "result", "", "createProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "projectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "asTypeProjection", "cannotBeReified", "", "closure", "f", "Lkotlin/Function1;", "contains", "predicate", "containsError", "defaultProjections", "", "equalTypesOrNulls", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "type1", "type2", "getImmediateSuperclassNotAny", "immediateSupertypes", "isAnyOrNullableAny", "isArrayOfNothing", "isBoolean", "isBooleanOrNullableBoolean", "isDefaultBound", "isNothing", "isNullableAny", "isNullableNothing", "isSubtypeOf", "superType", "isUnit", "makeNotNullable", "Lorg/jetbrains/annotations/NotNull;", "makeNullable", "makeNullableIfNeeded", "nullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "replaceAnnotations", "newAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "substitute", "doSubstitute", "supertypes", "unsafeAsReifiedArgument", "kotlin-compiler"})
public final class TypeUtilsKt {
    @NotNull
    public static final TypeNullability nullability(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FlexibleTypesKt.isNullabilityFlexible($receiver) ? TypeNullability.FLEXIBLE : (TypeUtils.isNullableType($receiver) ? TypeNullability.NULLABLE : TypeNullability.NOT_NULL);
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KotlinBuiltIns kotlinBuiltIns = $receiver.getConstructor().getBuiltIns();
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "constructor.builtIns");
        return kotlinBuiltIns;
    }

    @NotNull
    public static final KotlinType makeNullable(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNullable($receiver);
    }

    @NotNull
    public static final KotlinType makeNullableIfNeeded(KotlinType $receiver, boolean nullable2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNullableIfNeeded($receiver, nullable2);
    }

    @NotNull
    public static final KotlinType makeNotNullable(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtils.makeNotNullable($receiver);
    }

    @NotNull
    public static final Collection<KotlinType> immediateSupertypes(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection collection = TypeUtils.getImmediateSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull(collection, "TypeUtils.getImmediateSupertypes(this)");
        return collection;
    }

    @NotNull
    public static final Collection<KotlinType> supertypes(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Collection collection = TypeUtils.getAllSupertypes($receiver);
        Intrinsics.checkExpressionValueIsNotNull(collection, "TypeUtils.getAllSupertypes(this)");
        return collection;
    }

    public static final boolean isNothing(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNothing($receiver);
    }

    public static final boolean isNullableNothing(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNullableNothing($receiver);
    }

    public static final boolean isUnit(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isUnit($receiver);
    }

    public static final boolean isAnyOrNullableAny(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isAnyOrNullableAny($receiver);
    }

    public static final boolean isNullableAny(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNullableAny($receiver);
    }

    public static final boolean isBoolean(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isBoolean($receiver);
    }

    public static final boolean isBooleanOrNullableBoolean(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isBooleanOrNullableBoolean($receiver);
    }

    public static final boolean isArrayOfNothing(KotlinType $receiver) {
        if ($receiver == null || !KotlinBuiltIns.isArray($receiver)) {
            return false;
        }
        TypeProjection typeProjection = CollectionsKt.firstOrNull($receiver.getArguments());
        KotlinType typeArg = typeProjection != null ? typeProjection.getType() : null;
        return typeArg != null && KotlinBuiltIns.isNothingOrNullableNothing(typeArg);
    }

    public static final boolean isSubtypeOf(KotlinType $receiver, @NotNull KotlinType superType) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return KotlinTypeChecker.DEFAULT.isSubtypeOf($receiver, superType);
    }

    public static final boolean cannotBeReified(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isNothingOrNullableNothing($receiver) || DynamicTypesKt.isDynamic($receiver) || CapturedTypeConstructorKt.isCaptured($receiver);
    }

    public static final boolean unsafeAsReifiedArgument(KotlinType $receiver) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Iterable $receiver$iv = $receiver.getArguments();
            for (Object element$iv : $receiver$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                if (!(!it.isStarProjection())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final TypeProjection substitute(TypeProjection $receiver, @NotNull Function1<? super KotlinType, ? extends KotlinType> doSubstitute) {
        TypeProjection typeProjection;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(doSubstitute, "doSubstitute");
        if ($receiver.isStarProjection()) {
            typeProjection = $receiver;
        } else {
            Variance variance = $receiver.getProjectionKind();
            KotlinType kotlinType = $receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
            typeProjection = new TypeProjectionImpl(variance, doSubstitute.invoke(kotlinType));
        }
        return typeProjection;
    }

    @NotNull
    public static final KotlinType replaceAnnotations(KotlinType $receiver, @NotNull Annotations newAnnotations) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newAnnotations, "newAnnotations");
        if ($receiver.getAnnotations().isEmpty() && newAnnotations.isEmpty()) {
            return $receiver;
        }
        return new DelegatingType($receiver, newAnnotations){
            final /* synthetic */ KotlinType receiver$0;
            final /* synthetic */ Annotations $newAnnotations;

            @NotNull
            protected KotlinType getDelegate() {
                return this.receiver$0;
            }

            @NotNull
            public Annotations getAnnotations() {
                return this.$newAnnotations;
            }
            {
                this.receiver$0 = $receiver;
                this.$newAnnotations = $captured_local_variable$1;
            }
        };
    }

    public static final boolean equalTypesOrNulls(KotlinTypeChecker $receiver, @Nullable KotlinType type1, @Nullable KotlinType type2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return $receiver.equalTypes(type1, type2);
    }

    public static final boolean containsError(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ErrorUtils.containsErrorType($receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> defaultProjections(List<? extends KotlinType> $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver$iv = $receiver;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl((KotlinType)it);
            collection.add(typeProjectionImpl);
        }
        return (List)var3_3;
    }

    public static final boolean isDefaultBound(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isDefaultBound(TypeCapabilitiesKt.getSupertypeRepresentative($receiver));
    }

    @NotNull
    public static final TypeProjection createProjection(@NotNull KotlinType type2, @NotNull Variance projectionKind, @Nullable TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull((Object)projectionKind, "projectionKind");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl(Intrinsics.areEqual((Object)(typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null), (Object)projectionKind) ? Variance.INVARIANT : projectionKind, type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinType> closure(Collection<? extends KotlinType> $receiver, @NotNull Function1<? super KotlinType, ? extends Collection<? extends KotlinType>> f) {
        HashSet<KotlinType> result2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(f, "f");
        if ($receiver.size() == 0) {
            return $receiver;
        }
        HashSet<KotlinType> elementsToCheck = result2 = new HashSet<KotlinType>($receiver);
        int oldSize = 0;
        while (result2.size() > oldSize) {
            void $receiver$iv;
            oldSize = result2.size();
            HashSet<KotlinType> toAdd = SetsKt.hashSetOf(new KotlinType[0]);
            Iterable iterable = elementsToCheck;
            for (Object element$iv : $receiver$iv) {
                KotlinType it;
                KotlinType kotlinType = it = (KotlinType)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it");
                toAdd.addAll(f.invoke(kotlinType));
            }
            result2.addAll((Collection<KotlinType>)toAdd);
            elementsToCheck = toAdd;
        }
        return result2;
    }

    @NotNull
    public static final Collection<KotlinType> boundClosure(@NotNull Collection<? extends KotlinType> types2) {
        Intrinsics.checkParameterIsNotNull(types2, "types");
        return TypeUtilsKt.closure(types2, boundClosure.1.INSTANCE);
    }

    @NotNull
    public static final Collection<KotlinType> constituentTypes(@NotNull Collection<? extends KotlinType> types2) {
        Intrinsics.checkParameterIsNotNull(types2, "types");
        HashSet<KotlinType> result2 = SetsKt.hashSetOf(new KotlinType[0]);
        TypeUtilsKt.constituentTypes((Set<KotlinType>)result2, types2);
        return result2;
    }

    private static final void constituentTypes(Set<KotlinType> result2, Collection<? extends KotlinType> types2) {
        result2.addAll(types2);
        for (KotlinType kotlinType : types2) {
            Collection destination$iv$iv;
            TypeProjection it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Flexibility $receiver;
            Iterable receiver$iv;
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                Flexibility flexibility = FlexibleTypesKt.flexibility(kotlinType);
                $receiver = (Flexibility)((Object)receiver$iv);
                TypeUtilsKt.constituentTypes(result2, (Collection<? extends KotlinType>)SetsKt.setOf($receiver.getLowerBound(), $receiver.getUpperBound()));
                continue;
            }
            receiver$iv = kotlinType.getArguments();
            Set<KotlinType> set = result2;
            $receiver = $receiver$iv;
            Collection $i$a$1 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (TypeProjection)element$iv$iv;
                if (it.isStarProjection()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<KotlinType> collection = (List)destination$iv$iv;
            $receiver$iv = collection;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (TypeProjection)item$iv$iv;
                collection = destination$iv$iv;
                KotlinType kotlinType2 = it.getType();
                collection.add(kotlinType2);
            }
            collection = (List)destination$iv$iv;
            TypeUtilsKt.constituentTypes(set, (Collection<? extends KotlinType>)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinType getImmediateSuperclassNotAny(KotlinType $receiver) {
        KotlinType kotlinType;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Object $receiver$iv = $receiver.getConstructor().getSupertypes();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            if (!(DescriptorUtils.isClassOrEnumClass(it.getConstructor().getDeclarationDescriptor()) && !KotlinBuiltIns.isAnyOrNullableAny(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superclasses = (List)destination$iv$iv;
        KotlinType kotlinType2 = (KotlinType)CollectionsKt.singleOrNull(superclasses);
        if (kotlinType2 != null) {
            $receiver$iv = kotlinType2;
            KotlinType it = (KotlinType)$receiver$iv;
            kotlinType = TypeUtils.createSubstitutedSupertype($receiver, it, TypeSubstitutor.create($receiver));
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    @NotNull
    public static final TypeProjection asTypeProjection(KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new TypeProjectionImpl($receiver);
    }

    public static final boolean contains(KotlinType $receiver, @NotNull Function1<? super KotlinType, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        return TypeUtils.contains($receiver, predicate);
    }
}

