/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeCapabilities;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorSimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.utils.Printer;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE = new ModuleDescriptor(){

        @Override
        @Nullable
        public <T> T getCapability(@NotNull ModuleDescriptor.Capability<T> capability) {
            if (capability == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capability", "org/jetbrains/kotlin/types/ErrorUtils$1", "getCapability"));
            }
            return null;
        }

        @Override
        @NotNull
        public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
            throw new IllegalStateException("Should not be called!");
        }

        @Override
        @NotNull
        public List<ImportPath> getDefaultImports() {
            List<ImportPath> list2 = CollectionsKt.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$1", "getDefaultImports"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$1", "getAnnotations"));
            }
            return annotations2;
        }

        @Override
        @NotNull
        public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/types/ErrorUtils$1", "getSubPackagesOf"));
            }
            if (nameFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "org/jetbrains/kotlin/types/ErrorUtils$1", "getSubPackagesOf"));
            }
            List<FqName> list2 = CollectionsKt.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$1", "getSubPackagesOf"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Name getName() {
            Name name = Name.special("<ERROR MODULE>");
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$1", "getName"));
            }
            return name;
        }

        @Override
        @NotNull
        public PackageViewDescriptor getPackage(@NotNull FqName fqName2) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/types/ErrorUtils$1", "getPackage"));
            }
            throw new IllegalStateException("Should not be called!");
        }

        @Override
        public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data) {
            if (visitor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/types/ErrorUtils$1", "accept"));
            }
            return null;
        }

        @Override
        public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor2) {
        }

        @Override
        @NotNull
        public ModuleDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
            if (substitutor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/types/ErrorUtils$1", "substitute"));
            }
            1 v0 = this;
            if (v0 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$1", "substitute"));
            }
            return v0;
        }

        @Override
        public boolean isFriend(@NotNull ModuleDescriptor other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/types/ErrorUtils$1", "isFriend"));
            }
            return false;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getOriginal() {
            1 v0 = this;
            if (v0 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$1", "getOriginal"));
            }
            return v0;
        }

        @Override
        @Nullable
        public DeclarationDescriptor getContainingDeclaration() {
            return null;
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            DefaultBuiltIns defaultBuiltIns = DefaultBuiltIns.getInstance();
            if (defaultBuiltIns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$1", "getBuiltIns"));
            }
            return defaultBuiltIns;
        }
    };
    private static final ErrorClassDescriptor ERROR_CLASS = new ErrorClassDescriptor(null);
    private static final KotlinType ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
    private static final PropertyDescriptor ERROR_PROPERTY = ErrorUtils.createErrorProperty();
    private static final Set<PropertyDescriptor> ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);

    public static boolean containsErrorType(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/ErrorUtils", "containsErrorType"));
        }
        if (ErrorUtils.containsErrorType(function.getReturnType())) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameter = function.getExtensionReceiverParameter();
        if (receiverParameter != null && ErrorUtils.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            if (!ErrorUtils.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function.getTypeParameters()) {
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!ErrorUtils.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static ClassDescriptor createErrorClass(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorClass"));
        }
        ErrorClassDescriptor errorClassDescriptor = new ErrorClassDescriptor(debugMessage);
        if (errorClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorClass"));
        }
        return errorClassDescriptor;
    }

    @NotNull
    public static MemberScope createErrorScope(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorScope"));
        }
        MemberScope memberScope2 = ErrorUtils.createErrorScope(debugMessage, false);
        if (memberScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorScope"));
        }
        return memberScope2;
    }

    @NotNull
    public static MemberScope createErrorScope(@NotNull String debugMessage, boolean throwExceptions) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorScope"));
        }
        if (throwExceptions) {
            ThrowingScope throwingScope = new ThrowingScope(debugMessage);
            if (throwingScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorScope"));
            }
            return throwingScope;
        }
        ErrorScope errorScope = new ErrorScope(debugMessage);
        if (errorScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorScope"));
        }
        return errorScope;
    }

    @NotNull
    private static PropertyDescriptorImpl createErrorProperty() {
        PropertyDescriptorImpl descriptor2 = PropertyDescriptorImpl.create(ERROR_CLASS, Annotations.Companion.getEMPTY(), Modality.OPEN, Visibilities.INTERNAL, true, Name.special("<ERROR PROPERTY>"), CallableMemberDescriptor.Kind.DECLARATION, SourceElement.NO_SOURCE, false, false);
        descriptor2.setType(ERROR_PROPERTY_TYPE, Collections.emptyList(), null, (KotlinType)null);
        PropertyDescriptorImpl propertyDescriptorImpl = descriptor2;
        if (propertyDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorProperty"));
        }
        return propertyDescriptorImpl;
    }

    @NotNull
    private static SimpleFunctionDescriptor createErrorFunction(@NotNull ErrorScope ownerScope) {
        if (ownerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerScope", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorFunction"));
        }
        ErrorSimpleFunctionDescriptorImpl function = new ErrorSimpleFunctionDescriptorImpl(ERROR_CLASS, ownerScope);
        function.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.INTERNAL);
        ErrorSimpleFunctionDescriptorImpl errorSimpleFunctionDescriptorImpl = function;
        if (errorSimpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorFunction"));
        }
        return errorSimpleFunctionDescriptorImpl;
    }

    @NotNull
    public static KotlinType createErrorType(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorType"));
        }
        KotlinType kotlinType = ErrorUtils.createErrorTypeWithArguments(debugMessage, Collections.<TypeProjection>emptyList());
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorType"));
        }
        return kotlinType;
    }

    @NotNull
    public static KotlinType createErrorTypeWithCustomDebugName(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithCustomDebugName"));
        }
        KotlinType kotlinType = ErrorUtils.createErrorTypeWithCustomConstructor(debugName, ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName));
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithCustomDebugName"));
        }
        return kotlinType;
    }

    @NotNull
    public static KotlinType createErrorTypeWithCustomConstructor(@NotNull String debugName, @NotNull TypeConstructor typeConstructor2) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithCustomConstructor"));
        }
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithCustomConstructor"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl(typeConstructor2, ErrorUtils.createErrorScope(debugName));
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithCustomConstructor"));
        }
        return errorTypeImpl;
    }

    @NotNull
    public static KotlinType createErrorTypeWithArguments(@NotNull String debugMessage, @NotNull List<TypeProjection> arguments2) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithArguments"));
        }
        ErrorTypeImpl errorTypeImpl = new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructor(debugMessage), ErrorUtils.createErrorScope(debugMessage), arguments2);
        if (errorTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeWithArguments"));
        }
        return errorTypeImpl;
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructor(@NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeConstructor"));
        }
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("[ERROR : " + debugMessage + "]", ERROR_CLASS);
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeConstructor"));
        }
        return typeConstructor2;
    }

    @NotNull
    public static TypeConstructor createErrorTypeConstructorWithCustomDebugName(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructorWithCustomDebugName(debugName, ERROR_CLASS);
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        return typeConstructor2;
    }

    @NotNull
    private static TypeConstructor createErrorTypeConstructorWithCustomDebugName(final @NotNull String debugName, final @NotNull ErrorClassDescriptor errorClass) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        if (errorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorClass", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        TypeConstructor typeConstructor2 = new TypeConstructor(){

            @Override
            @NotNull
            public List<TypeParameterDescriptor> getParameters() {
                List<TypeParameterDescriptor> list2 = CollectionsKt.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$2", "getParameters"));
                }
                return list2;
            }

            @Override
            @NotNull
            public Collection<KotlinType> getSupertypes() {
                List<KotlinType> list2 = CollectionsKt.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$2", "getSupertypes"));
                }
                return list2;
            }

            @Override
            public boolean isFinal() {
                return false;
            }

            @Override
            public boolean isDenotable() {
                return false;
            }

            @Override
            @Nullable
            public ClassifierDescriptor getDeclarationDescriptor() {
                return errorClass;
            }

            @Override
            @NotNull
            public KotlinBuiltIns getBuiltIns() {
                DefaultBuiltIns defaultBuiltIns = DefaultBuiltIns.getInstance();
                if (defaultBuiltIns == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$2", "getBuiltIns"));
                }
                return defaultBuiltIns;
            }

            @Override
            @NotNull
            public Annotations getAnnotations() {
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                if (annotations2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$2", "getAnnotations"));
                }
                return annotations2;
            }

            public String toString() {
                return debugName;
            }
        };
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeConstructorWithCustomDebugName"));
        }
        return typeConstructor2;
    }

    public static boolean containsErrorType(@Nullable KotlinType type2) {
        if (type2 == null) {
            return false;
        }
        if (type2.isError()) {
            return true;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@NotNull DeclarationDescriptor candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/types/ErrorUtils", "isError"));
        }
        return ErrorUtils.isErrorClass(candidate) || ErrorUtils.isErrorClass(candidate.getContainingDeclaration()) || candidate == ERROR_MODULE;
    }

    private static boolean isErrorClass(@Nullable DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    @NotNull
    public static TypeParameterDescriptor createErrorTypeParameter(int index2, @NotNull String debugMessage) {
        if (debugMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeParameter"));
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound(ERROR_CLASS, Annotations.Companion.getEMPTY(), false, Variance.INVARIANT, Name.special("<ERROR: " + debugMessage + ">"), index2);
        if (typeParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createErrorTypeParameter"));
        }
        return typeParameterDescriptor;
    }

    @NotNull
    public static ModuleDescriptor getErrorModule() {
        ModuleDescriptor moduleDescriptor = ERROR_MODULE;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "getErrorModule"));
        }
        return moduleDescriptor;
    }

    public static boolean isUninferredParameter(@Nullable KotlinType type2) {
        return type2 != null && type2.getConstructor() instanceof UninferredParameterTypeConstructor;
    }

    public static boolean containsUninferredParameter(@Nullable KotlinType type2) {
        return TypeUtils.contains(type2, new Function1<KotlinType, Boolean>(){

            @Override
            public Boolean invoke(KotlinType argumentType) {
                return ErrorUtils.isUninferredParameter(argumentType);
            }
        });
    }

    @NotNull
    public static KotlinType createUninferredParameterType(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/types/ErrorUtils", "createUninferredParameterType"));
        }
        KotlinType kotlinType = ErrorUtils.createErrorTypeWithCustomConstructor("Scope for error type for not inferred parameter: " + typeParameterDescriptor.getName(), new UninferredParameterTypeConstructor(typeParameterDescriptor));
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils", "createUninferredParameterType"));
        }
        return kotlinType;
    }

    private ErrorUtils() {
    }

    public static class UninferredParameterTypeConstructor
    implements TypeConstructor {
        private final TypeParameterDescriptor typeParameterDescriptor;
        private final TypeConstructor errorTypeConstructor;

        private UninferredParameterTypeConstructor(@NotNull TypeParameterDescriptor descriptor2) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/ErrorUtils$UninferredParameterTypeConstructor", "<init>"));
            }
            this.typeParameterDescriptor = descriptor2;
            this.errorTypeConstructor = ErrorUtils.createErrorTypeConstructorWithCustomDebugName("CANT_INFER_TYPE_PARAMETER: " + descriptor2.getName());
        }

        @NotNull
        public TypeParameterDescriptor getTypeParameterDescriptor() {
            TypeParameterDescriptor typeParameterDescriptor = this.typeParameterDescriptor;
            if (typeParameterDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$UninferredParameterTypeConstructor", "getTypeParameterDescriptor"));
            }
            return typeParameterDescriptor;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List<TypeParameterDescriptor> list2 = this.errorTypeConstructor.getParameters();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$UninferredParameterTypeConstructor", "getParameters"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<KotlinType> getSupertypes() {
            Collection<KotlinType> collection = this.errorTypeConstructor.getSupertypes();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$UninferredParameterTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        @Override
        public boolean isFinal() {
            return this.errorTypeConstructor.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return this.errorTypeConstructor.isDenotable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return this.errorTypeConstructor.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = this.errorTypeConstructor.getAnnotations();
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$UninferredParameterTypeConstructor", "getAnnotations"));
            }
            return annotations2;
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            KotlinBuiltIns kotlinBuiltIns = DescriptorUtilsKt.getBuiltIns(this.typeParameterDescriptor);
            if (kotlinBuiltIns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$UninferredParameterTypeConstructor", "getBuiltIns"));
            }
            return kotlinBuiltIns;
        }
    }

    private static class ErrorTypeImpl
    implements KotlinType {
        private final TypeConstructor constructor;
        private final MemberScope memberScope;
        private final List<TypeProjection> arguments;

        private ErrorTypeImpl(@NotNull TypeConstructor constructor, @NotNull MemberScope memberScope2, @NotNull List<TypeProjection> arguments2) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            if (memberScope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            this.constructor = constructor;
            this.memberScope = memberScope2;
            this.arguments = arguments2;
        }

        private ErrorTypeImpl(@NotNull TypeConstructor constructor, @NotNull MemberScope memberScope2) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            if (memberScope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "<init>"));
            }
            this(constructor, memberScope2, Collections.emptyList());
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            TypeConstructor typeConstructor2 = this.constructor;
            if (typeConstructor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "getConstructor"));
            }
            return typeConstructor2;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            List<TypeProjection> list2 = this.arguments;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "getArguments"));
            }
            return list2;
        }

        @Override
        @NotNull
        public TypeSubstitution getSubstitution() {
            TypeSubstitution typeSubstitution = TypeConstructorSubstitution.create(this.constructor, this.arguments);
            if (typeSubstitution == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "getSubstitution"));
            }
            return typeSubstitution;
        }

        @Override
        public boolean isMarkedNullable() {
            return false;
        }

        @Override
        @NotNull
        public MemberScope getMemberScope() {
            MemberScope memberScope2 = this.memberScope;
            if (memberScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "getMemberScope"));
            }
            return memberScope2;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "getAnnotations"));
            }
            return annotations2;
        }

        @Override
        @Nullable
        public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
            if (capabilityClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capabilityClass", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "getCapability"));
            }
            return null;
        }

        @Override
        @NotNull
        public TypeCapabilities getCapabilities() {
            TypeCapabilities.NONE nONE = TypeCapabilities.NONE.INSTANCE;
            if (nONE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorTypeImpl", "getCapabilities"));
            }
            return nONE;
        }

        public String toString() {
            return this.constructor.toString() + (this.arguments.isEmpty() ? "" : CollectionsKt.joinToString(this.arguments, ", ", "<", ">", -1, "...", null));
        }
    }

    private static class ErrorClassDescriptor
    extends ClassDescriptorImpl {
        public ErrorClassDescriptor(@Nullable String name) {
            super(ErrorUtils.getErrorModule(), Name.special(name == null ? "<ERROR CLASS>" : "<ERROR CLASS: " + name + ">"), Modality.OPEN, ClassKind.CLASS, Collections.<KotlinType>emptyList(), SourceElement.NO_SOURCE);
            ConstructorDescriptorImpl errorConstructor = ConstructorDescriptorImpl.create(this, Annotations.Companion.getEMPTY(), true, SourceElement.NO_SOURCE);
            errorConstructor.initialize(Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
            MemberScope memberScope2 = ErrorUtils.createErrorScope(this.getName().asString());
            errorConstructor.setReturnType(new ErrorTypeImpl(ErrorUtils.createErrorTypeConstructorWithCustomDebugName("<ERROR>", this), memberScope2));
            this.initialize(memberScope2, Collections.singleton(errorConstructor), errorConstructor);
        }

        @Override
        @NotNull
        public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
            if (substitutor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/types/ErrorUtils$ErrorClassDescriptor", "substitute"));
            }
            ErrorClassDescriptor errorClassDescriptor = this;
            if (errorClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorClassDescriptor", "substitute"));
            }
            return errorClassDescriptor;
        }

        @Override
        public String toString() {
            return this.getName().asString();
        }

        @Override
        @NotNull
        public MemberScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
            if (typeArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/types/ErrorUtils$ErrorClassDescriptor", "getMemberScope"));
            }
            MemberScope memberScope2 = ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeArguments);
            if (memberScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorClassDescriptor", "getMemberScope"));
            }
            return memberScope2;
        }

        @Override
        @NotNull
        public MemberScope getMemberScope(@NotNull TypeSubstitution typeSubstitution) {
            if (typeSubstitution == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitution", "org/jetbrains/kotlin/types/ErrorUtils$ErrorClassDescriptor", "getMemberScope"));
            }
            MemberScope memberScope2 = ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeSubstitution);
            if (memberScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorClassDescriptor", "getMemberScope"));
            }
            return memberScope2;
        }
    }

    private static class ThrowingScope
    implements MemberScope {
        private final String debugMessage;

        private ThrowingScope(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "<init>"));
            }
            this.debugMessage = message;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedClassifier"));
            }
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedClassifier"));
            }
            throw new IllegalStateException();
        }

        @NotNull
        public Collection getContributedVariables(@NotNull Name name, @NotNull LookupLocation location2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedVariables"));
            }
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedVariables"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedFunctions"));
            }
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedFunctions"));
            }
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
            if (kindFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindFilter", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedDescriptors"));
            }
            if (nameFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "getContributedDescriptors"));
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return "ThrowingScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/types/ErrorUtils$ThrowingScope", "printScopeStructure"));
            }
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }

    public static class ErrorScope
    implements MemberScope {
        private final String debugMessage;

        private ErrorScope(@NotNull String debugMessage) {
            if (debugMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugMessage", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "<init>"));
            }
            this.debugMessage = debugMessage;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedClassifier"));
            }
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedClassifier"));
            }
            return ErrorUtils.createErrorClass(name.asString());
        }

        @NotNull
        public Set getContributedVariables(@NotNull Name name, @NotNull LookupLocation location2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedVariables"));
            }
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedVariables"));
            }
            Set set = ERROR_PROPERTY_GROUP;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedVariables"));
            }
            return set;
        }

        @NotNull
        public Set<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedFunctions"));
            }
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedFunctions"));
            }
            Set<FunctionDescriptor> set = Collections.singleton(ErrorUtils.createErrorFunction(this));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedFunctions"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
            if (kindFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindFilter", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedDescriptors"));
            }
            if (nameFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedDescriptors"));
            }
            List<DeclarationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "getContributedDescriptors"));
            }
            return list2;
        }

        public String toString() {
            return "ErrorScope{" + this.debugMessage + '}';
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/types/ErrorUtils$ErrorScope", "printScopeStructure"));
            }
            p.println(this.getClass().getSimpleName(), ": ", this.debugMessage);
        }
    }
}

