/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ResourceLoadingClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "serializedResourcePaths", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "loadResource", "Lkotlin/Function1;", "", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;Lkotlin/jvm/functions/Function1;)V", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlin-compiler"})
public final class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<String, InputStream> loadResource;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        PackageFragmentDescriptor packageFragmentDescriptor = CollectionsKt.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(packageFragmentDescriptor instanceof DeserializedPackageFragment)) {
            packageFragmentDescriptor = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)packageFragmentDescriptor;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        Map<ClassId, ProtoBuf.Class> map2 = packageFragment.getClassIdToProto();
        if (map2 == null || (map2 = map2.get(classId)) == null) {
            ResourceLoadingClassDataFinder $receiver$iv = this;
            ResourceLoadingClassDataFinder $receiver = $receiver$iv;
            InputStream inputStream = $receiver.loadResource.invoke($receiver.serializedResourcePaths.getClassMetadataPath(classId));
            if (inputStream == null) {
                return null;
            }
            InputStream stream2 = inputStream;
            map2 = ProtoBuf.Class.parseFrom(stream2, $receiver.serializedResourcePaths.getExtensionRegistry());
        }
        Map<ClassId, ProtoBuf.Class> classProto = map2;
        NameResolver nameResolver = packageFragment.getNameResolver();
        Map<ClassId, ProtoBuf.Class> map3 = classProto;
        Intrinsics.checkExpressionValueIsNotNull(map3, "classProto");
        return new ClassDataWithSource(new ClassData(nameResolver, (ProtoBuf.Class)((Object)map3)), null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull(serializedResourcePaths, "serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, "loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

