/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "value", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(JLorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "supertypes", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/types/KotlinType;", "checkBoundsAndAddSuperType", "", "minValue", "maxValue", "kotlinType", "getAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "getBuiltIns", "getDeclarationDescriptor", "", "getParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getSupertypes", "", "getValue", "isDenotable", "", "isFinal", "toString", "", "kotlin-compiler"})
public final class IntegerValueTypeConstructor
implements TypeConstructor {
    private final ArrayList<KotlinType> supertypes;
    private final long value;
    private final KotlinBuiltIns builtIns;

    private final void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, KotlinType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.Companion.getEMPTY();
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }

    public IntegerValueTypeConstructor(long value, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.value = value;
        this.builtIns = builtIns;
        this.supertypes = new ArrayList(4);
        long l = Integer.MIN_VALUE;
        long l2 = Integer.MAX_VALUE;
        KotlinType kotlinType = this.builtIns.getIntType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "builtIns.intType");
        this.checkBoundsAndAddSuperType(this.value, l, l2, kotlinType);
        long l3 = -128;
        long l4 = 127;
        KotlinType kotlinType2 = this.builtIns.getByteType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "builtIns.byteType");
        this.checkBoundsAndAddSuperType(this.value, l3, l4, kotlinType2);
        long l5 = Short.MIN_VALUE;
        long l6 = Short.MAX_VALUE;
        KotlinType kotlinType3 = this.builtIns.getShortType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "builtIns.shortType");
        this.checkBoundsAndAddSuperType(this.value, l5, l6, kotlinType3);
        this.supertypes.add(this.builtIns.getLongType());
    }
}

