/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.relocated.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.relocated.com.google.common.collect.Sets;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkRedeclarations", "", "c", "Lorg/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkRedeclarationsInPackages", "topLevelDescriptorProvider", "Lorg/jetbrains/kotlin/resolve/lazy/TopLevelDescriptorProvider;", "topLevelFqNames", "Lorg/jetbrains/kotlin/relocated/com/google/common/collect/Multimap;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getTopLevelDescriptorsByFqName", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "fqName", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "reportRedeclarations", "descriptorMap", "Lorg/jetbrains/kotlin/name/Name;", "resolveAnnotationsOnFiles", "scopeProvider", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "kotlin-compiler"})
public final class DeclarationResolver {
    private final AnnotationResolver annotationResolver;
    private final BindingTrace trace;

    /*
     * WARNING - void declaration
     */
    public final void resolveAnnotationsOnFiles(@NotNull TopDownAnalysisContext c, @NotNull FileScopeProvider scopeProvider) {
        void $receiver$iv;
        Map filesToScope2;
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(scopeProvider, "scopeProvider");
        Map map2 = filesToScope2 = CollectionsKt.keysToMap((Iterable)c.getFiles(), (Function1)new Function1<KtFile, LexicalScope>(scopeProvider){
            final /* synthetic */ FileScopeProvider $scopeProvider;

            @NotNull
            public final LexicalScope invoke(KtFile it) {
                KtFile ktFile = it;
                Intrinsics.checkExpressionValueIsNotNull(ktFile, "it");
                return this.$scopeProvider.getFileResolutionScope(ktFile);
            }
            {
                this.$scopeProvider = fileScopeProvider;
                super(1);
            }
        });
        Iterator iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry entry;
            Map.Entry $i$f$iterator = entry = iterator2.next();
            KtFile file = (KtFile)$receiver$iv3.getKey();
            Map.Entry $i$f$component1 = entry;
            LexicalScope fileScope = (LexicalScope)$receiver$iv2.getValue();
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file.getAnnotationEntries(), this.trace);
            this.annotationResolver.resolveAnnotationsWithArguments(fileScope, file.getDanglingAnnotations(), this.trace);
        }
    }

    public final void checkRedeclarations(@NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            HashMultimap descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : ResolutionScope.DefaultImpls.getContributedDescriptors$default(classDescriptor.getUnsubstitutedMemberScope(), null, null, 3, null)) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            Multimap multimap = descriptorMap;
            Intrinsics.checkExpressionValueIsNotNull(multimap, "descriptorMap");
            this.reportRedeclarations(multimap);
        }
    }

    private final void reportRedeclarations(Multimap<Name, DeclarationDescriptor> descriptorMap) {
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name pair : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(pair);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                if (!(descriptor2 instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor22 : descriptors) {
                    if (descriptor2 == descriptor22) continue;
                    PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement, descriptor2.getName()));
                    if (!(descriptor22 instanceof PropertyDescriptor)) continue;
                    PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor22);
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement2, descriptor22.getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            PsiElement first = (PsiElement)pair.component1();
            Name second = (Name)pair.component2();
            this.trace.report(Errors.REDECLARATION.on(first, second.asString()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkRedeclarationsInPackages(@NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull Multimap<FqName, KtElement> topLevelFqNames) {
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(topLevelFqNames, "topLevelFqNames");
        Map<FqName, Collection<KtElement>> $receiver$iv = topLevelFqNames.asMap();
        Iterator<Map.Entry<FqName, Collection<KtElement>>> iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry<FqName, Collection<KtElement>> entry;
            Map.Entry<FqName, Collection<KtElement>> $i$f$iterator = entry = iterator2.next();
            FqName fqName2 = (FqName)$receiver$iv3.getKey();
            Map.Entry<FqName, Collection<KtElement>> $i$f$component1 = entry;
            Collection declarationsOrPackageDirectives = (Collection)$receiver$iv2.getValue();
            if (fqName2.isRoot()) continue;
            FqName fqName3 = fqName2;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            Set<DeclarationDescriptor> descriptors = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName3, NoLookupLocation.WHEN_CHECK_REDECLARATIONS);
            if (descriptors.size() <= 1) continue;
            for (KtElement declarationOrPackageDirective : declarationsOrPackageDirectives) {
                PsiElement reportAt = declarationOrPackageDirective instanceof KtPackageDirective ? ((KtPackageDirective)declarationOrPackageDirective).getNameIdentifier() : (PsiElement)declarationOrPackageDirective;
                this.trace.report(Errors.REDECLARATION.on(reportAt, fqName2.shortName().asString()));
            }
        }
    }

    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(TopLevelDescriptorProvider topLevelDescriptorProvider, FqName fqName2, LookupLocation location2) {
        HashSet<ClassDescriptor> descriptors = new HashSet<ClassDescriptor>();
        CollectionsKt.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassDescriptors(fqName2, location2));
        return descriptors;
    }

    public DeclarationResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.annotationResolver = annotationResolver;
        this.trace = trace;
    }
}

