/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.relocated.org.jdom;

import java.util.HashMap;
import java.util.List;
import org.jetbrains.kotlin.relocated.org.jdom.Comment;
import org.jetbrains.kotlin.relocated.org.jdom.Content;
import org.jetbrains.kotlin.relocated.org.jdom.ContentList;
import org.jetbrains.kotlin.relocated.org.jdom.DocType;
import org.jetbrains.kotlin.relocated.org.jdom.Element;
import org.jetbrains.kotlin.relocated.org.jdom.IllegalAddException;
import org.jetbrains.kotlin.relocated.org.jdom.Parent;
import org.jetbrains.kotlin.relocated.org.jdom.ProcessingInstruction;

public class Document
implements Parent {
    ContentList content = new ContentList(this);
    protected String baseURI = null;
    private HashMap propertyMap = null;

    public Document() {
    }

    public Document(Element rootElement, DocType docType, String baseURI) {
        if (rootElement != null) {
            this.setRootElement(rootElement);
        }
        if (docType != null) {
            this.setDocType(docType);
        }
        if (baseURI != null) {
            this.setBaseURI(baseURI);
        }
    }

    public Document(Element rootElement) {
        this(rootElement, null, null);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int index2 = this.content.indexOfFirstElement();
        if (index2 < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(index2);
    }

    public Document setRootElement(Element rootElement) {
        int index2 = this.content.indexOfFirstElement();
        if (index2 < 0) {
            this.content.add(rootElement);
        } else {
            this.content.set(index2, rootElement);
        }
        return this;
    }

    public Element detachRootElement() {
        int index2 = this.content.indexOfFirstElement();
        if (index2 < 0) {
            return null;
        }
        return (Element)this.removeContent(index2);
    }

    public DocType getDocType() {
        int index2 = this.content.indexOfDocType();
        if (index2 < 0) {
            return null;
        }
        return (DocType)this.content.get(index2);
    }

    public Document setDocType(DocType docType) {
        if (docType == null) {
            int docTypeIndex = this.content.indexOfDocType();
            if (docTypeIndex >= 0) {
                this.content.remove(docTypeIndex);
            }
            return this;
        }
        if (docType.getParent() != null) {
            throw new IllegalAddException(docType, "The DocType already is attached to a document");
        }
        int docTypeIndex = this.content.indexOfDocType();
        if (docTypeIndex < 0) {
            this.content.addImpl(0, docType);
        } else {
            this.content.set(docTypeIndex, docType);
        }
        return this;
    }

    public Document addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public List<Content> getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    public final void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public boolean removeContent(Content child) {
        return this.content.remove(child);
    }

    public Content removeContent(int index2) {
        return this.content.remove(index2);
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringForm.append(docType.toString()).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        if (this.hasRootElement()) {
            stringForm.append("Root is ").append(this.getRootElement().toString());
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return stringForm.toString();
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Document clone() {
        Document doc = null;
        try {
            doc = (Document)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        doc.content = new ContentList(doc);
        for (int i = 0; i < this.content.size(); ++i) {
            Content obj = this.content.get(i);
            if (obj instanceof Element) {
                Element element = ((Element)obj).clone();
                doc.content.add(element);
                continue;
            }
            if (obj instanceof Comment) {
                Comment comment = (Comment)((Comment)obj).clone();
                doc.content.add(comment);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)((ProcessingInstruction)obj).clone();
                doc.content.add(pi);
                continue;
            }
            if (!(obj instanceof DocType)) continue;
            DocType dt = (DocType)((DocType)obj).clone();
            doc.content.add(dt);
        }
        return doc;
    }

    @Override
    public Parent getParent() {
        return null;
    }
}

