/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeProvider;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaWildcardTypeImpl;

public class JavaTypeProviderImpl
implements JavaTypeProvider {
    private final PsiManager manager;

    public JavaTypeProviderImpl(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeProviderImpl", "<init>"));
        }
        this.manager = manager;
    }

    @Override
    @NotNull
    public JavaType createJavaLangObjectType() {
        JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(PsiType.getJavaLangObject(this.manager, GlobalSearchScope.allScope(this.manager.getProject())));
        if (javaTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeProviderImpl", "createJavaLangObjectType"));
        }
        return javaTypeImpl;
    }

    @Override
    @NotNull
    public JavaWildcardType createUpperBoundWildcard(@NotNull JavaType bound) {
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeProviderImpl", "createUpperBoundWildcard"));
        }
        JavaWildcardTypeImpl javaWildcardTypeImpl = new JavaWildcardTypeImpl(PsiWildcardType.createExtends(this.manager, ((JavaTypeImpl)bound).getPsi()));
        if (javaWildcardTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeProviderImpl", "createUpperBoundWildcard"));
        }
        return javaWildcardTypeImpl;
    }

    @Override
    @NotNull
    public JavaWildcardType createLowerBoundWildcard(@NotNull JavaType bound) {
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeProviderImpl", "createLowerBoundWildcard"));
        }
        JavaWildcardTypeImpl javaWildcardTypeImpl = new JavaWildcardTypeImpl(PsiWildcardType.createSuper(this.manager, ((JavaTypeImpl)bound).getPsi()));
        if (javaWildcardTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeProviderImpl", "createLowerBoundWildcard"));
        }
        return javaWildcardTypeImpl;
    }

    @Override
    @NotNull
    public JavaWildcardType createUnboundedWildcard() {
        JavaWildcardTypeImpl javaWildcardTypeImpl = new JavaWildcardTypeImpl(PsiWildcardType.createUnbounded(this.manager));
        if (javaWildcardTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaTypeProviderImpl", "createUnboundedWildcard"));
        }
        return javaWildcardTypeImpl;
    }
}

