/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsCatch;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.relocated.com.google.dart.compiler.backend.js.ast.JsThrow;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/CatchTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "catches", "", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Ljava/util/List;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getCatches", "()Ljava/util/List;", "isThrowable", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "translate", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsCatch;", "translateCatchBody", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsBlock;", "catchClause", "translateCatches", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsStatement;", "parameterRef", "Lorg/jetbrains/kotlin/relocated/com/google/dart/compiler/backend/js/ast/JsNameRef;", "", "kotlin-compiler"})
public final class CatchTranslator
extends AbstractTranslator {
    @NotNull
    private final List<KtCatchClause> catches;

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        KtCatchClause firstCatch = CollectionsKt.first(this.catches);
        KtParameter catchParameter = firstCatch.getCatchParameter();
        TranslationContext translationContext = this.context();
        KtParameter ktParameter = catchParameter;
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        JsName parameterName = translationContext.getNameForElement(ktParameter);
        JsNameRef parameterRef = parameterName.makeRef();
        JsScope jsScope = this.context().scope();
        String string = parameterRef.getIdent();
        JsNameRef jsNameRef = parameterRef;
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "parameterRef");
        return new JsCatch(jsScope, string, this.translateCatches(jsNameRef, this.catches.iterator()));
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement translateCatches(JsNameRef parameterRef, Iterator<? extends KtCatchClause> catches) {
        void receiver$iv;
        if (!catches.hasNext()) {
            return new JsThrow(parameterRef);
        }
        KtCatchClause ktCatchClause = catches.next();
        KtParameter ktParameter = ktCatchClause.getCatchParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        KtParameter param = ktParameter;
        JsName paramName = this.context().getNameForElement(param);
        KtTypeReference ktTypeReference = param.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtTypeReference paramType = ktTypeReference;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        JsBlock thenBlock = this.translateCatchBody(translationContext, ktCatchClause);
        if (Intrinsics.areEqual(paramName.getIdent(), parameterRef.getIdent()) ^ true) {
            thenBlock.getStatements().add(0, JsAstUtils.newVar(paramName, parameterRef));
        }
        if (this.isThrowable(paramType)) {
            return thenBlock;
        }
        PatternTranslator patternTranslator = Translation.patternTranslator(this.context());
        PatternTranslator $receiver = (PatternTranslator)receiver$iv;
        JsExpression typeCheck = $receiver.translateIsCheck(parameterRef, paramType);
        JsStatement elseBlock = this.translateCatches(parameterRef, catches);
        return new JsIf(typeCheck, thenBlock, elseBlock);
    }

    private final JsBlock translateCatchBody(TranslationContext context, KtCatchClause catchClause) {
        KtExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context) : context.getEmptyExpression().makeStmt();
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "convertToBlock(jsCatchBody)");
        return jsBlock;
    }

    private final boolean isThrowable(KtTypeReference $receiver) {
        KotlinType jetType = (KotlinType)BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $receiver);
        String jetTypeName = DescriptorUtilsKt.getJetTypeFqName(jetType, false);
        return Intrinsics.areEqual(jetTypeName, KotlinBuiltIns.FQ_NAMES.throwable.asString());
    }

    @NotNull
    public final List<KtCatchClause> getCatches() {
        return this.catches;
    }

    public CatchTranslator(@NotNull List<? extends KtCatchClause> catches, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(catches, "catches");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.catches = catches;
    }
}

