/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;

public class ScriptContext
extends ClassContext {
    private final ScriptDescriptor scriptDescriptor;
    private final List<ScriptDescriptor> earlierScripts;
    private final KtExpression lastStatement;

    public ScriptContext(@NotNull JetTypeMapper typeMapper, @NotNull ScriptDescriptor scriptDescriptor, @NotNull List<ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor contextDescriptor, @Nullable CodegenContext parentContext) {
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        if (contextDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDescriptor", "org/jetbrains/kotlin/codegen/context/ScriptContext", "<init>"));
        }
        super(typeMapper, contextDescriptor, OwnerKind.IMPLEMENTATION, parentContext, null);
        this.scriptDescriptor = scriptDescriptor;
        this.earlierScripts = earlierScripts;
        KtScript script = (KtScript)DescriptorToSourceUtils.getSourceFromDescriptor(scriptDescriptor);
        assert (script != null) : "Declaration should be present for script: " + scriptDescriptor;
        KtDeclaration lastDeclaration = CollectionsKt.lastOrNull(script.getDeclarations());
        this.lastStatement = lastDeclaration instanceof KtAnonymousInitializer ? ((KtAnonymousInitializer)lastDeclaration).getBody() : null;
    }

    @NotNull
    public ScriptDescriptor getScriptDescriptor() {
        ScriptDescriptor scriptDescriptor = this.scriptDescriptor;
        if (scriptDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getScriptDescriptor"));
        }
        return scriptDescriptor;
    }

    @NotNull
    public FieldInfo getResultFieldInfo() {
        assert (this.getState().getReplSpecific().getShouldGenerateScriptResultValue()) : "Should not be called unless 'scriptResultFieldName' is set";
        GenerationState state2 = this.getState();
        String scriptResultFieldName = state2.getReplSpecific().getScriptResultFieldName();
        assert (scriptResultFieldName != null);
        FieldInfo fieldInfo = FieldInfo.createForHiddenField(state2.getTypeMapper().mapClass(this.scriptDescriptor), AsmTypes.OBJECT_TYPE, scriptResultFieldName);
        if (fieldInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getResultFieldInfo"));
        }
        return fieldInfo;
    }

    @NotNull
    public List<ScriptDescriptor> getEarlierScripts() {
        List<ScriptDescriptor> list2 = this.earlierScripts;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getEarlierScripts"));
        }
        return list2;
    }

    @NotNull
    public String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getScriptFieldName"));
        }
        int index2 = this.earlierScripts.indexOf(scriptDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        String string = "script$" + (index2 + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/context/ScriptContext", "getScriptFieldName"));
        }
        return string;
    }

    @Nullable
    public KtExpression getLastStatement() {
        return this.lastStatement;
    }

    @Override
    public String toString() {
        return "Script: " + ((ClassDescriptor)this.getContextDescriptor()).getName().asString();
    }
}

