/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuiltinMethodsWithSpecialGenericSignature {
    private static final Set<FqName> ERASED_COLLECTION_PARAMETER_FQ_NAMES;
    private static final Map<FqName, DefaultValue> GENERIC_PARAMETERS_METHODS_TO_DEFAULT_VALUES_MAP;
    private static final Set<FqName> ERASED_VALUE_PARAMETERS_FQ_NAMES;
    private static final Set<Name> ERASED_VALUE_PARAMETERS_SHORT_NAMES;
    public static final BuiltinMethodsWithSpecialGenericSignature INSTANCE;

    private final boolean getHasErasedValueParametersInJava(CallableMemberDescriptor $receiver) {
        return CollectionsKt.contains((Iterable)ERASED_VALUE_PARAMETERS_FQ_NAMES, DescriptorUtilsKt.fqNameOrNull($receiver));
    }

    @JvmStatic
    @Nullable
    public static final FunctionDescriptor getOverriddenBuiltinFunctionWithErasedValueParametersInJava(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        if (!INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(functionDescriptor.getName())) {
            return null;
        }
        return (FunctionDescriptor)DescriptorUtilsKt.firstOverridden(functionDescriptor, getOverriddenBuiltinFunctionWithErasedValueParametersInJava.1.INSTANCE);
    }

    @JvmStatic
    @Nullable
    public static final DefaultValue getDefaultValueForOverriddenBuiltinFunction(@NotNull FunctionDescriptor functionDescriptor) {
        DefaultValue defaultValue;
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        if (ERASED_VALUE_PARAMETERS_SHORT_NAMES.contains(functionDescriptor.getName()) ^ true) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtilsKt.firstOverridden(functionDescriptor, getDefaultValueForOverriddenBuiltinFunction.1.INSTANCE);
        if (callableMemberDescriptor != null) {
            CallableMemberDescriptor $receiver$iv = callableMemberDescriptor;
            CallableMemberDescriptor it = $receiver$iv;
            defaultValue = GENERIC_PARAMETERS_METHODS_TO_DEFAULT_VALUES_MAP.get(DescriptorUtilsKt.getFqNameSafe(it));
        } else {
            defaultValue = null;
        }
        return defaultValue;
    }

    public final boolean getSameAsBuiltinMethodWithErasedValueParameters(Name $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ERASED_VALUE_PARAMETERS_SHORT_NAMES.contains($receiver);
    }

    public final boolean isBuiltinWithSpecialDescriptorInJvm(CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (!SpecialBuiltinMembers.isFromBuiltins($receiver)) {
            return false;
        }
        SpecialSignatureInfo specialSignatureInfo = BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo($receiver);
        return (specialSignatureInfo != null ? specialSignatureInfo.isObjectReplacedWithTypeParameter() : false) || SpecialBuiltinMembers.doesOverrideBuiltinWithDifferentJvmName($receiver);
    }

    @JvmStatic
    @Nullable
    public static final SpecialSignatureInfo getSpecialSignatureInfo(CallableMemberDescriptor $receiver) {
        DefaultValue defaultValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Object object = DescriptorUtilsKt.firstOverridden($receiver, getSpecialSignatureInfo.builtinFqName.1.INSTANCE);
        if (object == null || (object = DescriptorUtilsKt.fqNameOrNull((CallableDescriptor)object)) == null) {
            return null;
        }
        Object builtinFqName2 = object;
        if (ERASED_COLLECTION_PARAMETER_FQ_NAMES.contains(builtinFqName2)) {
            return SpecialSignatureInfo.ONE_COLLECTION_PARAMETER;
        }
        DefaultValue defaultValue2 = GENERIC_PARAMETERS_METHODS_TO_DEFAULT_VALUES_MAP.get(builtinFqName2);
        if (defaultValue2 == null) {
            Intrinsics.throwNpe();
        }
        return Intrinsics.areEqual((Object)(defaultValue = defaultValue2), (Object)DefaultValue.NULL) ? SpecialSignatureInfo.OBJECT_PARAMETER_GENERIC : SpecialSignatureInfo.OBJECT_PARAMETER_NON_GENERIC;
    }

    /*
     * WARNING - void declaration
     */
    private BuiltinMethodsWithSpecialGenericSignature() {
        void var3_3;
        void $receiver$iv$iv;
        INSTANCE = this;
        ERASED_COLLECTION_PARAMETER_FQ_NAMES = SetsKt.setOf(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.collection, "containsAll"), SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.mutableCollection, "removeAll"), SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.mutableCollection, "retainAll"));
        GENERIC_PARAMETERS_METHODS_TO_DEFAULT_VALUES_MAP = MapsKt.mapOf(TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.collection, "contains"), DefaultValue.FALSE), TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.mutableCollection, "remove"), DefaultValue.FALSE), TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.map, "containsKey"), DefaultValue.FALSE), TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.map, "containsValue"), DefaultValue.FALSE), TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.map, "get"), DefaultValue.NULL), TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.mutableMap, "remove"), DefaultValue.NULL), TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.list, "indexOf"), DefaultValue.INDEX), TuplesKt.to(SpecialBuiltinMembers.access$child(KotlinBuiltIns.FQ_NAMES.list, "lastIndexOf"), DefaultValue.INDEX));
        ERASED_VALUE_PARAMETERS_FQ_NAMES = SetsKt.plus(GENERIC_PARAMETERS_METHODS_TO_DEFAULT_VALUES_MAP.keySet(), (Iterable)ERASED_COLLECTION_PARAMETER_FQ_NAMES);
        Iterable $receiver$iv = ERASED_VALUE_PARAMETERS_FQ_NAMES;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            Name name = it.shortName();
            collection.add(name);
        }
        ERASED_VALUE_PARAMETERS_SHORT_NAMES = CollectionsKt.toSet((List)var3_3);
    }

    static {
        new BuiltinMethodsWithSpecialGenericSignature();
    }

    public static final /* synthetic */ boolean access$getHasErasedValueParametersInJava$p(BuiltinMethodsWithSpecialGenericSignature $this, CallableMemberDescriptor $receiver) {
        return $this.getHasErasedValueParametersInJava($receiver);
    }

    @NotNull
    public static final /* synthetic */ Map access$getGENERIC_PARAMETERS_METHODS_TO_DEFAULT_VALUES_MAP$p(BuiltinMethodsWithSpecialGenericSignature $this) {
        BuiltinMethodsWithSpecialGenericSignature builtinMethodsWithSpecialGenericSignature = $this;
        return GENERIC_PARAMETERS_METHODS_TO_DEFAULT_VALUES_MAP;
    }

    public static final class DefaultValue
    extends Enum<DefaultValue> {
        public static final /* enum */ DefaultValue NULL;
        public static final /* enum */ DefaultValue INDEX;
        public static final /* enum */ DefaultValue FALSE;
        private static final /* synthetic */ DefaultValue[] $VALUES;
        @Nullable
        private final Object value;

        static {
            DefaultValue[] defaultValueArray = new DefaultValue[3];
            DefaultValue[] defaultValueArray2 = defaultValueArray;
            defaultValueArray[0] = NULL = new DefaultValue(null);
            defaultValueArray[1] = INDEX = new DefaultValue(-1);
            defaultValueArray[2] = FALSE = new DefaultValue(false);
            $VALUES = defaultValueArray;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        protected DefaultValue(Object value) {
            this.value = value;
        }

        public static DefaultValue[] values() {
            return (DefaultValue[])$VALUES.clone();
        }

        public static DefaultValue valueOf(String string) {
            return Enum.valueOf(DefaultValue.class, string);
        }
    }

    public static final class SpecialSignatureInfo
    extends Enum<SpecialSignatureInfo> {
        public static final /* enum */ SpecialSignatureInfo ONE_COLLECTION_PARAMETER;
        public static final /* enum */ SpecialSignatureInfo OBJECT_PARAMETER_NON_GENERIC;
        public static final /* enum */ SpecialSignatureInfo OBJECT_PARAMETER_GENERIC;
        private static final /* synthetic */ SpecialSignatureInfo[] $VALUES;
        @Nullable
        private final String valueParametersSignature;
        private final boolean isObjectReplacedWithTypeParameter;

        static {
            SpecialSignatureInfo[] specialSignatureInfoArray = new SpecialSignatureInfo[3];
            SpecialSignatureInfo[] specialSignatureInfoArray2 = specialSignatureInfoArray;
            specialSignatureInfoArray[0] = ONE_COLLECTION_PARAMETER = new SpecialSignatureInfo("Ljava/util/Collection<+Ljava/lang/Object;>;", false);
            specialSignatureInfoArray[1] = OBJECT_PARAMETER_NON_GENERIC = new SpecialSignatureInfo(null, true);
            specialSignatureInfoArray[2] = OBJECT_PARAMETER_GENERIC = new SpecialSignatureInfo("Ljava/lang/Object;", true);
            $VALUES = specialSignatureInfoArray;
        }

        @Nullable
        public final String getValueParametersSignature() {
            return this.valueParametersSignature;
        }

        public final boolean isObjectReplacedWithTypeParameter() {
            return this.isObjectReplacedWithTypeParameter;
        }

        protected SpecialSignatureInfo(String valueParametersSignature, boolean isObjectReplacedWithTypeParameter) {
            this.valueParametersSignature = valueParametersSignature;
            this.isObjectReplacedWithTypeParameter = isObjectReplacedWithTypeParameter;
        }

        public static SpecialSignatureInfo[] values() {
            return (SpecialSignatureInfo[])$VALUES.clone();
        }

        public static SpecialSignatureInfo valueOf(String string) {
            return Enum.valueOf(SpecialSignatureInfo.class, string);
        }
    }
}

