/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(@NotNull Project project, @NotNull FileIndexFacade fileIndex) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/ProjectScopeImpl", "<init>"));
        }
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/intellij/psi/search/ProjectScopeImpl", "<init>"));
        }
        super(project);
        this.myFileIndex = fileIndex;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/ProjectScopeImpl", "contains"));
        }
        if (file instanceof VirtualFileWindow) {
            return true;
        }
        if (this.myFileIndex.isInLibraryClasses(file) && !this.myFileIndex.isInSourceContent(file)) {
            return false;
        }
        return this.myFileIndex.isInContent(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/ProjectScopeImpl", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/ProjectScopeImpl", "compare"));
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/ProjectScopeImpl", "isSearchInModuleContent"));
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = PsiBundle.message("psi.search.scope.project", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "getDisplayName"));
        }
        return string;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
        }
        if (scope2 == this || !scope2.isSearchInLibraries() || !scope2.isSearchOutsideRootModel()) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
            }
            return projectScopeImpl;
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope2);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
        }
        if (scope2 == this) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
            }
            return projectScopeImpl;
        }
        if (!scope2.isSearchInLibraries()) {
            GlobalSearchScope globalSearchScope = scope2;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope2);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
        }
        return globalSearchScope;
    }
}

