/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.EventDispatcher;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    private final EventDispatcher<VirtualFileListener> myEventDispatcher = EventDispatcher.create(VirtualFileListener.class);

    protected void startEventPropagation() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        application.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myEventDispatcher.getMulticaster(), this));
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "addVirtualFileListener"));
        }
        this.myEventDispatcher.addListener(listener);
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "deleteFile"));
        }
        throw new UnsupportedOperationException("deleteFile() not supported");
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "renameFile"));
        }
        throw new UnsupportedOperationException("renameFile() not supported");
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildFile"));
        }
        throw new UnsupportedOperationException("createChildFile() not supported");
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildDirectory"));
        }
        throw new UnsupportedOperationException("createChildDirectory() not supported");
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        throw new UnsupportedOperationException("copyFile() not supported");
    }
}

