/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CoroutineLanguageVersionSettingsUtilKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a,\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u001b\u001a\u00020\u0018*\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\u001d\u001a\u00020\u0018*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006 "}, d2={"COROUTINE_CONTEXT_1_2_20_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getCOROUTINE_CONTEXT_1_2_20_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "COROUTINE_CONTEXT_1_2_30_FQ_NAME", "getCOROUTINE_CONTEXT_1_2_30_FQ_NAME", "COROUTINE_CONTEXT_1_3_FQ_NAME", "getCOROUTINE_CONTEXT_1_3_FQ_NAME", "checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkRestrictsSuspension", "enclosingSuspendCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isBuiltInCoroutineContext", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isRestrictsSuspensionReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "isScopeForDefaultParameterValuesOf", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "frontend"})
public final class CoroutineCallCheckerKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_2_20_FQ_NAME;
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_2_30_FQ_NAME;
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_3_FQ_NAME;

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_2_20_FQ_NAME() {
        return COROUTINE_CONTEXT_1_2_20_FQ_NAME;
    }

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_2_30_FQ_NAME() {
        return COROUTINE_CONTEXT_1_2_30_FQ_NAME;
    }

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_3_FQ_NAME() {
        return COROUTINE_CONTEXT_1_3_FQ_NAME;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FunctionDescriptor $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        FunctionDescriptor functionDescriptor = $receiver;
        if (!(functionDescriptor instanceof PropertyGetterDescriptor)) {
            functionDescriptor = null;
        }
        return (object = (PropertyGetterDescriptor)functionDescriptor) != null && (object = object.getCorrespondingProperty()) != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null && CoroutineLanguageVersionSettingsUtilKt.isBuiltInCoroutineContext((FqName)object, languageVersionSettings);
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull PropertyDescriptor $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        return CoroutineLanguageVersionSettingsUtilKt.isBuiltInCoroutineContext(DescriptorUtilsKt.getFqNameSafe($receiver), languageVersionSettings);
    }

    private static final boolean isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return $receiver instanceof LexicalScope && ((LexicalScope)$receiver).getKind() == LexicalScopeKind.DEFAULT_VALUE && Intrinsics.areEqual((Object)((LexicalScope)$receiver).getOwnerDescriptor(), (Object)enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        if (languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines)) {
            if (languageVersionSettings.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) < 0) {
                diagnosticHolder.report(Errors.UNSUPPORTED.on(reportOn, "cannot use release coroutines with api version less than 1.3"));
            }
            return;
        }
        Pair diagnosticData = TuplesKt.to((Object)((Object)LanguageFeature.Coroutines), (Object)languageVersionSettings);
        switch (CoroutineCallCheckerKt$WhenMappings.$EnumSwitchMapping$0[languageVersionSettings.getFeatureSupport(LanguageFeature.Coroutines).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 3: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
                break;
            }
            case 4: {
                diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)diagnosticData));
            }
        }
    }

    public static final boolean isRestrictsSuspensionReceiver(@NotNull KotlinType $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
            Iterable $receiver$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$receiver), (Iterable)TypeUtilsKt.supertypes($receiver));
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    Object object = it.getConstructor().getDeclarationDescriptor();
                    if (!(object != null && (object = object.getAnnotations()) != null && object.hasAnnotation(CoroutineLanguageVersionSettingsUtilKt.restrictsSuspensionFqName(languageVersionSettings)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        Function1<ReceiverValue, Boolean> isRestrictsSuspensionReceiver$ = new Function1<ReceiverValue, Boolean>(context){
            final /* synthetic */ CallCheckerContext $context;

            public final boolean invoke(@NotNull ReceiverValue $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                KotlinType kotlinType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
                return CoroutineCallCheckerKt.isRestrictsSuspensionReceiver(kotlinType, this.$context.getLanguageVersionSettings());
            }
            {
                this.$context = callCheckerContext;
                super(1);
            }
        };
        Function2<ReceiverValue, ReceiverValue, Boolean> sameInstance$ = new Function2<ReceiverValue, ReceiverValue, Boolean>(context){
            final /* synthetic */ CallCheckerContext $context;

            public final boolean invoke(@NotNull ReceiverValue $receiver, @Nullable ReceiverValue other) {
                ReceiverValue receiverValue;
                DeclarationDescriptor referenceTarget;
                DeclarationDescriptor declarationDescriptor;
                KtReferenceExpression referenceExpression;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                if (other == null) {
                    return false;
                }
                if ($receiver.getOriginal() == other.getOriginal()) {
                    return true;
                }
                ReceiverValue receiverValue2 = other;
                if (!(receiverValue2 instanceof ExpressionReceiver)) {
                    receiverValue2 = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue2;
                KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (!(ktExpression instanceof KtThisExpression)) {
                    ktExpression = null;
                }
                KtThisExpression ktThisExpression = (KtThisExpression)ktExpression;
                KtReferenceExpression ktReferenceExpression = referenceExpression = ktThisExpression != null ? ktThisExpression.getInstanceReference() : null;
                if (ktReferenceExpression != null) {
                    KtReferenceExpression ktReferenceExpression2;
                    KtReferenceExpression it = ktReferenceExpression2 = ktReferenceExpression;
                    declarationDescriptor = (DeclarationDescriptor)this.$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression);
                } else {
                    declarationDescriptor = null;
                }
                DeclarationDescriptor declarationDescriptor2 = referenceTarget = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableDescriptor) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter();
                    receiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
                } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter();
                    Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"referenceTarget.thisAsReceiverParameter");
                    receiverValue = receiverParameterDescriptor.getValue();
                } else {
                    receiverValue = null;
                }
                ReceiverValue referenceReceiverValue = receiverValue;
                return $receiver == referenceReceiverValue;
            }
            {
                this.$context = callCheckerContext;
                super(2);
            }
        };
        Function0<Unit> reportError$ = new Function0<Unit>(context, reportOn){
            final /* synthetic */ CallCheckerContext $context;
            final /* synthetic */ PsiElement $reportOn;

            public final void invoke() {
                this.$context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on(this.$reportOn));
            }
            {
                this.$context = callCheckerContext;
                this.$reportOn = psiElement;
                super(0);
            }
        };
        ReceiverParameterDescriptor receiverParameterDescriptor = enclosingSuspendCallableDescriptor.getExtensionReceiverParameter();
        ReceiverValue enclosingSuspendExtensionReceiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = enclosingSuspendCallableDescriptor.getDispatchReceiverParameter();
        ReceiverValue enclosingSuspendDispatchReceiverValue = receiverParameterDescriptor2 != null ? receiverParameterDescriptor2.getValue() : null;
        List receivers = CollectionsKt.listOfNotNull((Object[])new ReceiverValue[]{resolvedCall2.getDispatchReceiver(), resolvedCall2.getExtensionReceiver()});
        Iterator iterator2 = receivers.iterator();
        while (iterator2.hasNext()) {
            ReceiverValue receiverValue;
            ReceiverValue receiverValue2 = receiverValue = (ReceiverValue)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue2, (String)"receiverValue");
            if (!isRestrictsSuspensionReceiver$.invoke(receiverValue2)) continue;
            ReceiverValue receiverValue3 = enclosingSuspendExtensionReceiverValue;
            if (receiverValue3 != null && sameInstance$.invoke(receiverValue3, receiverValue)) continue;
            ReceiverValue receiverValue4 = enclosingSuspendDispatchReceiverValue;
            if (receiverValue4 != null && sameInstance$.invoke(receiverValue4, receiverValue)) continue;
            reportError$.invoke();
            return;
        }
        ReceiverValue receiverValue = enclosingSuspendExtensionReceiverValue;
        if (receiverValue == null || !isRestrictsSuspensionReceiver$.invoke(receiverValue)) {
            return;
        }
        if (sameInstance$.invoke(enclosingSuspendExtensionReceiverValue, resolvedCall2.getDispatchReceiver())) {
            return;
        }
        if (sameInstance$.invoke(enclosingSuspendExtensionReceiverValue, resolvedCall2.getExtensionReceiver())) {
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.candidateDescriptor");
            ReceiverParameterDescriptor receiverParameterDescriptor3 = obj.getExtensionReceiverParameter();
            if (receiverParameterDescriptor3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor3, (String)"resolvedCall.candidateDe\u2026ensionReceiverParameter!!");
            ReceiverValue receiverValue5 = receiverParameterDescriptor3.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue5, (String)"resolvedCall.candidateDe\u2026ReceiverParameter!!.value");
            if (isRestrictsSuspensionReceiver$.invoke(receiverValue5)) {
                return;
            }
        }
        reportError$.invoke();
    }

    static {
        FqName fqName2 = DescriptorUtils.COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("coroutineContext"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"DescriptorUtils.COROUTIN\u2026fier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_1_2_20_FQ_NAME = fqName2;
        FqName fqName3 = DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("coroutineContext"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"DescriptorUtils.COROUTIN\u2026fier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_1_2_30_FQ_NAME = fqName3;
        FqName fqName4 = DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("coroutineContext"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"DescriptorUtils.COROUTIN\u2026fier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_1_3_FQ_NAME = fqName4;
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, @NotNull FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(@NotNull CallableDescriptor enclosingSuspendCallableDescriptor, @NotNull ResolvedCall resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingSuspendCallableDescriptor, resolvedCall2, reportOn, context);
    }
}

