/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JavaGenericVarianceViolationTypeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.java"})
public final class JavaGenericVarianceViolationTypeChecker
implements AdditionalTypeChecker {
    public static final JavaGenericVarianceViolationTypeChecker INSTANCE;

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.expectedType");
        KotlinType expectedType = kotlinType;
        if (TypeUtils.noExpectedType(expectedType) || ErrorUtils.containsErrorType(expectedType) || ErrorUtils.containsUninferredParameter(expectedType)) {
            return;
        }
        if (expectedType.getArguments().isEmpty() || !FlexibleTypesKt.isFlexible(expectedType)) {
            return;
        }
        SimpleType lowerBound = FlexibleTypesKt.asFlexibleType(expectedType).getLowerBound();
        SimpleType upperBound = FlexibleTypesKt.asFlexibleType(expectedType).getUpperBound();
        if (Intrinsics.areEqual((Object)lowerBound.getConstructor(), (Object)upperBound.getConstructor())) {
            return;
        }
        if (expectedType.unwrap() instanceof RawTypeImpl) {
            return;
        }
        KotlinType kotlinType2 = TypeCheckingProcedure.findCorrespondingSupertype(expressionTypeWithSmartCast, lowerBound);
        if (kotlinType2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"TypeCheckingProcedure.fi\u2026st, lowerBound) ?: return");
        KotlinType correspondingSubType = kotlinType2;
        boolean bl2 = bl = lowerBound.getArguments().size() == upperBound.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Different arguments count in flexible bounds: " + '(' + lowerBound + '(' + lowerBound.getArguments().size() + ").." + upperBound + '(' + upperBound.getArguments().size() + ')';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = lowerBound.getArguments().size() == correspondingSubType.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Different arguments count in corresponding subtype and supertype: " + '(' + lowerBound + '(' + lowerBound.getArguments().size() + ").." + correspondingSubType + '(' + correspondingSubType.getArguments().size() + ')';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<TypeParameterDescriptor> list2 = lowerBound.getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lowerBound.constructor.parameters");
        List<TypeParameterDescriptor> lowerParameters = list2;
        List<TypeParameterDescriptor> list3 = upperBound.getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"upperBound.constructor.parameters");
        List<TypeParameterDescriptor> upperParameters = list3;
        List<TypeProjection> lowerArguments = lowerBound.getArguments();
        Iterable $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)correspondingSubType.getArguments());
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int index2 = element$iv = ((IntIterator)iterator2).nextInt();
            TypeProjection lowerArgument = lowerArguments.get(index2);
            TypeParameterDescriptor typeParameterDescriptor = lowerParameters.get(index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"lowerParameters[index]");
            if (typeParameterDescriptor.getVariance() != Variance.INVARIANT) continue;
            TypeParameterDescriptor typeParameterDescriptor2 = upperParameters.get(index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor2, (String)"upperParameters[index]");
            if (typeParameterDescriptor2.getVariance() != Variance.OUT_VARIANCE || lowerArgument.getProjectionKind() == Variance.OUT_VARIANCE || KotlinTypeChecker.DEFAULT.equalTypes(correspondingSubType.getArguments().get(index2).getType(), lowerArgument.getType())) continue;
            c.trace.report(ErrorsJvm.JAVA_TYPE_MISMATCH.on((KtExpression)((PsiElement)expression2), expressionTypeWithSmartCast, expectedType));
        }
    }

    private JavaGenericVarianceViolationTypeChecker() {
    }

    static {
        JavaGenericVarianceViolationTypeChecker javaGenericVarianceViolationTypeChecker;
        INSTANCE = javaGenericVarianceViolationTypeChecker = new JavaGenericVarianceViolationTypeChecker();
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkParameterIsNotNull((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        AdditionalTypeChecker.DefaultImpls.checkReceiver(this, receiverParameter, receiverArgument, safeAccess, c);
    }
}

