/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=2, xi=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0004\u001a$\u0010\u0007\u001a\u00020\u0001*\u00020\u00042\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bH\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\r\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0004*\u00020\u0004\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\n\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u0004\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u00020\u0004\u00a8\u0006\u0013"}, d2={"isInlineClass", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isInlineClassType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isNullableUnderlyingType", "isRecursiveInlineClassType", "isRecursiveInlineClassTypeInner", "visited", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lkotlin/collections/HashSet;", "isUnderlyingPropertyOfInlineClass", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "substitutedUnderlyingType", "underlyingRepresentation", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "unsubstitutedUnderlyingParameter", "unsubstitutedUnderlyingType", "descriptors"})
public final class InlineClassesUtilsKt {
    @Nullable
    public static final ValueParameterDescriptor underlyingRepresentation(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.isInline()) {
            return null;
        }
        Object object = $receiver.getUnsubstitutedPrimaryConstructor();
        return object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)object) : null;
    }

    public static final boolean isInlineClass(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ClassDescriptor && ((ClassDescriptor)$receiver).isInline();
    }

    @Nullable
    public static final ValueParameterDescriptor unsubstitutedUnderlyingParameter(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor $receiver$iv = $receiver.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = $receiver$iv;
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        return classDescriptor2 != null ? InlineClassesUtilsKt.underlyingRepresentation(classDescriptor2) : null;
    }

    @Nullable
    public static final KotlinType unsubstitutedUnderlyingType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.unsubstitutedUnderlyingParameter($receiver);
        return valueParameterDescriptor != null ? valueParameterDescriptor.getType() : null;
    }

    public static final boolean isInlineClassType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? InlineClassesUtilsKt.isInlineClass(classifierDescriptor) : false;
    }

    @Nullable
    public static final KotlinType substitutedUnderlyingType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.unsubstitutedUnderlyingParameter($receiver);
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        MemberScope memberScope2 = $receiver.getMemberScope();
        Name name = parameter.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"parameter.name");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)CollectionsKt.singleOrNull((Iterable)memberScope2.getContributedVariables(name, NoLookupLocation.FOR_ALREADY_TRACKED));
        return propertyDescriptor != null ? propertyDescriptor.getType() : null;
    }

    public static final boolean isRecursiveInlineClassType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KotlinType kotlinType = $receiver;
        HashSet<ClassDescriptor> hashSet = new HashSet<ClassDescriptor>();
        return InlineClassesUtilsKt.isRecursiveInlineClassTypeInner(kotlinType, hashSet);
    }

    private static final boolean isRecursiveInlineClassTypeInner(@NotNull KotlinType $receiver, HashSet<ClassDescriptor> visited2) {
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        if (visited2.contains(descriptor2)) {
            return true;
        }
        if (!InlineClassesUtilsKt.isInlineClass(descriptor2)) {
            return false;
        }
        visited2.add(descriptor2);
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType($receiver);
        return kotlinType != null ? InlineClassesUtilsKt.isRecursiveInlineClassTypeInner(kotlinType, visited2) : false;
    }

    public static final boolean isNullableUnderlyingType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!InlineClassesUtilsKt.isInlineClassType($receiver)) {
            return false;
        }
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType($receiver);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return TypeUtils.isNullableType(underlyingType);
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(@NotNull PropertyDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"this.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!InlineClassesUtilsKt.isInlineClass(containingDeclaration)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = containingDeclaration;
        if (declarationDescriptor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ValueParameterDescriptor valueParameterDescriptor = InlineClassesUtilsKt.underlyingRepresentation((ClassDescriptor)declarationDescriptor2);
        return Intrinsics.areEqual((Object)(valueParameterDescriptor != null ? valueParameterDescriptor.getName() : null), (Object)$receiver.getName());
    }
}

