/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.Psi2IrConfiguration;
import org.jetbrains.kotlin.psi2ir.generators.AnnotationGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.ModuleGenerator;
import org.jetbrains.kotlin.psi2ir.transformations.InsertImplicitCastsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010 \u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/psi2ir/Psi2IrTranslator;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "configuration", "Lorg/jetbrains/kotlin/psi2ir/Psi2IrConfiguration;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/psi2ir/Psi2IrConfiguration;)V", "getConfiguration", "()Lorg/jetbrains/kotlin/psi2ir/Psi2IrConfiguration;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "postprocessingSteps", "Lorg/jetbrains/kotlin/utils/SmartList;", "Lorg/jetbrains/kotlin/psi2ir/Psi2IrTranslator$PostprocessingStep;", "add", "", "step", "createGeneratorContext", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "generateAnnotationsForDeclarations", "context", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "generateModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "generateModuleFragment", "postprocess", "PostprocessingStep", "ir.psi2ir"})
public final class Psi2IrTranslator {
    private final SmartList<PostprocessingStep> postprocessingSteps;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Psi2IrConfiguration configuration;

    public final void add(@NotNull PostprocessingStep step) {
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
        this.postprocessingSteps.add(step);
    }

    @NotNull
    public final IrModuleFragment generateModule(@NotNull ModuleDescriptor moduleDescriptor, @NotNull Collection<? extends KtFile> ktFiles, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(ktFiles, (String)"ktFiles");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        GeneratorContext context = this.createGeneratorContext(moduleDescriptor, bindingContext);
        return this.generateModuleFragment(context, ktFiles);
    }

    @NotNull
    public final GeneratorContext createGeneratorContext(@NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        return new GeneratorContext(this.configuration, moduleDescriptor, bindingContext, this.languageVersionSettings, null, 16, null);
    }

    @NotNull
    public final IrModuleFragment generateModuleFragment(@NotNull GeneratorContext context, @NotNull Collection<? extends KtFile> ktFiles) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(ktFiles, (String)"ktFiles");
        ModuleGenerator moduleGenerator = new ModuleGenerator(context);
        IrModuleFragment irModule = moduleGenerator.generateModuleFragmentWithoutDependencies(ktFiles);
        this.postprocess(context, irModule);
        moduleGenerator.generateUnboundSymbolsAsDependencies(irModule);
        return irModule;
    }

    private final void postprocess(GeneratorContext context, IrElement irElement) {
        InsertImplicitCastsKt.insertImplicitCasts(irElement, context);
        this.generateAnnotationsForDeclarations(context, irElement);
        Iterable $receiver$iv = this.postprocessingSteps;
        for (Object element$iv : $receiver$iv) {
            PostprocessingStep it = (PostprocessingStep)element$iv;
            it.postprocess(context, irElement);
        }
        PatchDeclarationParentsKt.patchDeclarationParents$default(irElement, null, 1, null);
    }

    private final void generateAnnotationsForDeclarations(GeneratorContext context, IrElement irElement) {
        AnnotationGenerator annotationGenerator = new AnnotationGenerator(context);
        IrElementVisitorVoidKt.acceptVoid(irElement, annotationGenerator);
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final Psi2IrConfiguration getConfiguration() {
        return this.configuration;
    }

    public Psi2IrTranslator(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Psi2IrConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.languageVersionSettings = languageVersionSettings;
        this.configuration = configuration;
        this.postprocessingSteps = new SmartList();
    }

    public /* synthetic */ Psi2IrTranslator(LanguageVersionSettings languageVersionSettings, Psi2IrConfiguration psi2IrConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            psi2IrConfiguration = new Psi2IrConfiguration(false, 1, null);
        }
        this(languageVersionSettings, psi2IrConfiguration);
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/psi2ir/Psi2IrTranslator$PostprocessingStep;", "", "postprocess", "", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.psi2ir"})
    public static interface PostprocessingStep {
        public void postprocess(@NotNull GeneratorContext var1, @NotNull IrElement var2);
    }
}

