/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;

public class KtParameterElementType
extends KtStubElementType<KotlinParameterStub, KtParameter> {
    public KtParameterElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtParameter.class, KotlinParameterStub.class);
    }

    @Override
    public KotlinParameterStub createStub(@NotNull KtParameter psi, StubElement parentStub) {
        FqName fqName2 = psi.getFqName();
        StringRef fqNameRef = StringRef.fromString(fqName2 != null ? fqName2.asString() : null);
        return new KotlinParameterStubImpl(parentStub, fqNameRef, StringRef.fromString(psi.getName()), psi.isMutable(), psi.hasValOrVar(), psi.hasDefaultValue());
    }

    @Override
    public void serialize(@NotNull KotlinParameterStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub2.getName());
        dataStream.writeBoolean(stub2.isMutable());
        dataStream.writeBoolean(stub2.hasValOrVar());
        dataStream.writeBoolean(stub2.hasDefaultValue());
        FqName name = stub2.getFqName();
        dataStream.writeName(name != null ? name.asString() : null);
    }

    @Override
    @NotNull
    public KotlinParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        boolean isMutable = dataStream.readBoolean();
        boolean hasValOrValNode = dataStream.readBoolean();
        boolean hasDefaultValue2 = dataStream.readBoolean();
        StringRef fqName2 = dataStream.readName();
        return new KotlinParameterStubImpl(parentStub, fqName2, name, isMutable, hasValOrValNode, hasDefaultValue2);
    }

    @Override
    public void indexStub(@NotNull KotlinParameterStub stub2, @NotNull IndexSink sink) {
        StubIndexService.getInstance().indexParameter(stub2, sink);
    }
}

