/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.TemporaryAssignmentElimination;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0006J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "hasChanges", "", "namesToProcess", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "referenceCount", "", "", "statementsToRemove", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "syntheticNames", "usageSequences", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "usages", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "analyze", "", "apply", "calculateDeclarations", "generateDeclarations", "getUsageSequence", "name", "process", "tryRecord", "expr", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "usage", "use", "Usage", "UsageSequence", "js.translator"})
public final class TemporaryAssignmentElimination {
    private final Map<JsName, Integer> referenceCount;
    private final Map<JsName, Usage> usages;
    private final Set<JsStatement> statementsToRemove;
    private final Map<JsName, UsageSequence> usageSequences;
    private final Set<JsName> syntheticNames;
    private boolean hasChanges;
    private final Set<JsName> namesToProcess;
    private final JsBlock root;

    public final boolean apply() {
        this.analyze();
        this.calculateDeclarations();
        this.process();
        this.generateDeclarations();
        return this.hasChanges;
    }

    private final void analyze() {
        this.namesToProcess.addAll((Collection<JsName>)CollectUtilsKt.collectDefinedNames(this.root));
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression returnExpr = x.getExpression();
                if (returnExpr != null) {
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, returnExpr, new Usage.Return(x));
                }
                super.visitReturn(x);
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Pair<JsName, JsExpression> variableAssignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (variableAssignment != null) {
                    void name;
                    Pair<JsName, JsExpression> pair = variableAssignment;
                    JsName jsName = (JsName)pair.component1();
                    JsExpression value = (JsExpression)pair.component2();
                    JsStatement jsStatement = x;
                    void v1 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"name");
                    Usage.VariableAssignment usage = new Usage.VariableAssignment(jsStatement, (JsName)v1);
                    if (MetadataProperties.getSynthetic(x)) {
                        Collection collection = TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0);
                        collection.add(name);
                    }
                    JsExpression jsExpression = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"value");
                    TemporaryAssignmentElimination.access$tryRecord(this.this$0, jsExpression, usage);
                    this.accept((JsNode)value);
                    return;
                }
                Pair<JsExpression, JsExpression> propertyMutation = JsAstUtils.decomposeAssignment(x.getExpression());
                if (propertyMutation != null) {
                    void target;
                    Pair<JsExpression, JsExpression> pair = propertyMutation;
                    JsExpression value = (JsExpression)pair.component1();
                    JsExpression value2 = (JsExpression)pair.component2();
                    void v3 = target;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"target");
                    if (!SideEffectUtilsKt.canHaveSideEffect((JsExpression)v3, TemporaryAssignmentElimination.access$getNamesToProcess$p(this.this$0))) {
                        Usage.PropertyMutation usage = new Usage.PropertyMutation((JsStatement)x, (JsExpression)target);
                        JsExpression jsExpression = value2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"value");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, jsExpression, usage);
                        this.accept((JsNode)value2);
                        return;
                    }
                }
                super.visitExpressionStatement(x);
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                if (x.getVars().size() == 1) {
                    JsVars.JsVar declaration;
                    JsVars.JsVar jsVar = declaration = x.getVars().get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"declaration");
                    JsExpression initExpression = jsVar.getInitExpression();
                    if (initExpression != null) {
                        JsStatement jsStatement = x;
                        JsName jsName = declaration.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"declaration.name");
                        TemporaryAssignmentElimination.access$tryRecord(this.this$0, initExpression, new Usage.VariableDeclaration(jsStatement, jsName));
                    }
                    if (MetadataProperties.getSynthetic(x)) {
                        Collection collection = TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0);
                        JsName jsName = declaration.getName();
                        collection.add(jsName);
                    }
                }
                List<JsVars.JsVar> list2 = x.getVars();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.vars");
                Iterable $receiver$iv = list2;
                for (T element$iv : $receiver$iv) {
                    SourceInfoAwareJsNode sourceInfoAwareJsNode;
                    JsVars.JsVar v2 = (JsVars.JsVar)element$iv;
                    SourceInfoAwareJsNode sourceInfoAwareJsNode2 = v2;
                    if (sourceInfoAwareJsNode2 == null || (sourceInfoAwareJsNode2 = sourceInfoAwareJsNode2.getInitExpression()) == null) continue;
                    SourceInfoAwareJsNode it = sourceInfoAwareJsNode = sourceInfoAwareJsNode2;
                    this.accept((JsNode)it);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    TemporaryAssignmentElimination.access$use(this.this$0, name);
                    return;
                }
                super.visitNameRef(nameRef);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Iterable $receiver$iv = CollectUtilsKt.collectFreeVariables(x);
                for (T element$iv : $receiver$iv) {
                    JsName it;
                    JsName jsName = it = (JsName)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"it");
                    TemporaryAssignmentElimination.access$use(this.this$0, jsName);
                    TemporaryAssignmentElimination.access$use(this.this$0, it);
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visitFor(@NotNull JsFor x) {
                block6: {
                    JsVars it;
                    JsNode jsNode;
                    Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                    JsVars jsVars = x.getInitVars();
                    if (jsVars != null) {
                        it = jsNode = jsVars;
                        List<JsVars.JsVar> list2 = it.getVars();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.vars");
                        Iterable $receiver$iv = list2;
                        for (T element$iv : $receiver$iv) {
                            JsVars.JsVar it2;
                            JsVars.JsVar jsVar = it2 = (JsVars.JsVar)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"it");
                            if (jsVar.getInitExpression() != null) {
                                JsExpression jsExpression;
                                JsExpression it3 = jsExpression;
                                this.accept((JsNode)it3);
                            }
                        }
                    }
                    JsExpression jsExpression = x.getInitExpression();
                    if (jsExpression != null) {
                        it = jsNode = jsExpression;
                        this.accept((JsNode)it);
                    }
                    JsExpression jsExpression2 = x.getCondition();
                    if (jsExpression2 != null) {
                        it = jsNode = jsExpression2;
                        this.accept((JsNode)it);
                    }
                    JsStatement jsStatement = x.getBody();
                    if (jsStatement != null) {
                        it = jsNode = jsStatement;
                        this.accept((JsNode)it);
                    }
                    JsExpression jsExpression3 = x.getIncrementExpression();
                    if (jsExpression3 == null) break block6;
                    it = jsNode = jsExpression3;
                    this.accept((JsNode)it);
                }
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
        this.usages.keySet().retainAll((Collection)this.syntheticNames);
    }

    /*
     * WARNING - void declaration
     */
    private final UsageSequence getUsageSequence(JsName name) {
        UsageSequence usageSequence;
        Map<JsName, UsageSequence> $receiver$iv = this.usageSequences;
        UsageSequence value$iv = $receiver$iv.get(name);
        if (value$iv == null) {
            Integer n = this.referenceCount.get(name);
            if (n == null || n != 1) {
                return null;
            }
            Usage usage = this.usages.get(name);
            Usage usage2 = usage;
            UsageSequence mappedUsage = usage2 instanceof Usage.VariableAssignment ? new UsageSequence(usage, this.getUsageSequence(((Usage.VariableAssignment)usage).getTarget())) : (usage2 instanceof Usage.VariableDeclaration ? new UsageSequence(usage, this.getUsageSequence(((Usage.VariableDeclaration)usage).getTarget())) : (usage2 == null ? null : new UsageSequence(usage, null)));
            UsageSequence answer$iv = mappedUsage;
            $receiver$iv.put(name, answer$iv);
            usageSequence = answer$iv;
        } else {
            void var3_3;
            usageSequence = var3_3;
        }
        return usageSequence;
    }

    private final void calculateDeclarations() {
        Iterable $receiver$iv = this.usages.keySet();
        for (Object element$iv : $receiver$iv) {
            JsName it = (JsName)element$iv;
            this.getUsageSequence(it);
        }
        new RecursiveJsVisitor(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    Usage usage;
                    Object object = assignment.getFirst();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"assignment.first");
                    UsageSequence usageSequence = TemporaryAssignmentElimination.access$getUsageSequence(this.this$0, (JsName)object);
                    Usage usage2 = usage = usageSequence != null ? usageSequence.lastUsage() : null;
                    if (usage instanceof Usage.VariableDeclaration) {
                        Usage.VariableDeclaration variableDeclaration = (Usage.VariableDeclaration)usage;
                        int n = variableDeclaration.getCount();
                        variableDeclaration.setCount(n + 1);
                    }
                }
                super.visitExpressionStatement(x);
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void process() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryAssignmentElimination this$0;

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    void name;
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName jsName = (JsName)pair.component1();
                    JsExpression value = (JsExpression)pair.component2();
                    void v0 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"name");
                    UsageSequence usageSequence = TemporaryAssignmentElimination.access$getUsageSequence(this.this$0, (JsName)v0);
                    if (usageSequence != null) {
                        JsStatement jsStatement;
                        Sequence<JsStatement> sequence2;
                        Usage usage = usageSequence.lastUsage();
                        Object object = usage;
                        if (object instanceof Usage.Return) {
                            Sequence<JsStatement> $receiver = sequence2 = new Sequence<JsStatement>(value);
                            JsExpression jsExpression = x.getExpression();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                            $receiver.source(jsExpression.getSource());
                            jsStatement = (JsStatement)sequence2;
                        } else if (object instanceof Usage.VariableAssignment) {
                            JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(((Usage.VariableAssignment)usage).getTarget().makeRef(), value);
                            JsExpression jsExpression = x.getExpression();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                            JsExpression expr = jsBinaryOperation.source(jsExpression.getSource());
                            JsExpressionStatement statement2 = new JsExpressionStatement(expr);
                            MetadataProperties.setSynthetic(statement2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableAssignment)usage).getTarget()));
                            jsStatement = statement2;
                        } else if (object instanceof Usage.VariableDeclaration) {
                            JsStatement statement3;
                            JsStatement jsStatement2;
                            if (((Usage.VariableDeclaration)usage).getCount() > 1) {
                                JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(((Usage.VariableDeclaration)usage).getTarget().makeRef(), value);
                                JsExpression jsExpression = x.getExpression();
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                                JsExpression expr = jsBinaryOperation.source(jsExpression.getSource());
                                JsExpressionStatement result2 = new JsExpressionStatement(expr);
                                MetadataProperties.setSynthetic(result2, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                jsStatement2 = result2;
                            } else {
                                JsVars jsVars = JsAstUtils.newVar(((Usage.VariableDeclaration)usage).getTarget(), value);
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsVars, (String)"JsAstUtils.newVar(usage.target, value)");
                                JsVars declaration = jsVars;
                                JsExpression jsExpression = x.getExpression();
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                                declaration.source(jsExpression.getSource());
                                MetadataProperties.setSynthetic(declaration, TemporaryAssignmentElimination.access$getSyntheticNames$p(this.this$0).contains(((Usage.VariableDeclaration)usage).getTarget()));
                                jsStatement2 = declaration;
                            }
                            jsStatement = statement3 = jsStatement2;
                        } else if (object instanceof Usage.PropertyMutation) {
                            JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(((Usage.PropertyMutation)usage).getTarget(), value);
                            JsExpression jsExpression = x.getExpression();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                            jsStatement = new JsExpressionStatement(jsBinaryOperation.source(jsExpression.getSource()));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        JsStatement replacement = jsStatement;
                        TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                        ctx.replaceMe((JsNode)replacement);
                        object = TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0);
                        sequence2 = usageSequence.collectStatements();
                        CollectionsKt.addAll((Collection)object, sequence2);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsReturn x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsVars x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (TemporaryAssignmentElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    TemporaryAssignmentElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.removeMe();
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return false;
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void generateDeclarations() {
        int index2 = 0;
        Sequence $receiver$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.usages.values()), (Function1)generateDeclarations.1.INSTANCE), (Function1)generateDeclarations.2.INSTANCE);
        for (Object element$iv : $receiver$iv) {
            JsVars statement2;
            Usage.VariableDeclaration it = (Usage.VariableDeclaration)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)JsAstUtils.newVar(it.getTarget(), null), (String)"JsAstUtils.newVar(it.target, null)");
            MetadataProperties.setSynthetic(statement2, this.syntheticNames.contains(it.getTarget()));
            int n = index2;
            index2 = n + 1;
            this.root.getStatements().add(n, statement2);
        }
    }

    private final boolean tryRecord(JsExpression expr, Usage usage) {
        if (!(expr instanceof JsNameRef)) {
            return false;
        }
        JsName jsName = ((JsNameRef)expr).getName();
        if (jsName == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"expr.name ?: return false");
        JsName name = jsName;
        if (!this.namesToProcess.contains(name)) {
            return false;
        }
        Map<JsName, Usage> map2 = this.usages;
        Usage usage2 = usage;
        map2.put(name, usage2);
        return true;
    }

    private final void use(JsName name) {
        Map<JsName, Integer> map2 = this.referenceCount;
        Integer n = this.referenceCount.get(name);
        Integer n2 = 1 + (n != null ? n : 0);
        map2.put(name, n2);
    }

    public TemporaryAssignmentElimination(@NotNull JsBlock root2) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        this.root = root2;
        TemporaryAssignmentElimination temporaryAssignmentElimination = this;
        Object object = new LinkedHashMap();
        temporaryAssignmentElimination.referenceCount = object;
        temporaryAssignmentElimination = this;
        object = new LinkedHashMap();
        temporaryAssignmentElimination.usages = object;
        temporaryAssignmentElimination = this;
        temporaryAssignmentElimination.statementsToRemove = object = (Set)new LinkedHashSet();
        temporaryAssignmentElimination = this;
        temporaryAssignmentElimination.usageSequences = object = (Map)new LinkedHashMap();
        temporaryAssignmentElimination = this;
        temporaryAssignmentElimination.syntheticNames = object = (Set)new LinkedHashSet();
        temporaryAssignmentElimination = this;
        temporaryAssignmentElimination.namesToProcess = object = (Set)new LinkedHashSet();
    }

    public static final /* synthetic */ boolean access$tryRecord(TemporaryAssignmentElimination $this, @NotNull JsExpression expr, @NotNull Usage usage) {
        return $this.tryRecord(expr, usage);
    }

    @NotNull
    public static final /* synthetic */ Set access$getSyntheticNames$p(TemporaryAssignmentElimination $this) {
        return $this.syntheticNames;
    }

    @NotNull
    public static final /* synthetic */ Set access$getNamesToProcess$p(TemporaryAssignmentElimination $this) {
        return $this.namesToProcess;
    }

    public static final /* synthetic */ void access$use(TemporaryAssignmentElimination $this, @NotNull JsName name) {
        $this.use(name);
    }

    @Nullable
    public static final /* synthetic */ UsageSequence access$getUsageSequence(TemporaryAssignmentElimination $this, @NotNull JsName name) {
        return $this.getUsageSequence(name);
    }

    @NotNull
    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryAssignmentElimination $this) {
        return $this.statementsToRemove;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(TemporaryAssignmentElimination $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryAssignmentElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "getStatement", "()Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "PropertyMutation", "Return", "VariableAssignment", "VariableDeclaration", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$Return;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableAssignment;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableDeclaration;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$PropertyMutation;", "js.translator"})
    private static abstract class Usage {
        @NotNull
        private final JsStatement statement;

        @NotNull
        public final JsStatement getStatement() {
            return this.statement;
        }

        private Usage(JsStatement statement2) {
            this.statement = statement2;
        }

        public /* synthetic */ Usage(@NotNull JsStatement statement2, DefaultConstructorMarker $constructor_marker) {
            this(statement2);
        }

        @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$Return;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "js.translator"})
        public static final class Return
        extends Usage {
            public Return(@NotNull JsStatement statement2) {
                Intrinsics.checkParameterIsNotNull((Object)statement2, (String)"statement");
                super(statement2, null);
            }
        }

        @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableAssignment;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
        public static final class VariableAssignment
        extends Usage {
            @NotNull
            private final JsName target;

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }

            public VariableAssignment(@NotNull JsStatement statement2, @NotNull JsName target) {
                Intrinsics.checkParameterIsNotNull((Object)statement2, (String)"statement");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }
        }

        @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$VariableDeclaration;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "count", "", "getCount", "()I", "setCount", "(I)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
        public static final class VariableDeclaration
        extends Usage {
            private int count;
            @NotNull
            private final JsName target;

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            @NotNull
            public final JsName getTarget() {
                return this.target;
            }

            public VariableDeclaration(@NotNull JsStatement statement2, @NotNull JsName target) {
                Intrinsics.checkParameterIsNotNull((Object)statement2, (String)"statement");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }
        }

        @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage$PropertyMutation;", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)V", "getTarget", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.translator"})
        public static final class PropertyMutation
        extends Usage {
            @NotNull
            private final JsExpression target;

            @NotNull
            public final JsExpression getTarget() {
                return this.target;
            }

            public PropertyMutation(@NotNull JsStatement statement2, @NotNull JsExpression target) {
                Intrinsics.checkParameterIsNotNull((Object)statement2, (String)"statement");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                super(statement2, null);
                this.target = target;
            }
        }
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "", "value", "Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "next", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;)V", "getNext", "()Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$UsageSequence;", "getValue", "()Lorg/jetbrains/kotlin/js/inline/clean/TemporaryAssignmentElimination$Usage;", "collectStatements", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "lastUsage", "js.translator"})
    private static final class UsageSequence {
        @NotNull
        private final Usage value;
        @Nullable
        private final UsageSequence next;

        @NotNull
        public final Sequence<JsStatement> collectStatements() {
            return SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)this, (Function1)collectStatements.1.INSTANCE), (Function1)collectStatements.2.INSTANCE);
        }

        @NotNull
        public final Usage lastUsage() {
            return ((UsageSequence)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)this, (Function1)((Function1)lastUsage.1.INSTANCE)))).value;
        }

        @NotNull
        public final Usage getValue() {
            return this.value;
        }

        @Nullable
        public final UsageSequence getNext() {
            return this.next;
        }

        public UsageSequence(@NotNull Usage value, @Nullable UsageSequence next) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.value = value;
            this.next = next;
        }
    }
}

