/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.inline;

import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=2, xi=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r*\u0002H\fH\u0000\u00a2\u0006\u0002\u0010\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0003*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0018\u0010\t\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005\u00a8\u0006\u000f"}, d2={"inlineConstructor", "Lorg/jetbrains/kotlin/name/FqName;", "isFunctionInvoke", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "isKFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "needsInlining", "getNeedsInlining", "resolveFakeOverride", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "backend.js"})
public final class LegacyDescriptorUtilsKt {
    private static final FqName inlineConstructor = new FqName("konan.internal.InlineConstructor");

    @NotNull
    public static final <T extends CallableMemberDescriptor> T resolveFakeOverride(@NotNull T $receiver) {
        Object element$iv2;
        block3: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            CallableMemberDescriptor.Kind kind = $receiver.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind), (String)"this.kind");
            if (kind.isReal()) {
                return $receiver;
            }
            Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations($receiver);
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"OverridingUtil.getOverriddenDeclarations(this)");
            Set<CallableMemberDescriptor> overridden = set;
            Set<CallableMemberDescriptor> set2 = OverridingUtil.filterOutOverridden(overridden);
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"OverridingUtil.filterOutOverridden(overridden)");
            Set<CallableMemberDescriptor> filtered = set2;
            Iterable $receiver$iv = filtered;
            for (Object element$iv2 : $receiver$iv) {
                CallableMemberDescriptor it;
                CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
                if (!(callableMemberDescriptor.getModality() != Modality.ABSTRACT)) continue;
                break block3;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)((CallableMemberDescriptor)t);
    }

    public static final boolean isKFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        FunctionClassDescriptor.Kind kind = classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null;
        return kind == FunctionClassDescriptor.Kind.KFunction;
    }

    public static final boolean isFunctionInvoke(@NotNull FunctionDescriptor $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"dispatchReceiverParameter ?: return false");
        ReceiverParameterDescriptor dispatchReceiver = receiverParameterDescriptor;
        KotlinType kotlinType = dispatchReceiver.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"dispatchReceiver.type");
        boolean bl2 = bl = !LegacyDescriptorUtilsKt.isKFunctionType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType2 = dispatchReceiver.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"dispatchReceiver.type");
        return FunctionTypesKt.isFunctionType(kotlinType2) && $receiver.isOperator() && Intrinsics.areEqual((Object)$receiver.getName(), (Object)OperatorNameConventions.INVOKE);
    }

    public static final boolean getNeedsInlining(@NotNull FunctionDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean inlineConstructor = $receiver.getAnnotations().hasAnnotation(LegacyDescriptorUtilsKt.inlineConstructor);
        if (inlineConstructor) {
            return true;
        }
        return $receiver.isInline() && !$receiver.isExternal();
    }
}

