/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.SingletonDescriptor;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u001c\u0010\r\u001a\u00020\n2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/kotlin/container/SingletonTypeComponentDescriptor;", "Lorg/jetbrains/kotlin/container/SingletonDescriptor;", "container", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "klass", "Ljava/lang/Class;", "(Lorg/jetbrains/kotlin/container/ComponentContainer;Ljava/lang/Class;)V", "getKlass", "()Ljava/lang/Class;", "createInstance", "", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "createInstanceOf", "getDependencies", "", "Ljava/lang/reflect/Type;", "getRegistrations", "", "toString", ""})
public class SingletonTypeComponentDescriptor
extends SingletonDescriptor {
    @NotNull
    private final Class<?> klass;

    @Override
    @NotNull
    protected Object createInstance(@NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.createInstanceOf(this.klass, context);
    }

    @Override
    @NotNull
    public Iterable<Type> getRegistrations() {
        return CacheKt.getInfo(this.klass).getRegistrations();
    }

    /*
     * WARNING - void declaration
     */
    private final Object createInstanceOf(Class<?> klass2, ValueResolveContext context) {
        void $receiver$iv;
        ConstructorBinding binding = ResolveKt.bindToConstructor(klass2, context);
        this.setState(ComponentState.Initializing);
        for (ValueDescriptor argumentDescriptor : binding.getArgumentDescriptors()) {
            if (!(argumentDescriptor instanceof Closeable) || argumentDescriptor instanceof SingletonDescriptor) continue;
            this.registerDisposableObject((Closeable)((Object)argumentDescriptor));
        }
        Constructor<?> constructor = binding.getConstructor();
        List<Object> arguments2 = ResolveKt.computeArguments(binding.getArgumentDescriptors());
        Collection collection = arguments2;
        Constructor<?> constructor2 = constructor;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        Object obj = constructor2.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
        if (obj == null) {
            Intrinsics.throwNpe();
        }
        Object instance = obj;
        this.setState(ComponentState.Initialized);
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Type> getDependencies(@NotNull ValueResolveContext context) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ClassInfo classInfo = CacheKt.getInfo(this.klass);
        ConstructorInfo constructorInfo = classInfo.getConstructorInfo();
        Iterable iterable = constructorInfo != null ? constructorInfo.getParameters() : null;
        List list2 = iterable;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        iterable = classInfo.getSetterInfos();
        Collection collection = list2;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SetterInfo it = (SetterInfo)element$iv$iv;
            Iterable list$iv$iv = it.getParameters();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list3);
    }

    @NotNull
    public String toString() {
        return "Singleton: " + this.klass.getSimpleName();
    }

    @NotNull
    public final Class<?> getKlass() {
        return this.klass;
    }

    public SingletonTypeComponentDescriptor(@NotNull ComponentContainer container2, @NotNull Class<?> klass2) {
        Intrinsics.checkParameterIsNotNull((Object)container2, (String)"container");
        Intrinsics.checkParameterIsNotNull(klass2, (String)"klass");
        super(container2);
        this.klass = klass2;
    }
}

