/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiNameValuePairImpl
extends JavaStubPsiElement<PsiNameValuePairStub>
implements PsiNameValuePair {
    private volatile Reference<PsiAnnotationMemberValue> myDetachedValue;
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");

    public PsiNameValuePairImpl(@NotNull PsiNameValuePairStub stub2) {
        if (stub2 == null) {
            PsiNameValuePairImpl.$$$reportNull$$$0(0);
        }
        super(stub2, JavaStubElementTypes.NAME_VALUE_PAIR);
    }

    public PsiNameValuePairImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiNameValuePairImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    @NotNull
    public NameValuePairElement getNode() {
        NameValuePairElement nameValuePairElement = (NameValuePairElement)super.getNode();
        if (nameValuePairElement == null) {
            PsiNameValuePairImpl.$$$reportNull$$$0(2);
        }
        return nameValuePairElement;
    }

    @Override
    public String getName() {
        PsiNameValuePairStub stub2 = (PsiNameValuePairStub)this.getStub();
        if (stub2 == null) {
            PsiIdentifier nameIdentifier = this.getNameIdentifier();
            return nameIdentifier == null ? null : nameIdentifier.getText();
        }
        return stub2.getName();
    }

    @Override
    public String getLiteralValue() {
        PsiAnnotationMemberValue value = this.getValue();
        return value instanceof PsiLiteralExpression ? StringUtil.unquoteString(value.getText()) : null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        ASTNode node = this.getNode().findChildByRole(9);
        return node == null ? null : (PsiIdentifier)node.getPsi();
    }

    @Override
    public PsiAnnotationMemberValue getValue() {
        PsiLiteralExpression child = this.getStubOrPsiChild(JavaStubElementTypes.LITERAL_EXPRESSION);
        if (child != null) {
            return child;
        }
        ASTNode node = this.getNode().findChildByRole(249);
        return node == null ? null : (PsiAnnotationMemberValue)node.getPsi();
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            PsiNameValuePairImpl.$$$reportNull$$$0(3);
        }
        this.getValue().replace(newValue);
        PsiAnnotationMemberValue psiAnnotationMemberValue = this.getValue();
        if (psiAnnotationMemberValue == null) {
            PsiNameValuePairImpl.$$$reportNull$$$0(4);
        }
        return psiAnnotationMemberValue;
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue getDetachedValue() {
        PsiNameValuePairStub stub2 = (PsiNameValuePairStub)this.getStub();
        if (stub2 != null) {
            String text2 = stub2.getValue();
            PsiAnnotationMemberValue result2 = SoftReference.dereference(this.myDetachedValue);
            if (result2 == null) {
                PsiAnnotation anno = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText("@F(" + text2 + ")", this);
                ((LightVirtualFile)anno.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
                result2 = anno.findAttributeValue(null);
                this.myDetachedValue = new SoftReference<PsiAnnotationMemberValue>(result2);
            }
            return result2;
        }
        return this.getValue();
    }

    @Override
    public void subtreeChanged() {
        this.myDetachedValue = null;
        super.subtreeChanged();
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            @Nullable
            private PsiClass getReferencedClass() {
                LOG.assertTrue(PsiNameValuePairImpl.this.getParent() instanceof PsiAnnotationParameterList && PsiNameValuePairImpl.this.getParent().getParent() instanceof PsiAnnotation);
                PsiAnnotation annotation2 = (PsiAnnotation)PsiNameValuePairImpl.this.getParent().getParent();
                PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
                if (nameRef == null) {
                    return null;
                }
                PsiElement target = nameRef.resolve();
                return target instanceof PsiClass ? (PsiClass)target : null;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    PsiIdentifier psiIdentifier = nameIdentifier;
                    if (psiIdentifier == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiIdentifier;
                }
                PsiNameValuePairImpl psiNameValuePairImpl = PsiNameValuePairImpl.this;
                if (psiNameValuePairImpl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return psiNameValuePairImpl;
            }

            @Override
            @NotNull
            public TextRange getRangeInElement() {
                PsiIdentifier id = PsiNameValuePairImpl.this.getNameIdentifier();
                if (id != null) {
                    TextRange textRange = new TextRange(0, id.getTextLength());
                    if (textRange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }
                TextRange textRange = TextRange.EMPTY_RANGE;
                if (textRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            @Override
            public PsiElement resolve() {
                PsiClass refClass = this.getReferencedClass();
                if (refClass == null) {
                    return null;
                }
                String name = PsiNameValuePairImpl.this.getName();
                if (name == null) {
                    name = "value";
                }
                MethodSignature signature = MethodSignatureUtil.createMethodSignature(name, PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                return MethodSignatureUtil.findMethodBySignature(refClass, signature, false);
            }

            @Override
            @NotNull
            public String getCanonicalText() {
                String name = PsiNameValuePairImpl.this.getName();
                String string = name != null ? name : "value";
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            @Override
            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    PsiImplUtil.setName(nameIdentifier, newElementName);
                } else if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(PsiNameValuePairImpl.this.getNode().getFirstChildNode().getElementType())) {
                    PsiElementFactory factory2 = JavaPsiFacade.getInstance(PsiNameValuePairImpl.this.getProject()).getElementFactory();
                    nameIdentifier = factory2.createIdentifier(newElementName);
                    PsiNameValuePairImpl.this.addBefore(nameIdentifier, SourceTreeToPsiMap.treeElementToPsi(PsiNameValuePairImpl.this.getNode().getFirstChildNode()));
                }
                return PsiNameValuePairImpl.this;
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                throw new IncorrectOperationException("Not implemented");
            }

            @Override
            public boolean isReferenceTo(PsiElement element) {
                return element instanceof PsiMethod && element.equals(this.resolve());
            }

            @Override
            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    1.$$$reportNull$$$0(6);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            @Override
            public boolean isSoft() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 5: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 5: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiNameValuePairImpl.$$$reportNull$$$0(5);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitNameValuePair(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiNameValuePair";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

