/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.descriptors.DefaultImplsClassDescriptor;
import org.jetbrains.kotlin.backend.jvm.descriptors.DefaultImplsClassDescriptorImpl;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceDelegationLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "generateDelegationToDefaultImpl", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "interfaceFun", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "inheritedFun", "generateInterfaceMethods", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "lower", "backend"})
public final class InterfaceDelegationLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final GenerationState state;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        if (IrCodegenUtilsKt.isJvmInterface(irClass)) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
        this.generateInterfaceMethods(irClass, irClass.getDescriptor());
    }

    private final void generateInterfaceMethods(IrClass irClass, ClassDescriptor descriptor2) {
        ClassDescriptor classDescriptor2;
        ClassDescriptor classDescriptor3 = descriptor2;
        if (!(classDescriptor3 instanceof DefaultImplsClassDescriptor)) {
            classDescriptor3 = null;
        }
        if ((classDescriptor2 = (DefaultImplsClassDescriptor)classDescriptor3) == null || (classDescriptor2 = classDescriptor2.getCorrespondingInterface()) == null) {
            classDescriptor2 = descriptor2;
        }
        ClassDescriptor classDescriptor4 = classDescriptor2;
        Map<FunctionDescriptor, FunctionDescriptor> map2 = CodegenUtil.getNonPrivateTraitMethods(classDescriptor4);
        Iterator<Map.Entry<FunctionDescriptor, FunctionDescriptor>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            FunctionDescriptor functionDescriptor;
            Map.Entry<FunctionDescriptor, FunctionDescriptor> entry;
            Map.Entry<FunctionDescriptor, FunctionDescriptor> entry2 = entry = iterator2.next();
            FunctionDescriptor interfaceFun = entry2.getKey();
            entry2 = entry;
            FunctionDescriptor value = entry2.getValue();
            if (CodegenUtilKt.isDefinitelyNotDefaultImplsMethod(interfaceFun)) continue;
            if (classDescriptor4 != descriptor2) {
                ClassDescriptor classDescriptor5 = descriptor2;
                if (classDescriptor5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.backend.jvm.descriptors.DefaultImplsClassDescriptorImpl");
                }
                functionDescriptor = InterfaceLowering.Companion.createDefaultImplFunDescriptor((DefaultImplsClassDescriptorImpl)classDescriptor5, interfaceFun, classDescriptor4, this.state.getTypeMapper());
            } else {
                functionDescriptor = value;
            }
            FunctionDescriptor inheritedFun = functionDescriptor;
            this.generateDelegationToDefaultImpl(irClass, interfaceFun, inheritedFun);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDelegationToDefaultImpl(IrClass irClass, FunctionDescriptor interfaceFun, FunctionDescriptor inheritedFun) {
        void $receiver$iv$iv;
        int n;
        Object it;
        IrValueParameter irValueParameter;
        IrBlockBodyImpl irBody = new IrBlockBodyImpl(-1, -1);
        IrFunctionImpl irFunction = new IrFunctionImpl(-1, -1, IrDeclarationOrigin.DEFINED.INSTANCE, inheritedFun, irBody);
        IrUtilsKt.createParameterDeclarations(irFunction);
        irClass.getDeclarations().add(irFunction);
        DeclarationDescriptor declarationDescriptor = interfaceFun.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor interfaceDescriptor = (ClassDescriptor)declarationDescriptor;
        DefaultImplsClassDescriptorImpl defaultImpls = InterfaceLowering.Companion.createDefaultImplsClassDescriptor(interfaceDescriptor);
        FunctionDescriptor functionDescriptor = interfaceFun.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"interfaceFun.original");
        SimpleFunctionDescriptorImpl defaultImplFun = InterfaceLowering.Companion.createDefaultImplFunDescriptor(defaultImpls, functionDescriptor, interfaceDescriptor, this.state.getTypeMapper());
        KotlinType kotlinType = defaultImplFun.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"defaultImplFun.returnType!!");
        IrType irType = IrTypesKt.toIrType(kotlinType);
        if (irType == null) {
            Intrinsics.throwNpe();
        }
        irFunction.setReturnType(irType);
        KotlinType kotlinType2 = defaultImplFun.getReturnType();
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"defaultImplFun.returnType!!");
        IrType irType2 = IrTypesKt.toIrType(kotlinType2);
        if (irType2 == null) {
            Intrinsics.throwNpe();
        }
        IrCallImpl irCallImpl = new IrCallImpl(-1, -1, irType2, defaultImplFun, IrMemberAccessExpressionKt.getTypeParametersCount(defaultImplFun), (IrStatementOrigin)JvmLoweredStatementOrigin.DEFAULT_IMPLS_DELEGATION.INSTANCE, null, 64, null);
        irBody.getStatements().add(new IrReturnImpl(-1, -1, irFunction.getReturnType(), irFunction.getSymbol(), (IrExpression)irCallImpl));
        int offset2 = 0;
        IrValueParameter irValueParameter2 = irFunction.getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            irValueParameter = irValueParameter2;
            it = irValueParameter;
            irCallImpl.putValueArgument(offset2, new IrGetValueImpl(-1, -1, (IrValueSymbol)it.getSymbol(), null, 8, null));
            n = offset2;
            offset2 = n + 1;
        }
        IrValueParameter irValueParameter3 = irFunction.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            irValueParameter = irValueParameter3;
            it = irValueParameter;
            irCallImpl.putValueArgument(offset2, new IrGetValueImpl(-1, -1, (IrValueSymbol)it.getSymbol(), null, 8, null));
            n = offset2;
            offset2 = n + 1;
        }
        Iterable $receiver$iv = irFunction.getValueParameters();
        it = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void parameter;
            void i;
            int n2 = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n2;
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            int n4 = n3;
            Collection collection2 = collection;
            irCallImpl.putValueArgument((int)(i + offset2), new IrGetValueImpl(-1, -1, (IrValueSymbol)parameter.getSymbol(), null));
            Unit unit = Unit.INSTANCE;
            collection2.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    public InterfaceDelegationLowering(@NotNull GenerationState state2) {
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        this.state = state2;
    }
}

