/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationContainerLoweringPass;
import org.jetbrains.kotlin.backend.common.descriptors.UtilsKt;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VarargInjectionLowering;
import org.jetbrains.kotlin.backend.common.lower.VarargInjectionLowering$WhenMappings;
import org.jetbrains.kotlin.backend.common.lower.VarargLoweringKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionWithCopy;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrBackendUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004:;<=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0017\u001a\u00060\bR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J@\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\bR\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\u0006H\u0002J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J\u001a\u0010+\u001a\u00020'2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u001c\u00102\u001a\u00020\u001b*\u0002032\u0006\u0010!\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001bH\u0002J\u001c\u00105\u001a\u00020\u001b*\u0002032\u0006\u00106\u001a\u00020%2\u0006\u00104\u001a\u00020\u001bH\u0002J\f\u00107\u001a\u000208*\u000203H\u0002J \u00109\u001a\u00020\u001b*\u0002032\n\u0010\u001c\u001a\u00060\bR\u00020\u00002\u0006\u0010!\u001a\u00020\u001bH\u0002R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u00060\u0011R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "arrayToHandle", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$ArrayHandle;", "getArrayToHandle", "()Ljava/util/Map;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "intPlusInt", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "primitiveArrayHandles", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$PrimitiveArrayHandle;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "unsignedArrayHandles", "", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$UnsignedArrayHandle;", "arrayType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "calculateArraySize", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "arrayHandle", "hasSpreadElement", "", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "vars", "Lorg/jetbrains/kotlin/ir/expressions/IrVarargElement;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "log", "", "msg", "Lkotlin/Function0;", "", "lower", "irDeclarationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "owner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "increment", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "value", "incrementVariable", "variable", "intPlus", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "irArraySize", "ArrayHandle", "PrimitiveArrayHandle", "ReferenceArrayHandle", "UnsignedArrayHandle", "ir.backend.common"})
public final class VarargInjectionLowering
implements DeclarationContainerLoweringPass {
    private final Symbols<CommonBackendContext> symbols;
    private final IrSimpleFunction intPlusInt;
    private final Map<PrimitiveType, PrimitiveArrayHandle> primitiveArrayHandles;
    private final List<UnsignedArrayHandle> unsignedArrayHandles;
    @NotNull
    private final Map<IrClassSymbol, ArrayHandle> arrayToHandle;
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
        Intrinsics.checkParameterIsNotNull((Object)irDeclarationContainer, (String)"irDeclarationContainer");
        Iterable $receiver$iv = irDeclarationContainer.getDeclarations();
        for (Object element$iv : $receiver$iv) {
            IrDeclarationWithVisibility irDeclarationWithVisibility;
            IrDeclaration it = (IrDeclaration)element$iv;
            IrDeclaration irDeclaration = it;
            if (irDeclaration instanceof IrField) {
                this.lower((IrSymbol)((IrField)it).getSymbol(), ((IrField)it).getInitializer());
                continue;
            }
            if (irDeclaration instanceof IrFunction) {
                this.lower(((IrFunction)it).getSymbol(), ((IrFunction)it).getBody());
                continue;
            }
            if (!(irDeclaration instanceof IrProperty)) continue;
            if (((IrProperty)it).getBackingField() != null) {
                IrField field = irDeclarationWithVisibility;
                this.lower((IrSymbol)field.getSymbol(), field);
            }
            if (((IrProperty)it).getGetter() != null) {
                IrDeclarationWithVisibility getter2 = irDeclarationWithVisibility;
                this.lower(getter2.getSymbol(), getter2);
            }
            if (((IrProperty)it).getSetter() == null) continue;
            IrDeclarationWithVisibility setter2 = irDeclarationWithVisibility;
            this.lower(setter2.getSymbol(), setter2);
        }
    }

    private final void lower(IrSymbol owner, IrElement element) {
        block0: {
            IrElement irElement = element;
            if (irElement == null) break block0;
            IrElementTransformerVoidKt.transformChildrenVoid(irElement, new IrElementTransformerVoid(this, owner){
                @NotNull
                private final lower.2 transformer;
                final /* synthetic */ VarargInjectionLowering this$0;
                final /* synthetic */ IrSymbol $owner;

                @NotNull
                public final lower.2 getTransformer() {
                    return this.transformer;
                }

                /*
                 * WARNING - void declaration
                 */
                private final void replaceEmptyParameterWithEmptyArray(IrFunctionAccessExpression expression2) {
                    void $receiver$iv$iv;
                    Object it;
                    DeclarationIrBuilder declarationIrBuilder;
                    VarargInjectionLowering.access$log(this.this$0, (Function0)new Function0<String>(expression2){
                        final /* synthetic */ IrFunctionAccessExpression $expression;

                        @NotNull
                        public final String invoke() {
                            return "call of: " + this.$expression.getDescriptor();
                        }
                        {
                            this.$expression = irFunctionAccessExpression;
                            super(0);
                        }
                    });
                    DeclarationIrBuilder $receiver = declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), this.$owner, expression2.getStartOffset(), expression2.getEndOffset());
                    List<ValueParameterDescriptor> list2 = expression2.getDescriptor().getValueParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.descriptor.valueParameters");
                    Iterable $receiver$iv = list2;
                    for (T element$iv : $receiver$iv) {
                        it = (ValueParameterDescriptor)element$iv;
                        VarargInjectionLowering.access$log(this.this$0, (Function0)new Function0<String>((ValueParameterDescriptor)it, this, expression2){
                            final /* synthetic */ ValueParameterDescriptor $it;
                            final /* synthetic */ lower.2 this$0;
                            final /* synthetic */ IrFunctionAccessExpression $expression$inlined;
                            {
                                this.$it = valueParameterDescriptor;
                                this.this$0 = var2_2;
                                this.$expression$inlined = irFunctionAccessExpression;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                StringBuilder stringBuilder = new StringBuilder().append("varargElementType: ").append(this.$it.getVarargElementType()).append(" expr: ");
                                IrMemberAccessExpression irMemberAccessExpression = this.$expression$inlined;
                                ValueParameterDescriptor valueParameterDescriptor = this.$it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                                return stringBuilder.append(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(IrMemberAccessExpressionKt.getValueArgument(irMemberAccessExpression, valueParameterDescriptor))).toString();
                            }
                        });
                    }
                    $receiver$iv = expression2.getSymbol().getOwner().getValueParameters();
                    Iterator<T> iterator2 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (E element$iv$iv : $receiver$iv$iv) {
                        IrValueParameter it2 = (IrValueParameter)element$iv$iv;
                        if (!(it2.getVarargElementType() != null && expression2.getValueArgument(it2.getIndex()) == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    for (T element$iv : $receiver$iv) {
                        it = (IrValueParameter)element$iv;
                        int n = it.getIndex();
                        int n2 = $receiver.getStartOffset();
                        int n3 = $receiver.getEndOffset();
                        IrType irType = it.getType();
                        IrType irType2 = it.getVarargElementType();
                        if (irType2 == null) {
                            Intrinsics.throwNpe();
                        }
                        expression2.putValueArgument(n, new IrVarargImpl(n2, n3, irType, irType2));
                    }
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                }

                @NotNull
                public IrExpression visitCall(@NotNull IrCall expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    this.replaceEmptyParameterWithEmptyArray(expression2);
                    return expression2;
                }

                @NotNull
                public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    this.replaceEmptyParameterWithEmptyArray(expression2);
                    return expression2;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public IrExpression visitVararg(@NotNull IrVararg expression2) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Object object;
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this.transformer);
                    boolean hasSpreadElement = VarargInjectionLowering.access$hasSpreadElement(this.this$0, expression2);
                    if (!hasSpreadElement) {
                        boolean bl;
                        block14: {
                            Iterable $receiver$iv2 = expression2.getElements();
                            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                                bl = true;
                            } else {
                                object = $receiver$iv2.iterator();
                                while (object.hasNext()) {
                                    T element$iv = object.next();
                                    IrVarargElement it = (IrVarargElement)element$iv;
                                    if (it instanceof IrConst && IrTypePredicatesKt.isString(((IrConst)it).getType())) continue;
                                    bl = false;
                                    break block14;
                                }
                                bl = true;
                            }
                        }
                        if (bl) {
                            VarargInjectionLowering.access$log(this.this$0, lower.visitVararg.2.INSTANCE);
                            return expression2;
                        }
                    }
                    DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), this.$owner, expression2.getStartOffset(), expression2.getEndOffset());
                    Object $receiver = object = irBuilder;
                    IrType type2 = expression2.getVarargElementType();
                    VarargInjectionLowering.access$log(this.this$0, (Function0)new Function0<String>(type2, this, expression2, hasSpreadElement, irBuilder){
                        final /* synthetic */ IrType $type;
                        final /* synthetic */ lower.2 this$0;
                        final /* synthetic */ IrVararg $expression$inlined;
                        final /* synthetic */ boolean $hasSpreadElement$inlined;
                        final /* synthetic */ DeclarationIrBuilder $irBuilder$inlined;
                        {
                            this.$type = irType;
                            this.this$0 = var2_2;
                            this.$expression$inlined = irVararg;
                            this.$hasSpreadElement$inlined = bl;
                            this.$irBuilder$inlined = declarationIrBuilder;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$expression$inlined + ": array type:" + this.$type + ", is array of primitives " + !IrTypePredicatesKt.isArray(this.$expression$inlined.getType());
                        }
                    });
                    ArrayHandle arrayHandle = VarargInjectionLowering.access$arrayType(this.this$0, expression2.getType());
                    IrBlock block = VarargLoweringKt.access$irBlock((IrBuilderWithScope)$receiver, expression2.getType());
                    Iterable iterable = $receiver$iv = (Iterable)expression2.getElements();
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        IrVarargElement irVarargElement;
                        void it;
                        IrVarargElement irVarargElement2 = (IrVarargElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Scope scope = ((IrBuilderWithScope)$receiver).getScope();
                        Object v2 = it;
                        if (!(v2 instanceof IrSpreadElement)) {
                            v2 = null;
                        }
                        if ((irVarargElement = (IrSpreadElement)v2) == null || (irVarargElement = irVarargElement.getExpression()) == null) {
                            void v4 = it;
                            if (v4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                            }
                            irVarargElement = (IrExpression)v4;
                        }
                        IrVariable initVar = Scope.createTemporaryVariable$default(scope, (IrExpression)irVarargElement, UtilsKt.getSynthesizedString("elem"), true, null, null, 24, null);
                        block.getStatements().add(initVar);
                        Pair pair = TuplesKt.to((Object)it, (Object)initVar);
                        collection.add(pair);
                    }
                    Map vars = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                    IrExpression arraySize = VarargInjectionLowering.access$calculateArraySize(this.this$0, arrayHandle, hasSpreadElement, ((IrBuilderWithScope)$receiver).getScope(), expression2, vars);
                    IrExpression array = arrayHandle.createArray((IrBuilderWithScope)$receiver, expression2.getVarargElementType(), arraySize);
                    IrVariable arrayTmpVariable = Scope.createTemporaryVariable$default(((IrBuilderWithScope)$receiver).getScope(), array, UtilsKt.getSynthesizedString("array"), true, null, null, 24, null);
                    IrVariable indexTmpVariable = Scope.createTemporaryVariable$default(((IrBuilderWithScope)$receiver).getScope(), VarargLoweringKt.access$getKIntZero$p((IrBuilderWithScope)$receiver), UtilsKt.getSynthesizedString("index"), true, null, null, 24, null);
                    block.getStatements().add(arrayTmpVariable);
                    if (hasSpreadElement) {
                        block.getStatements().add(indexTmpVariable);
                    }
                    Iterable $receiver$iv3 = expression2.getElements();
                    int index$iv = 0;
                    for (T item$iv : $receiver$iv3) {
                        IrCall irCall;
                        DeclarationIrBuilder declarationIrBuilder;
                        void element;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        int n2 = n;
                        IrVarargElement irVarargElement = (IrVarargElement)item$iv;
                        int i = n2;
                        irBuilder.setStartOffset(element.getStartOffset());
                        irBuilder.setEndOffset(element.getEndOffset());
                        DeclarationIrBuilder $receiver2 = declarationIrBuilder = irBuilder;
                        VarargInjectionLowering.access$log(this.this$0, (Function0)new Function0<String>(i, (IrVarargElement)element, vars, arrayHandle, arrayTmpVariable, indexTmpVariable, block, this, expression2, hasSpreadElement, irBuilder){
                            final /* synthetic */ int $i$inlined;
                            final /* synthetic */ IrVarargElement $element$inlined;
                            final /* synthetic */ Map $vars$inlined;
                            final /* synthetic */ ArrayHandle $arrayHandle$inlined;
                            final /* synthetic */ IrVariable $arrayTmpVariable$inlined;
                            final /* synthetic */ IrVariable $indexTmpVariable$inlined;
                            final /* synthetic */ IrBlock $block$inlined;
                            final /* synthetic */ lower.2 this$0;
                            final /* synthetic */ IrVararg $expression$inlined;
                            final /* synthetic */ boolean $hasSpreadElement$inlined;
                            final /* synthetic */ DeclarationIrBuilder $irBuilder$inlined;
                            {
                                this.$i$inlined = n;
                                this.$element$inlined = irVarargElement;
                                this.$vars$inlined = map2;
                                this.$arrayHandle$inlined = arrayHandle;
                                this.$arrayTmpVariable$inlined = irVariable;
                                this.$indexTmpVariable$inlined = irVariable2;
                                this.$block$inlined = irBlock2;
                                this.this$0 = var8_8;
                                this.$expression$inlined = irVararg;
                                this.$hasSpreadElement$inlined = bl;
                                this.$irBuilder$inlined = declarationIrBuilder;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "element:" + this.$i$inlined + "> " + org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(this.$element$inlined);
                            }
                        });
                        V v2 = vars.get(element);
                        if (v2 == null) {
                            Intrinsics.throwNpe();
                        }
                        IrVariable dst = (IrVariable)v2;
                        if (!(element instanceof IrSpreadElement)) {
                            IrCall setArrayElementCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$receiver2, arrayHandle.getSetMethodSymbol().getOwner());
                            setArrayElementCall.setDispatchReceiver(ExpressionHelpersKt.irGet($receiver2, arrayTmpVariable));
                            setArrayElementCall.putValueArgument(0, hasSpreadElement ? (IrExpressionWithCopy)ExpressionHelpersKt.irGet($receiver2, indexTmpVariable) : (IrExpressionWithCopy)VarargLoweringKt.access$irConstInt($receiver2, i));
                            setArrayElementCall.putValueArgument(1, ExpressionHelpersKt.irGet($receiver2, dst));
                            block.getStatements().add(setArrayElementCall);
                            if (!hasSpreadElement) continue;
                            block.getStatements().add(VarargInjectionLowering.access$incrementVariable(this.this$0, $receiver2, indexTmpVariable, VarargLoweringKt.access$getKIntOne$p($receiver2)));
                            continue;
                        }
                        IrVariable arraySizeVariable = Scope.createTemporaryVariable$default($receiver2.getScope(), VarargInjectionLowering.access$irArraySize(this.this$0, $receiver2, arrayHandle, ExpressionHelpersKt.irGet($receiver2, dst)), UtilsKt.getSynthesizedString("length"), false, null, null, 28, null);
                        block.getStatements().add(arraySizeVariable);
                        IrCall $receiver3 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$receiver2, arrayHandle.getCopyRangeToSymbol().getOwner());
                        $receiver3.setExtensionReceiver(ExpressionHelpersKt.irGet($receiver2, dst));
                        $receiver3.putValueArgument(0, ExpressionHelpersKt.irGet($receiver2, arrayTmpVariable));
                        $receiver3.putValueArgument(1, VarargLoweringKt.access$getKIntZero$p($receiver2));
                        $receiver3.putValueArgument(2, ExpressionHelpersKt.irGet($receiver2, arraySizeVariable));
                        $receiver3.putValueArgument(3, ExpressionHelpersKt.irGet($receiver2, indexTmpVariable));
                        IrCall copyCall = irCall;
                        block.getStatements().add(copyCall);
                        block.getStatements().add(VarargInjectionLowering.access$incrementVariable(this.this$0, $receiver2, indexTmpVariable, ExpressionHelpersKt.irGet($receiver2, arraySizeVariable)));
                        VarargInjectionLowering.access$log(this.this$0, (Function0)new Function0<String>(i, (IrVarargElement)element, vars, arrayHandle, arrayTmpVariable, indexTmpVariable, block, this, expression2, hasSpreadElement, irBuilder){
                            final /* synthetic */ int $i$inlined;
                            final /* synthetic */ IrVarargElement $element$inlined;
                            final /* synthetic */ Map $vars$inlined;
                            final /* synthetic */ ArrayHandle $arrayHandle$inlined;
                            final /* synthetic */ IrVariable $arrayTmpVariable$inlined;
                            final /* synthetic */ IrVariable $indexTmpVariable$inlined;
                            final /* synthetic */ IrBlock $block$inlined;
                            final /* synthetic */ lower.2 this$0;
                            final /* synthetic */ IrVararg $expression$inlined;
                            final /* synthetic */ boolean $hasSpreadElement$inlined;
                            final /* synthetic */ DeclarationIrBuilder $irBuilder$inlined;
                            {
                                this.$i$inlined = n;
                                this.$element$inlined = irVarargElement;
                                this.$vars$inlined = map2;
                                this.$arrayHandle$inlined = arrayHandle;
                                this.$arrayTmpVariable$inlined = irVariable;
                                this.$indexTmpVariable$inlined = irVariable2;
                                this.$block$inlined = irBlock2;
                                this.this$0 = var8_8;
                                this.$expression$inlined = irVararg;
                                this.$hasSpreadElement$inlined = bl;
                                this.$irBuilder$inlined = declarationIrBuilder;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "element:" + this.$i$inlined + ":spread element> " + org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.ir2string(((IrSpreadElement)this.$element$inlined).getExpression());
                            }
                        });
                    }
                    block.getStatements().add(ExpressionHelpersKt.irGet((IrBuilderWithScope)$receiver, arrayTmpVariable));
                    return block;
                }
                {
                    this.this$0 = $outer;
                    this.$owner = $captured_local_variable$1;
                    this.transformer = this;
                }
            });
        }
    }

    private final ArrayHandle arrayType(IrType type2) {
        IrClassifierSymbol arrayClass = IrTypesKt.getClassifierOrFail(type2);
        Object object = this.arrayToHandle;
        ArrayHandle arrayHandle = object.get(arrayClass);
        if (arrayHandle == null) {
            object = arrayClass.getDescriptor();
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return arrayHandle;
    }

    private final IrCall intPlus(@NotNull IrBuilderWithScope $receiver) {
        return ExpressionHelpersKt.irCall($receiver, this.intPlusInt);
    }

    private final IrExpression increment(@NotNull IrBuilderWithScope $receiver, IrExpression expression2, IrExpression value) {
        IrCall irCall;
        IrCall $receiver2 = irCall = this.intPlus($receiver);
        $receiver2.setDispatchReceiver(expression2);
        $receiver2.putValueArgument(0, value);
        return irCall;
    }

    private final IrExpression incrementVariable(@NotNull IrBuilderWithScope $receiver, IrVariable variable2, IrExpression value) {
        IrCall irCall = this.intPlus($receiver);
        IrVariableSymbol irVariableSymbol = (IrVariableSymbol)variable2.getSymbol();
        IrBuilderWithScope irBuilderWithScope = $receiver;
        IrCall $receiver2 = irCall;
        $receiver2.setDispatchReceiver(ExpressionHelpersKt.irGet($receiver, variable2));
        $receiver2.putValueArgument(0, value);
        IrCall irCall2 = irCall;
        return ExpressionHelpersKt.irSetVar(irBuilderWithScope, irVariableSymbol, irCall2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression calculateArraySize(ArrayHandle arrayHandle, boolean hasSpreadElement, Scope scope, IrVararg expression2, Map<IrVarargElement, ? extends IrVariable> vars) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        Object it;
        Object element$iv$iv22;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        DeclarationIrBuilder declarationIrBuilder;
        DeclarationIrBuilder $receiver = declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, scope.getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        if (!hasSpreadElement) {
            return VarargLoweringKt.access$irConstInt($receiver, expression2.getElements().size());
        }
        Iterable iterable = $receiver$iv2 = (Iterable)expression2.getElements();
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv22 : $receiver$iv$iv2) {
            it = (IrVarargElement)element$iv$iv22;
            if (!(!(it instanceof IrSpreadElement))) continue;
            destination$iv$iv.add(element$iv$iv22);
        }
        int notSpreadElementCount = ((List)destination$iv$iv).size();
        IrConst irConst = VarargLoweringKt.access$irConstInt($receiver, notSpreadElementCount);
        if (irConst == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        IrExpression initialValue = irConst;
        destination$iv$iv = $receiver$iv = vars;
        Map destination$iv$iv2 = new LinkedHashMap();
        element$iv$iv22 = $receiver$iv$iv;
        for (Map.Entry entry : element$iv$iv22.entrySet()) {
            Map.Entry it2 = entry;
            if (!(it2.getKey() instanceof IrSpreadElement)) continue;
            destination$iv$iv2.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = MapsKt.toList((Map)destination$iv$iv2);
        IrExpression accumulator$iv = initialValue;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            it = (Pair)element$iv;
            IrExpression irExpression = accumulator$iv;
            IrExpression arraySize = this.irArraySize($receiver, arrayHandle, ExpressionHelpersKt.irGet($receiver, (IrValueDeclaration)it.getSecond()));
            accumulator$iv = this.increment($receiver, irExpression, arraySize);
        }
        return accumulator$iv;
    }

    private final IrExpression irArraySize(@NotNull IrBuilderWithScope $receiver, ArrayHandle arrayHandle, IrExpression expression2) {
        IrCall irCall;
        IrCall $receiver2 = irCall = ExpressionHelpersKt.irCall($receiver, arrayHandle.getSizeGetterSymbol().getOwner());
        $receiver2.setDispatchReceiver(expression2);
        IrCall arraySize = irCall;
        return arraySize;
    }

    private final boolean hasSpreadElement(IrVararg expression2) {
        boolean bl;
        block5: {
            Object object = expression2;
            if (object != null && (object = object.getElements()) != null) {
                Iterable $receiver$iv = (Iterable)object;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        IrVarargElement it = (IrVarargElement)element$iv;
                        if (!(it instanceof IrSpreadElement)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void log(Function0<String> msg) {
        this.context.log((Function0<String>)((Function0)new Function0<String>(msg){
            final /* synthetic */ Function0 $msg;

            @NotNull
            public final String invoke() {
                return "VARARG-INJECTOR:    " + (String)this.$msg.invoke();
            }
            {
                this.$msg = function0;
                super(0);
            }
        }));
    }

    @NotNull
    public final Map<IrClassSymbol, ArrayHandle> getArrayToHandle() {
        return this.arrayToHandle;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public VarargInjectionLowering(@NotNull CommonBackendContext context) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.symbols = this.context.getIr().getSymbols();
        this.intPlusInt = (IrSimpleFunction)this.symbols.getIntPlusInt().getOwner();
        PrimitiveType[] primitiveTypeArray = PrimitiveType.values();
        VarargInjectionLowering varargInjectionLowering = this;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$receiver$iv).length), (int)16);
        void var4_7 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        for (void element$iv$iv : $receiver$iv$iv2) {
            Map map2 = destination$iv$iv;
            void it = element$iv$iv;
            Pair pair = TuplesKt.to((Object)it, (Object)new PrimitiveArrayHandle((PrimitiveType)it));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Object object = destination$iv$iv;
        varargInjectionLowering.primitiveArrayHandles = object;
        $receiver$iv = UnsignedType.values();
        varargInjectionLowering = this;
        UnsignedType[] capacity$iv22 = $receiver$iv;
        Object destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv;
        int n = ((void)iterator2).length;
        for (int i = 0; i < n; ++i) {
            UnsignedArrayHandle unsignedArrayHandle;
            UnsignedArrayHandle unsignedArrayHandle2;
            void element$iv$iv$iv;
            void element$iv$iv;
            void unsignedType = element$iv$iv = (element$iv$iv$iv = iterator2[i]);
            if (this.symbols.getUnsignedArrays().get(unsignedType) != null) {
                PrimitiveType primitiveType;
                IrClassSymbol irClassSymbol;
                IrClassSymbol it = irClassSymbol;
                switch (VarargInjectionLowering$WhenMappings.$EnumSwitchMapping$0[unsignedType.ordinal()]) {
                    case 1: {
                        primitiveType = PrimitiveType.BYTE;
                        break;
                    }
                    case 2: {
                        primitiveType = PrimitiveType.SHORT;
                        break;
                    }
                    case 3: {
                        primitiveType = PrimitiveType.INT;
                        break;
                    }
                    case 4: {
                        primitiveType = PrimitiveType.LONG;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                PrimitiveType primitiveType2 = primitiveType;
                PrimitiveArrayHandle primitiveArrayHandle = this.primitiveArrayHandles.get((Object)primitiveType2);
                if (primitiveArrayHandle == null) {
                    Intrinsics.throwNpe();
                }
                unsignedArrayHandle2 = new UnsignedArrayHandle(it, primitiveArrayHandle);
            } else {
                unsignedArrayHandle2 = null;
            }
            if (unsignedArrayHandle2 == null) continue;
            UnsignedArrayHandle it$iv$iv = unsignedArrayHandle = unsignedArrayHandle2;
            destination$iv$iv2.add(it$iv$iv);
        }
        varargInjectionLowering.unsignedArrayHandles = object = (List)destination$iv$iv2;
        $receiver$iv = CollectionsKt.plus((Collection)CollectionsKt.plus(this.primitiveArrayHandles.values(), (Iterable)this.unsignedArrayHandles), (Object)new ReferenceArrayHandle());
        varargInjectionLowering = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv2 = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv2) {
            void it;
            ArrayHandle arrayHandle = (ArrayHandle)element$iv$iv;
            object = destination$iv$iv;
            IrClassSymbol irClassSymbol = it.getArraySymbol();
            object.put(irClassSymbol, element$iv$iv);
        }
        varargInjectionLowering.arrayToHandle = object = destination$iv$iv;
    }

    public static final /* synthetic */ void access$log(VarargInjectionLowering $this, @NotNull Function0 msg) {
        $this.log((Function0<String>)msg);
    }

    public static final /* synthetic */ boolean access$hasSpreadElement(VarargInjectionLowering $this, @Nullable IrVararg expression2) {
        return $this.hasSpreadElement(expression2);
    }

    @NotNull
    public static final /* synthetic */ ArrayHandle access$arrayType(VarargInjectionLowering $this, @NotNull IrType type2) {
        return $this.arrayType(type2);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$calculateArraySize(VarargInjectionLowering $this, @NotNull ArrayHandle arrayHandle, boolean hasSpreadElement, @NotNull Scope scope, @NotNull IrVararg expression2, @NotNull Map vars) {
        return $this.calculateArraySize(arrayHandle, hasSpreadElement, scope, expression2, vars);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$incrementVariable(VarargInjectionLowering $this, @NotNull IrBuilderWithScope $receiver, @NotNull IrVariable variable2, @NotNull IrExpression value) {
        return $this.incrementVariable($receiver, variable2, value);
    }

    @NotNull
    public static final /* synthetic */ IrExpression access$irArraySize(VarargInjectionLowering $this, @NotNull IrBuilderWithScope $receiver, @NotNull ArrayHandle arrayHandle, @NotNull IrExpression expression2) {
        return $this.irArraySize($receiver, arrayHandle, expression2);
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$ArrayHandle;", "", "arraySymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "(Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;)V", "getArraySymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "copyRangeToSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getCopyRangeToSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "setMethodSymbol", "getSetMethodSymbol", "singleParameterConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getSingleParameterConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "sizeGetterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getSizeGetterSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "createArray", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "elementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "size", "ir.backend.common"})
    public abstract class ArrayHandle {
        @NotNull
        private final IrSimpleFunctionSymbol setMethodSymbol;
        @NotNull
        private final IrFunctionSymbol sizeGetterSymbol;
        @NotNull
        private final IrSimpleFunctionSymbol copyRangeToSymbol;
        @NotNull
        private final IrConstructor singleParameterConstructor;
        @NotNull
        private final IrClassSymbol arraySymbol;

        @NotNull
        public final IrSimpleFunctionSymbol getSetMethodSymbol() {
            return this.setMethodSymbol;
        }

        @NotNull
        public final IrFunctionSymbol getSizeGetterSymbol() {
            return this.sizeGetterSymbol;
        }

        @NotNull
        public final IrSimpleFunctionSymbol getCopyRangeToSymbol() {
            return this.copyRangeToSymbol;
        }

        @NotNull
        protected final IrConstructor getSingleParameterConstructor() {
            return this.singleParameterConstructor;
        }

        @NotNull
        public abstract IrExpression createArray(@NotNull IrBuilderWithScope var1, @NotNull IrType var2, @NotNull IrExpression var3);

        @NotNull
        public final IrClassSymbol getArraySymbol() {
            return this.arraySymbol;
        }

        /*
         * WARNING - void declaration
         */
        public ArrayHandle(@NotNull IrClassSymbol arraySymbol) {
            Iterator iterator2;
            Iterator iterator3;
            block7: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)arraySymbol, (String)"arraySymbol");
                this.arraySymbol = arraySymbol;
                Object object = IrUtilsKt.getFunctions(this.arraySymbol);
                ArrayHandle arrayHandle = this;
                Iterator single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv) {
                    IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getDescriptor().getName(), (Object)OperatorNameConventions.SET)) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = (Iterator)element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                iterator3 = single$iv;
                arrayHandle.setMethodSymbol = (IrSimpleFunctionSymbol)((Object)iterator3);
                IrFunctionSymbol irFunctionSymbol = IrBackendUtilsKt.getPropertyGetter(this.arraySymbol, "size");
                if (irFunctionSymbol == null) {
                    Intrinsics.throwNpe();
                }
                this.sizeGetterSymbol = irFunctionSymbol;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = VarargInjectionLowering.this.symbols.getCopyRangeTo().get(this.arraySymbol.getDescriptor());
                if (irSimpleFunctionSymbol == null) {
                    Intrinsics.throwNpe();
                }
                this.copyRangeToSymbol = irSimpleFunctionSymbol;
                object = IrUtilsKt.getConstructors((IrClass)this.arraySymbol.getOwner());
                arrayHandle = this;
                Object object2 = object;
                for (Iterator iterator4 : object2) {
                    IrConstructor it = (IrConstructor)((Object)iterator4);
                    if (!(it.getValueParameters().size() == 1)) continue;
                    iterator2 = iterator4;
                    break block7;
                }
                iterator2 = null;
            }
            Iterator iterator5 = iterator3 = iterator2;
            if (iterator5 == null) {
                Intrinsics.throwNpe();
            }
            arrayHandle.singleParameterConstructor = (IrConstructor)((Object)iterator5);
        }
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$ReferenceArrayHandle;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$ArrayHandle;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;", "(Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;)V", "createArray", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "elementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "size", "ir.backend.common"})
    public final class ReferenceArrayHandle
    extends ArrayHandle {
        @Override
        @NotNull
        public IrExpression createArray(@NotNull IrBuilderWithScope builder, @NotNull IrType elementType, @NotNull IrExpression size) {
            IrCall irCall;
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            IrCall $receiver = irCall = ExpressionHelpersKt.irCall(builder, this.getSingleParameterConstructor());
            $receiver.putTypeArgument(0, elementType);
            $receiver.putValueArgument(0, size);
            return irCall;
        }

        public ReferenceArrayHandle() {
            super(VarargInjectionLowering.this.symbols.getArray());
        }
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$PrimitiveArrayHandle;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$ArrayHandle;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "(Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;Lorg/jetbrains/kotlin/builtins/PrimitiveType;)V", "createArray", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "elementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "size", "ir.backend.common"})
    public final class PrimitiveArrayHandle
    extends ArrayHandle {
        @Override
        @NotNull
        public IrExpression createArray(@NotNull IrBuilderWithScope builder, @NotNull IrType elementType, @NotNull IrExpression size) {
            IrCall irCall;
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            IrCall $receiver = irCall = ExpressionHelpersKt.irCall(builder, this.getSingleParameterConstructor());
            $receiver.putValueArgument(0, size);
            return irCall;
        }

        public PrimitiveArrayHandle(@NotNull PrimitiveType primitiveType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)primitiveType), (String)"primitiveType");
            IrClassSymbol irClassSymbol = VarargInjectionLowering.this.symbols.getPrimitiveArrays().get((Object)primitiveType);
            if (irClassSymbol == null) {
                Intrinsics.throwNpe();
            }
            super(irClassSymbol);
        }
    }

    @Metadata(mv={1, 1, 12}, bv={1, 0, 3}, k=1, xi=2, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$UnsignedArrayHandle;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$ArrayHandle;", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;", "arraySymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "wrappedArrayHandle", "Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$PrimitiveArrayHandle;", "(Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lorg/jetbrains/kotlin/backend/common/lower/VarargInjectionLowering$PrimitiveArrayHandle;)V", "createArray", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "elementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "size", "ir.backend.common"})
    public final class UnsignedArrayHandle
    extends ArrayHandle {
        private final PrimitiveArrayHandle wrappedArrayHandle;

        @Override
        @NotNull
        public IrExpression createArray(@NotNull IrBuilderWithScope builder, @NotNull IrType elementType, @NotNull IrExpression size) {
            IrCall irCall;
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            IrExpression wrappedArray = this.wrappedArrayHandle.createArray(builder, elementType, size);
            IrCall $receiver = irCall = ExpressionHelpersKt.irCall(builder, this.getSingleParameterConstructor());
            $receiver.putValueArgument(0, wrappedArray);
            return irCall;
        }

        public UnsignedArrayHandle(@NotNull IrClassSymbol arraySymbol, @NotNull PrimitiveArrayHandle wrappedArrayHandle) {
            Intrinsics.checkParameterIsNotNull((Object)arraySymbol, (String)"arraySymbol");
            Intrinsics.checkParameterIsNotNull((Object)wrappedArrayHandle, (String)"wrappedArrayHandle");
            super(arraySymbol);
            this.wrappedArrayHandle = wrappedArrayHandle;
        }
    }
}

